/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormTextField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFormField
extends AbstractSwingXFormField<JPanel>
implements XFormTextField {
    private static final Logger log = Logger.getLogger(FileFormField.class);
    private JTextField textField;
    private final XForm.FieldType type;
    private JButton selectDirectoryButton;
    private String projectRoot;
    private boolean updating;
    private String oldValue;
    private String currentDirectory;

    public FileFormField(String tooltip, XForm.FieldType type) {
        super(new JPanel());
        this.type = type;
        ButtonBarBuilder builder = new ButtonBarBuilder((JPanel)this.getComponent());
        this.textField = new JUndoableTextField(30);
        this.textField.setToolTipText(tooltip);
        builder.addGriddedGrowing((JComponent)this.textField);
        builder.addRelatedGap();
        this.selectDirectoryButton = new JButton(new SelectDirectoryAction());
        builder.addFixed((JComponent)this.selectDirectoryButton);
        this.textField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                String text = FileFormField.this.textField.getText();
                if (!FileFormField.this.updating) {
                    FileFormField.this.fireValueChanged(text, FileFormField.this.oldValue);
                }
                FileFormField.this.oldValue = text;
            }
        });
    }

    @Override
    public void setValue(String value) {
        this.updating = true;
        this.oldValue = null;
        this.updateValue(value);
        this.updating = false;
    }

    private void updateValue(String value) {
        if (value != null && this.projectRoot != null && value.startsWith(this.projectRoot)) {
            if (value.equals(this.projectRoot)) {
                value = "";
            } else if (value.length() > this.projectRoot.length() + 1) {
                value = value.substring(this.projectRoot.length() + 1);
            }
        }
        this.textField.setText(value);
    }

    @Override
    public String getValue() {
        String tempName;
        String text = this.textField.getText().trim();
        if (this.projectRoot != null && text.length() > 0 && new File(tempName = this.projectRoot + File.separatorChar + text).exists()) {
            text = tempName;
        }
        return text;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.selectDirectoryButton.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    @Override
    public void setProperty(String name, Object value) {
        super.setProperty(name, value);
        if (name.equals(ProjectSettings.PROJECT_ROOT) && this.type == XForm.FieldType.PROJECT_FOLDER) {
            this.projectRoot = (String)value;
            log.debug((Object)("Set projectRoot to [" + this.projectRoot + "]"));
        } else if (name.equals(CURRENT_DIRECTORY)) {
            this.currentDirectory = (String)value;
            log.debug((Object)("Set projectRoot to [" + this.projectRoot + "]"));
        }
    }

    @Override
    public void setWidth(int columns) {
        this.textField.setColumns(columns);
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public class SelectDirectoryAction
    extends AbstractAction {
        private JFileChooser fileChooser;

        public SelectDirectoryAction() {
            super("Browse...");
        }

        public void actionPerformed(ActionEvent e) {
            String value;
            if (this.fileChooser == null) {
                if (FileFormField.this.type == XForm.FieldType.FILE_OR_FOLDER) {
                    this.fileChooser = new JFileChooser();
                    this.fileChooser.setFileSelectionMode(2);
                } else {
                    this.fileChooser = FileFormField.this.type == XForm.FieldType.FOLDER || FileFormField.this.type == XForm.FieldType.PROJECT_FOLDER ? new JDirectoryChooser() : new JFileChooser();
                }
            }
            if ((value = FileFormField.this.getValue()).length() > 0) {
                this.fileChooser.setSelectedFile(new File(value));
            } else if (FileFormField.this.currentDirectory != null) {
                this.fileChooser.setCurrentDirectory(new File(FileFormField.this.currentDirectory));
            } else if (FileFormField.this.projectRoot != null) {
                this.fileChooser.setCurrentDirectory(new File(FileFormField.this.projectRoot));
            }
            int returnVal = this.fileChooser.showOpenDialog(UISupport.getMainFrame());
            if (returnVal == 0) {
                FileFormField.this.updateValue(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

