/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.tools.JarPackager;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAsWar {
    protected static final String SOAPUI_SETTINGS = "[soapUISettings]";
    protected static final String PROJECT_FILE_NAME = "[ProjectFileName]";
    protected static final String MOCKSERVICE_ENDPOINT = "[mockServiceEndpoint]";
    protected File projectFile;
    protected File settingsFile;
    protected File warDir;
    private File warFile;
    protected File webInf;
    private File lib;
    private File soapuiDir;
    protected Logger log = Logger.getLogger(MockAsWar.class);
    private boolean includeExt;
    protected boolean includeActions;
    protected boolean includeListeners;
    private File actionsDir;
    private File listenersDir;
    protected final String localEndpoint;
    protected boolean enableWebUI;

    public MockAsWar(String projectPath, String settingsPath, String warDir, String warFile, boolean includeExt, boolean actions, boolean listeners, String localEndpoint, boolean enableWebUI) {
        this.localEndpoint = localEndpoint;
        this.projectFile = new File(projectPath);
        this.settingsFile = StringUtils.hasContent(settingsPath) ? new File(settingsPath) : null;
        File file = this.warDir = warDir.length() > 0 ? new File(warDir) : new File(System.getProperty("java.io.tmpdir"), "warasmock");
        if (!this.warDir.exists()) {
            this.warDir.mkdir();
        }
        this.warFile = warFile.length() == 0 ? null : new File(warFile);
        this.includeExt = includeExt;
        this.includeActions = actions;
        this.includeListeners = listeners;
        this.enableWebUI = enableWebUI;
    }

    public void createMockAsWarArchive() {
        XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Creating War File", 3, "Building war file..", false);
        Worker.WorkerAdapter warWorker = new Worker.WorkerAdapter(){

            public Object construct(XProgressMonitor monitor) {
                if (MockAsWar.this.prepareWarFile()) {
                    MockAsWar.this.createWebXml();
                    if (MockAsWar.this.warFile != null) {
                        File[] filez = MockAsWar.this.getAllFilesFrom(MockAsWar.this.webInf).toArray(new File[0]);
                        JarPackager.createJarArchive(MockAsWar.this.warFile, MockAsWar.this.warDir, filez);
                    }
                }
                return null;
            }
        };
        try {
            progressDialog.run(warWorker);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private ArrayList<File> getAllFilesFrom(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        if (dir.isDirectory()) {
            result.addAll(Arrays.asList(dir.listFiles()));
            ArrayList<File> toAdd = new ArrayList<File>();
            for (File f : result) {
                if (!f.isDirectory()) continue;
                toAdd.addAll(this.getAllFilesFrom(f));
            }
            result.addAll(toAdd);
        }
        return result;
    }

    protected void createWebXml() {
        URL url = SoapUI.class.getResource("/com/eviware/soapui/resources/mockaswar/web.xml");
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine + "\n");
            }
            this.createContent(content);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(this.webInf, "web.xml"))));
            out.write(content.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createContent(StringBuilder content) {
        content.replace(content.indexOf(PROJECT_FILE_NAME), content.indexOf(PROJECT_FILE_NAME) + PROJECT_FILE_NAME.length(), this.projectFile.getName());
        content.replace(content.indexOf(SOAPUI_SETTINGS), content.indexOf(SOAPUI_SETTINGS) + SOAPUI_SETTINGS.length(), this.settingsFile != null && this.settingsFile.exists() && this.settingsFile.isFile() ? this.settingsFile.getAbsolutePath() : "");
        content.replace(content.indexOf(MOCKSERVICE_ENDPOINT), content.indexOf(MOCKSERVICE_ENDPOINT) + MOCKSERVICE_ENDPOINT.length(), this.localEndpoint);
        if (!this.includeActions) {
            content.replace(content.indexOf("WEB-INF/actions"), content.indexOf("WEB-INF/actions") + "WEB-INF/actions".length(), "");
        }
        if (!this.includeListeners) {
            content.replace(content.indexOf("WEB-INF/listeners"), content.indexOf("WEB-INF/listeners") + "WEB-INF/listeners".length(), "");
        }
        if (!this.enableWebUI) {
            content.replace(content.indexOf("<param-value>true</param-value>"), content.indexOf("<param-value>true</param-value>") + "<param-value>true</param-value>".length(), "<param-value>false</param-value>");
        }
    }

    protected boolean prepareWarFile() {
        if (this.createWarFileSystem()) {
            File fromDir = new File(System.getProperty("soapui.home"), ".." + File.separator + "lib");
            JarPackager.copyAllFromTo(fromDir, this.lib, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().indexOf("servlet") == -1;
                }
            });
            if (this.includeExt) {
                fromDir = new File(System.getProperty("soapui.home"), "ext");
                JarPackager.copyAllFromTo(fromDir, this.lib, null);
            }
            File soapUIHome = new File(System.getProperty("soapui.home"));
            String[] mainJar = soapUIHome.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("soapui") && name.toLowerCase().endsWith(".jar");
                }
            });
            fromDir = new File(System.getProperty("soapui.home"), mainJar[0]);
            JarPackager.copyFileToDir(fromDir, this.lib);
            JarPackager.copyFileToDir(this.projectFile, this.soapuiDir);
            if (this.settingsFile != null && this.settingsFile.exists() && this.settingsFile.isFile()) {
                JarPackager.copyFileToDir(this.settingsFile, this.soapuiDir);
            }
            if (this.includeActions) {
                fromDir = new File(System.getProperty("soapui.ext.actions"));
                JarPackager.copyAllFromTo(fromDir, this.actionsDir, null);
            }
            if (this.includeListeners) {
                fromDir = new File(System.getProperty("soapui.ext.listeners"));
                JarPackager.copyAllFromTo(fromDir, this.listenersDir, null);
            }
            this.copyWarResource("header_logo.jpg");
            this.copyWarResource("stylesheet.css");
            return true;
        }
        return false;
    }

    private void copyWarResource(String resource) {
        try {
            Tools.writeAll(new FileOutputStream(new File(this.warDir, resource)), SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/mockaswar/" + resource));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean createWarFileSystem() {
        if (this.warDir.isDirectory()) {
            this.webInf = new File(this.warDir, "WEB-INF");
            if (!this.webInf.mkdir() && !this.webInf.exists()) {
                UISupport.showErrorMessage("Could not create directory " + this.webInf.getAbsolutePath());
                return false;
            }
            this.clearDir(this.webInf);
            this.lib = new File(this.webInf, "lib");
            if (!this.lib.mkdir() && !this.lib.exists()) {
                UISupport.showErrorMessage("Could not create directory " + this.lib.getAbsolutePath());
                return false;
            }
            this.soapuiDir = new File(this.webInf, "soapui");
            if (!this.soapuiDir.mkdir() && !this.soapuiDir.exists()) {
                UISupport.showErrorMessage("Could not create directory " + this.soapuiDir.getAbsolutePath());
                return false;
            }
            this.clearDir(this.soapuiDir);
            if (this.includeActions) {
                this.actionsDir = new File(this.webInf, "actions");
                if (!this.actionsDir.mkdirs() && !this.actionsDir.exists()) {
                    UISupport.showErrorMessage("Could not create directory " + this.actionsDir.getAbsolutePath());
                    return false;
                }
                this.clearDir(this.actionsDir);
            }
            if (this.includeListeners) {
                this.listenersDir = new File(this.webInf, "listeners");
                if (!this.listenersDir.mkdirs() && !this.listenersDir.exists()) {
                    UISupport.showErrorMessage("Could not create directory " + this.listenersDir.getAbsolutePath());
                    return false;
                }
                this.clearDir(this.listenersDir);
            }
            return true;
        }
        UISupport.showErrorMessage(this.warDir.getName() + " need to be directory!");
        return false;
    }

    protected void clearDir(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }
}

