/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineFactory;
import com.eviware.soapui.support.scripting.SoapUIScriptGenerator;
import com.eviware.soapui.support.scripting.groovy.GroovyScriptEngineFactory;
import com.eviware.soapui.support.scripting.js.JsScriptEngineFactory;
import com.eviware.soapui.support.types.StringList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SoapUIScriptEngineRegistry {
    public static final String DEFAULT_SCRIPT_ENGINE_ID = "Groovy";
    private static Map<String, SoapUIScriptEngineFactory> factories = new HashMap<String, SoapUIScriptEngineFactory>();
    private static final Logger log = Logger.getLogger(SoapUIScriptEngineRegistry.class);

    public static void registerScriptEngine(String id, SoapUIScriptEngineFactory factory) {
        factories.put(id, factory);
    }

    public static SoapUIScriptEngineFactory getFactory(String id) {
        return factories.get(id);
    }

    public static SoapUIScriptEngine create(ModelItem modelItem) {
        return factories.get(SoapUIScriptEngineRegistry.getScriptEngineId(modelItem)).createScriptEngine(modelItem);
    }

    public static String getScriptEngineId(ModelItem modelItem) {
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(modelItem);
        String scriptEngineId = null;
        if (project == null) {
            log.warn((Object)("Project is null for modelItem [" + String.valueOf(modelItem) + "], using default script language [" + DEFAULT_SCRIPT_ENGINE_ID + "]"));
        } else {
            scriptEngineId = project.getDefaultScriptLanguage();
        }
        if (StringUtils.isNullOrEmpty(scriptEngineId)) {
            scriptEngineId = DEFAULT_SCRIPT_ENGINE_ID;
        }
        return scriptEngineId;
    }

    public static SoapUIScriptGenerator createScriptGenerator(ModelItem modelItem) {
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(modelItem);
        String scriptEngineId = project.getDefaultScriptLanguage();
        if (StringUtils.isNullOrEmpty(scriptEngineId)) {
            scriptEngineId = DEFAULT_SCRIPT_ENGINE_ID;
        }
        return factories.get(scriptEngineId).createCodeGenerator(modelItem);
    }

    public static String[] getAvailableEngineIds() {
        return new StringList((Collection<?>)factories.keySet()).toStringArray();
    }

    static {
        SoapUIScriptEngineRegistry.registerScriptEngine(DEFAULT_SCRIPT_ENGINE_ID, new GroovyScriptEngineFactory());
        SoapUIScriptEngineRegistry.registerScriptEngine("Javascript", new JsScriptEngineFactory());
    }
}

