/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.ssl;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.cert.Certificate;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseSSLInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private JEditorPane sslInfoPane;
    private JPanel panel;
    private AbstractHttpRequest<?> request;

    protected ResponseSSLInspector(AbstractHttpRequest<?> abstractHttpRequest) {
        super("SSL Info", "SSL Certificate Information for this response", true, "SSL Info");
        this.request = abstractHttpRequest;
        abstractHttpRequest.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new BorderLayout());
        this.sslInfoPane = new JEditorPane();
        this.sslInfoPane.setEditorKit(new HTMLEditorKit());
        this.panel.add(new JScrollPane(this.sslInfoPane));
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        this.request.removePropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
    }

    private void updateSSLInfo(SSLInfo sslInfo) {
        String sslInfoTabTitle = "SSL Info";
        if (sslInfo != null) {
            Certificate[] peerCertificates;
            Certificate[] localCertificates;
            StringBuffer buf = new StringBuffer("<html><body><table cellpadding=1 cellspacing=1 border=0>");
            buf.append("<tr><td><b>CipherSuite:</b></td><td align=left valign=top>").append(sslInfo.getCipherSuite().toString()).append("</td></tr>");
            if (sslInfo.getLocalPrincipal() != null) {
                buf.append("<tr><td><b>LocalPrincipal:</b></td><td align=left valign=top>").append(sslInfo.getLocalPrincipal().getName()).append("</td></tr>");
            }
            if ((localCertificates = sslInfo.getLocalCertificates()) != null) {
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
                int cnt = 1;
                for (Certificate cert : localCertificates) {
                    buf.append("<tr><td><b>Local Certificate ").append(cnt++).append(":</b><pre><font size=-1>").append(cert.toString()).append("</font></pre></td></tr>");
                }
                buf.append("</table><table cellpadding=1 cellspacing=1 border=0>");
            }
            if (sslInfo.getPeerPrincipal() != null) {
                buf.append("<tr><td><b>PeerPrincipal:</b></td><td align=left valign=top>").append(((Object)sslInfo.getPeerPrincipal()).toString()).append("</td></tr>");
            }
            if ((peerCertificates = sslInfo.getPeerCertificates()) != null) {
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
                int cnt = 1;
                for (Certificate cert : peerCertificates) {
                    buf.append("<tr><td colspan=2><b>Peer Certificate ").append(cnt++).append(":</b><pre><font size=-1>").append(cert.toString()).append("</font></pre></td></tr>");
                }
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
            }
            buf.append("</table></body></html>");
            this.sslInfoPane.setText(buf.toString());
            sslInfoTabTitle = sslInfoTabTitle + " (" + sslInfo.getPeerCertificates().length + " certs)";
        }
        this.setTitle(sslInfoTabTitle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        HttpResponse response = this.request.getResponse();
        this.updateSSLInfo(response == null ? null : response.getSSLInfo());
        this.setEnabled(response != null && response.getSSLInfo() != null);
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return true;
    }
}

