/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.InterfaceListener;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.TreeNodeFactory;
import com.eviware.soapui.model.tree.nodes.OperationTreeNode;
import com.eviware.soapui.model.tree.nodes.RestResourceTreeNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceTreeNode
extends AbstractModelItemTreeNode<Interface> {
    private InternalInterfaceListener interfaceListener;
    private List<SoapUITreeNode> operationNodes = new ArrayList<SoapUITreeNode>();

    public InterfaceTreeNode(Interface iface, SoapUITreeModel treeModel) {
        super(iface, iface.getProject(), treeModel);
        this.interfaceListener = new InternalInterfaceListener();
        iface.addInterfaceListener(this.interfaceListener);
        for (int c = 0; c < iface.getOperationCount(); ++c) {
            this.operationNodes.add(TreeNodeFactory.createTreeNode(iface.getOperationAt(c), this.getTreeModel()));
        }
        treeModel.mapModelItems(this.operationNodes);
    }

    @Override
    public void release() {
        super.release();
        this.getInterface().removeInterfaceListener(this.interfaceListener);
        for (SoapUITreeNode treeNode : this.operationNodes) {
            treeNode.release();
        }
    }

    public Interface getInterface() {
        return (Interface)this.getModelItem();
    }

    @Override
    public int getChildCount() {
        return this.operationNodes.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.operationNodes.indexOf(child);
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.operationNodes.get(index);
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void requestAdded(Request request) {
            SoapUITreeNode operationTreeNode = InterfaceTreeNode.this.getTreeModel().getTreeNode(request.getOperation());
            if (operationTreeNode != null && operationTreeNode instanceof OperationTreeNode) {
                ((OperationTreeNode)operationTreeNode).requestAdded(request);
            }
        }

        public void requestRemoved(Request request) {
            SoapUITreeNode operationTreeNode = InterfaceTreeNode.this.getTreeModel().getTreeNode(request.getOperation());
            if (operationTreeNode != null && operationTreeNode instanceof OperationTreeNode) {
                ((OperationTreeNode)operationTreeNode).requestRemoved(request);
            }
        }

        public void operationAdded(Operation operation) {
            RestResource restResource;
            if (operation instanceof RestResource && (restResource = (RestResource)operation).getParentResource() != null) {
                RestResourceTreeNode treeNode = (RestResourceTreeNode)InterfaceTreeNode.this.getTreeModel().getTreeNode(restResource.getParentResource());
                treeNode.addChildResource(restResource);
                return;
            }
            SoapUITreeNode operationTreeNode = TreeNodeFactory.createTreeNode(operation, InterfaceTreeNode.this.getTreeModel());
            InterfaceTreeNode.this.operationNodes.add(operationTreeNode);
            InterfaceTreeNode.this.getTreeModel().notifyNodeInserted(operationTreeNode);
        }

        public void operationRemoved(Operation operation) {
            SoapUITreeNode treeNode = InterfaceTreeNode.this.getTreeModel().getTreeNode(operation);
            if (InterfaceTreeNode.this.operationNodes.contains(treeNode)) {
                InterfaceTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
                InterfaceTreeNode.this.operationNodes.remove(treeNode);
            } else if (treeNode instanceof RestResourceTreeNode) {
                SoapUITreeNode parentNode = treeNode.getParentTreeNode();
                if (parentNode instanceof RestResourceTreeNode) {
                    ((RestResourceTreeNode)parentNode).removeChildResource((RestResourceTreeNode)treeNode);
                }
            } else {
                throw new RuntimeException("Removing unknown operation");
            }
        }

        public void operationUpdated(Operation operation) {
        }
    }
}

