/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.GroovyScriptAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.ResponseSLAAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.SchemaComplianceAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.SimpleContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.SimpleNotContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.XPathContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.XQueryContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.jdbc.JdbcStatusAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.jdbc.JdbcTimeoutAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.jms.JMSStatusAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.jms.JMSTimeoutAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.NotSoapFaultAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.SoapFaultAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.SoapRequestAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.SoapResponseAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.WSARequestAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.WSAResponseAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.soap.WSSStatusAssertion;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TestAssertionRegistry {
    private static TestAssertionRegistry instance;
    private Map<String, TestAssertionFactory> availableAssertions = new HashMap<String, TestAssertionFactory>();
    private StringToStringMap assertionLabels = new StringToStringMap();
    private static final Logger log;

    public TestAssertionRegistry() {
        this.addAssertion(new SoapResponseAssertion.Factory());
        this.addAssertion(new SoapRequestAssertion.Factory());
        this.addAssertion(new SchemaComplianceAssertion.Factory());
        this.addAssertion(new SimpleContainsAssertion.Factory());
        this.addAssertion(new SimpleNotContainsAssertion.Factory());
        this.addAssertion(new XPathContainsAssertion.Factory());
        this.addAssertion(new NotSoapFaultAssertion.Factory());
        this.addAssertion(new SoapFaultAssertion.Factory());
        this.addAssertion(new ResponseSLAAssertion.Factory());
        this.addAssertion(new GroovyScriptAssertion.Factory());
        this.addAssertion(new XQueryContainsAssertion.Factory());
        this.addAssertion(new WSSStatusAssertion.Factory());
        this.addAssertion(new WSAResponseAssertion.Factory());
        this.addAssertion(new WSARequestAssertion.Factory());
        this.addAssertion(new JMSStatusAssertion.Factory());
        this.addAssertion(new JMSTimeoutAssertion.Factory());
        this.addAssertion(new JdbcStatusAssertion.Factory());
        this.addAssertion(new JdbcTimeoutAssertion.Factory());
    }

    public void addAssertion(TestAssertionFactory factory) {
        this.availableAssertions.put(factory.getAssertionId(), factory);
        this.assertionLabels.put(factory.getAssertionLabel(), factory.getAssertionId());
    }

    public static synchronized TestAssertionRegistry getInstance() {
        if (instance == null) {
            instance = new TestAssertionRegistry();
        }
        return instance;
    }

    public WsdlMessageAssertion buildAssertion(TestAssertionConfig config, Assertable assertable) {
        try {
            String type = config.getType();
            TestAssertionFactory factory = this.availableAssertions.get(type);
            if (factory != null) {
                return (WsdlMessageAssertion)factory.buildAssertion(config, assertable);
            }
            log.error((Object)("Missing assertion for type [" + type + "]"));
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return null;
    }

    public boolean canBuildAssertion(TestAssertionConfig config) {
        return this.availableAssertions.containsKey(config.getType());
    }

    public String getAssertionTypeForName(String name) {
        return (String)this.assertionLabels.get(name);
    }

    public String[] getAvailableAssertionNames(Assertable assertable) {
        ArrayList<String> result = new ArrayList<String>();
        for (TestAssertionFactory assertion : this.availableAssertions.values()) {
            if (!assertion.canAssert(assertable)) continue;
            result.add(assertion.getAssertionLabel());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getAssertionNameForType(String type) {
        for (String assertion : this.assertionLabels.keySet()) {
            if (!((String)this.assertionLabels.get(assertion)).equals(type)) continue;
            return assertion;
        }
        return null;
    }

    public boolean canAddMultipleAssertions(String name, Assertable assertable) {
        for (int c = 0; c < assertable.getAssertionCount(); ++c) {
            TestAssertion assertion = assertable.getAssertionAt(c);
            if (assertion.isAllowMultiple() || !assertion.getClass().equals(this.availableAssertions.get(this.getAssertionTypeForName(name)))) continue;
            return false;
        }
        return true;
    }

    public boolean canAddAssertion(WsdlMessageAssertion assertion, Assertable assertable) {
        if (assertion.isAllowMultiple()) {
            return true;
        }
        for (int c = 0; c < assertable.getAssertionCount(); ++c) {
            if (!assertion.getClass().equals(assertable.getAssertionAt(c).getClass())) continue;
            return false;
        }
        return true;
    }

    static {
        log = Logger.getLogger(TestAssertionRegistry.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertableType {
        REQUEST,
        RESPONSE,
        BOTH;

    }
}

