/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddAssertionAction
extends AbstractAction {
    private final Assertable assertable;

    public AddAssertionAction(Assertable assertable) {
        super("Add Assertion");
        this.assertable = assertable;
        this.putValue("ShortDescription", "Adds an assertion to this item");
        this.putValue("SmallIcon", UISupport.createImageIcon("/addAssertion.gif"));
    }

    public void actionPerformed(ActionEvent e) {
        String[] assertions = TestAssertionRegistry.getInstance().getAvailableAssertionNames(this.assertable);
        if (assertions == null || assertions.length == 0) {
            UISupport.showErrorMessage("No assertions available for this message");
            return;
        }
        String selection = UISupport.prompt("Select assertion to add", "Select Assertion", assertions);
        if (selection == null) {
            return;
        }
        if (!TestAssertionRegistry.getInstance().canAddMultipleAssertions(selection, this.assertable)) {
            UISupport.showErrorMessage("This assertion can only be added once");
            return;
        }
        TestAssertion assertion = this.assertable.addAssertion(selection);
        if (assertion == null) {
            UISupport.showErrorMessage("Failed to add assertion");
            return;
        }
        if (assertion.isConfigurable()) {
            assertion.configure();
        }
    }
}

