/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.PropertyTransferConfig;
import com.eviware.soapui.config.PropertyTransfersStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransferException;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowTransferValuesResultsAction;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTransfersTestStep
extends WsdlTestStepWithProperties
implements XPathReferenceContainer {
    private PropertyTransfersStepConfig transferStepConfig;
    private boolean canceled;
    private List<PropertyTransfer> transfers = new ArrayList<PropertyTransfer>();
    private ImageIcon failedIcon;
    private ImageIcon okIcon;

    public PropertyTransfersTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (!forLoadTest) {
            this.okIcon = UISupport.createImageIcon("/value_transfer.gif");
            this.failedIcon = UISupport.createImageIcon("/value_transfer_failed.gif");
            this.setIcon(this.okIcon);
        }
    }

    @Override
    public void afterLoad() {
        TestStepConfig config = (TestStepConfig)this.getConfig();
        if (config.getConfig() != null) {
            this.transferStepConfig = (PropertyTransfersStepConfig)config.getConfig().changeType(PropertyTransfersStepConfig.type);
            for (int c = 0; c < this.transferStepConfig.sizeOfTransfersArray(); ++c) {
                this.transfers.add(new PropertyTransfer(this, this.transferStepConfig.getTransfersArray(c)));
            }
        } else {
            this.transferStepConfig = (PropertyTransfersStepConfig)config.addNewConfig().changeType(PropertyTransfersStepConfig.type);
        }
        super.afterLoad();
    }

    public PropertyTransfersStepConfig getTransferConfig() {
        return this.transferStepConfig;
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.transferStepConfig = (PropertyTransfersStepConfig)config.getConfig().changeType(PropertyTransfersStepConfig.type);
        for (int c = 0; c < this.transferStepConfig.sizeOfTransfersArray(); ++c) {
            this.transfers.get(c).setConfigOnMove(this.transferStepConfig.getTransfersArray(c));
        }
    }

    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext context) {
        return this.run(runner, context, null);
    }

    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext context, PropertyTransfer transfer) {
        PropertyTransferResult result = new PropertyTransferResult();
        this.canceled = false;
        long startTime = System.currentTimeMillis();
        for (int c = 0; c < this.transfers.size(); ++c) {
            PropertyTransfer valueTransfer = this.transfers.get(c);
            if (transfer != null && transfer != valueTransfer || valueTransfer.isDisabled()) continue;
            try {
                if (this.canceled) {
                    result.setStatus(TestStepResult.TestStepStatus.CANCELED);
                    result.setTimeTaken(System.currentTimeMillis() - startTime);
                    return result;
                }
                String[] values = valueTransfer.transferProperties(context);
                if (values == null || values.length <= 0) continue;
                String name = valueTransfer.getName();
                result.addMessage("Performed transfer [" + name + "]");
                result.addTransferResult(valueTransfer, values);
                continue;
            }
            catch (PropertyTransferException e) {
                result.addMessage("Error performing transfer [" + valueTransfer.getName() + "] - " + e.getMessage());
                result.addTransferResult(valueTransfer, new String[]{e.getMessage()});
                if (!this.transfers.get(c).getFailOnError()) continue;
                result.setError(e);
                result.setStatus(TestStepResult.TestStepStatus.FAILED);
                result.setTimeTaken(System.currentTimeMillis() - startTime);
                if (this.failedIcon != null) {
                    this.setIcon(this.failedIcon);
                }
                return result;
            }
        }
        if (this.okIcon != null) {
            this.setIcon(this.okIcon);
        }
        result.setStatus(TestStepResult.TestStepStatus.OK);
        result.setTimeTaken(System.currentTimeMillis() - startTime);
        return result;
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        return this.canceled;
    }

    public int getTransferCount() {
        return this.transferStepConfig.sizeOfTransfersArray();
    }

    public PropertyTransfer getTransferAt(int index) {
        return this.transfers.get(index);
    }

    public PropertyTransfer addTransfer(String name) {
        PropertyTransfer transfer = new PropertyTransfer(this, this.transferStepConfig.addNewTransfers());
        transfer.setName(name);
        transfer.setFailOnError(true);
        this.transfers.add(transfer);
        return transfer;
    }

    public void removeTransferAt(int index) {
        this.transfers.remove(index).release();
        this.transferStepConfig.removeTransfers(index);
    }

    public TestStepResult createFailedResult(String message) {
        PropertyTransferResult result = new PropertyTransferResult();
        result.setStatus(TestStepResult.TestStepStatus.FAILED);
        result.addMessage(message);
        return result;
    }

    @Override
    public void release() {
        super.release();
        for (PropertyTransfer transfer : this.transfers) {
            transfer.release();
        }
    }

    public PropertyTransfer getTransferByName(String name) {
        for (int c = 0; c < this.getTransferCount(); ++c) {
            PropertyTransfer transfer = this.getTransferAt(c);
            if (!transfer.getName().equals(name)) continue;
            return transfer;
        }
        return null;
    }

    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        for (PropertyTransfer transfer : this.transfers) {
            result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, transfer, "sourcePath"));
            result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, transfer, "targetPath"));
        }
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        for (PropertyTransfer transfer : this.transfers) {
            if (StringUtils.hasContent(transfer.getSourcePath())) {
                result.add(new XPathReferenceImpl("Source path for " + transfer.getName() + " PropertyTransfer in " + this.getName(), transfer.getSourceProperty(), transfer, "sourcePath"));
            }
            if (!StringUtils.hasContent(transfer.getTargetPath())) continue;
            result.add(new XPathReferenceImpl("Target path for " + transfer.getName() + " PropertyTransfer in " + this.getName(), transfer.getTargetProperty(), transfer, "targetPath"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        for (PropertyTransfer pTransfer : this.transfers) {
            pTransfer.resolve(context, this);
        }
    }

    public class PropertyTransferResult
    extends WsdlTestStepResult {
        private List<PropertyTransferConfig> transfers;
        private List<String[]> values;
        private boolean addedAction;

        public PropertyTransferResult() {
            super(PropertyTransfersTestStep.this);
            this.transfers = new ArrayList<PropertyTransferConfig>();
            this.values = new ArrayList<String[]>();
        }

        public void addTransferResult(PropertyTransfer transfer, String[] values) {
            this.transfers.add((PropertyTransferConfig)transfer.getConfig().copy());
            this.values.add(values);
        }

        public ActionList getActions() {
            if (!this.addedAction) {
                this.addAction(new ShowTransferValuesResultsAction(this), true);
                this.addedAction = true;
            }
            return super.getActions();
        }

        public int getTransferCount() {
            return this.transfers == null ? 0 : this.transfers.size();
        }

        public PropertyTransferConfig getTransferAt(int index) {
            return this.transfers == null ? null : this.transfers.get(index);
        }

        public String[] getTransferredValuesAt(int index) {
            return this.values == null ? null : this.values.get(index);
        }

        public void discard() {
            super.discard();
            this.transfers = null;
            this.values = null;
        }

        public void writeTo(PrintWriter writer) {
            super.writeTo(writer);
            if (!this.isDiscarded()) {
                writer.println("----------------------------------------------------");
                for (int c = 0; c < this.transfers.size(); ++c) {
                    PropertyTransferConfig transfer = this.transfers.get(c);
                    writer.println(transfer.getName() + " transferred [" + Arrays.toString(this.values.get(c)) + "] from [" + transfer.getSourceStep() + "." + transfer.getSourceType() + "] to [" + transfer.getTargetStep() + "." + transfer.getTargetType() + "]");
                    if (transfer.getSourcePath() != null) {
                        writer.println("------------ source path -------------");
                        writer.println(transfer.getSourcePath());
                    }
                    if (transfer.getTargetPath() == null) continue;
                    writer.println("------------ target path -------------");
                    writer.println(transfer.getTargetPath());
                }
            }
        }
    }
}

