/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.PropertyTransferConfig;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransferException;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfersTestStep;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.PropertyChangeNotifier;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.resolver.ChooseAnotherPropertySourceResolver;
import com.eviware.soapui.support.resolver.ChooseAnotherPropertyTargetResolver;
import com.eviware.soapui.support.resolver.CreateMissingPropertyResolver;
import com.eviware.soapui.support.resolver.DisablePropertyTransferResolver;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTransfer
implements PropertyChangeNotifier {
    private static final Logger log = Logger.getLogger(PropertyTransfer.class);
    public static final String SOURCE_PATH_PROPERTY = PropertyTransfer.class.getName() + "@sourcePath";
    public static final String SOURCE_TYPE_PROPERTY = PropertyTransfer.class.getName() + "@sourceProperty";
    public static final String SOURCE_STEP_PROPERTY = PropertyTransfer.class.getName() + "@sourceStep";
    public static final String TARGET_PATH_PROPERTY = PropertyTransfer.class.getName() + "@targetPath";
    public static final String TARGET_TYPE_PROPERTY = PropertyTransfer.class.getName() + "@targetProperty";
    public static final String TARGET_STEP_PROPERTY = PropertyTransfer.class.getName() + "@targetStep";
    public static final String NAME_PROPERTY = PropertyTransfer.class.getName() + "@name";
    public static final String DISABLED_PROPERTY = PropertyTransfer.class.getName() + "@disabled";
    public static final String CONFIG_PROPERTY = PropertyTransfer.class.getName() + "@config";
    private TestStep testStep;
    private PropertyTransferConfig config;
    private String sourcePath;
    private String sourceType;
    private String targetPath;
    private String name;
    private String targetType;
    private String sourceStep;
    private String targetStep;
    private TestPropertyHolder currentTargetStep;
    private TestPropertyHolder currentSourceStep;
    private TestProperty currentTargetProperty;
    private TestProperty currentSourceProperty;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private StepNameChangeListener stepNameChangeListener = new StepNameChangeListener();
    private InternalTestPropertyListener propertyNameChangeListener = new InternalTestPropertyListener();
    private TestCase testCase;
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

    public PropertyTransfer(TestStep testStep) {
        this(testStep, PropertyTransferConfig.Factory.newInstance());
    }

    public PropertyTransfer(TestStep testStep, PropertyTransferConfig config) {
        this.testStep = testStep;
        if (testStep != null) {
            this.testCase = testStep.getTestCase();
            this.testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
        }
        this.setConfig(config);
    }

    void setConfigOnMove(PropertyTransferConfig config) {
        this.config = config;
    }

    void setConfig(PropertyTransferConfig config) {
        this.releaseListeners();
        this.config = config;
        if (!config.isSetSetNullOnMissingSource()) {
            config.setSetNullOnMissingSource(true);
        }
        if (!config.isSetTransferTextContent()) {
            config.setTransferTextContent(true);
        }
        this.sourceStep = config.getSourceStep();
        if (this.sourceStep == null) {
            this.sourceStep = this.getSourceStepName();
            if (this.sourceStep != null) {
                config.setSourceStep(this.sourceStep);
            }
        } else {
            this.sourceStep = this.sourceStep.trim();
        }
        this.currentSourceStep = this.getPropertyHolder(this.sourceStep);
        this.sourceType = config.getSourceType();
        this.currentSourceProperty = this.currentSourceStep == null || this.sourceType == null ? null : this.currentSourceStep.getProperty(this.sourceType);
        this.sourcePath = config.getSourcePath();
        this.targetStep = config.getTargetStep();
        if (this.targetStep == null) {
            this.targetStep = this.getTargetStepName();
            if (this.targetStep != null) {
                config.setTargetStep(this.targetStep);
            }
        } else {
            this.targetStep = this.targetStep.trim();
        }
        this.currentTargetStep = this.getPropertyHolder(this.targetStep);
        this.targetType = config.getTargetType();
        this.currentTargetProperty = this.currentTargetStep == null || this.targetType == null ? null : this.currentTargetStep.getProperty(this.targetType);
        this.targetPath = config.getTargetPath();
        this.name = config.getName();
        this.initListeners();
        this.propertyChangeSupport.firePropertyChange(CONFIG_PROPERTY, null, null);
    }

    private void initListeners() {
        if (this.currentSourceStep != null) {
            if (this.currentSourceStep instanceof TestStep) {
                ((TestStep)this.currentSourceStep).addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentSourceStep.addTestPropertyListener(this.propertyNameChangeListener);
        }
        if (this.currentTargetStep != null) {
            if (this.currentTargetStep instanceof TestStep) {
                ((TestStep)this.currentTargetStep).addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentTargetStep.addTestPropertyListener(this.propertyNameChangeListener);
        }
    }

    public void releaseListeners() {
        PropertyChangeListener[] listeners;
        if (this.currentSourceStep != null) {
            if (this.currentSourceStep instanceof TestStep) {
                ((TestStep)this.currentSourceStep).removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentSourceStep.removeTestPropertyListener(this.propertyNameChangeListener);
        }
        if (this.currentTargetStep != null) {
            if (this.currentTargetStep instanceof TestStep) {
                ((TestStep)this.currentTargetStep).removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentTargetStep.removeTestPropertyListener(this.propertyNameChangeListener);
        }
        for (PropertyChangeListener listener : listeners = this.propertyChangeSupport.getPropertyChangeListeners()) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void release() {
        this.releaseListeners();
        this.testCase.getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    public PropertyTransferConfig getConfig() {
        return this.config;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public TestProperty getSourceProperty() {
        if (this.sourceType == null) {
            return null;
        }
        if (this.currentSourceProperty != null) {
            return this.currentSourceProperty;
        }
        TestPropertyHolder actualSourceStep = this.getSourceStep();
        return actualSourceStep == null ? null : actualSourceStep.getProperty(this.sourceType);
    }

    public String[] transferProperties(SubmitContext context) throws PropertyTransferException {
        TestProperty sourceProperty = this.getSourceProperty();
        TestProperty targetProperty = this.getTargetProperty();
        try {
            if (sourceProperty == null) {
                throw new Exception("Missing source property");
            }
            if (targetProperty == null) {
                throw new Exception("Missing target property");
            }
            if (sourceProperty.getValue() == null && !this.getSetNullOnMissingSource() && !this.getIgnoreEmpty()) {
                throw new Exception("Source property is null");
            }
            if (!this.hasSourcePath() && !this.hasTargetPath()) {
                if (!this.getIgnoreEmpty() || sourceProperty.getValue() != null && sourceProperty.getValue().length() > 0) {
                    return this.transferStringToString(sourceProperty, targetProperty);
                }
            } else {
                if (this.hasSourcePath() && this.hasTargetPath()) {
                    return this.transferXPathToXml(sourceProperty, targetProperty, context);
                }
                if (this.hasSourcePath() && !this.hasTargetPath()) {
                    return new String[]{this.transferXPathToString(sourceProperty, targetProperty, context)};
                }
                if (!this.hasSourcePath() && this.hasTargetPath() && (!this.getIgnoreEmpty() || sourceProperty.getValue() != null && sourceProperty.getValue().length() > 0)) {
                    return this.transferStringToXml(sourceProperty, targetProperty, context);
                }
            }
        }
        catch (Exception e) {
            throw new PropertyTransferException(e.getMessage(), this.getSourceStepName(), sourceProperty, this.getTargetStepName(), targetProperty);
        }
        return new String[0];
    }

    private boolean hasTargetPath() {
        String path = this.getTargetPath();
        return path != null && path.trim().length() > 0;
    }

    private boolean hasSourcePath() {
        String path = this.getSourcePath();
        return path != null && path.trim().length() > 0;
    }

    protected String[] transferStringToString(TestProperty sourceProperty, TestProperty targetProperty) {
        String value = sourceProperty.getValue();
        if (StringUtils.hasContent(value) && this.getEntitize()) {
            value = XmlUtils.entitize(value);
        }
        targetProperty.setValue(value);
        return new String[]{value};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] transferXPathToXml(TestProperty sourceProperty, TestProperty targetProperty, SubmitContext context) throws Exception {
        String[] stringArray;
        XmlCursor targetXml;
        XmlObject targetXmlObject;
        XmlCursor sourceXml;
        try {
            String sourcePropertyValue = sourceProperty.getValue();
            XmlObject sourceXmlObject = sourcePropertyValue == null ? null : XmlObject.Factory.parse((String)sourcePropertyValue);
            sourceXml = sourceXmlObject == null ? null : sourceXmlObject.newCursor();
        }
        catch (XmlException e) {
            throw new Exception("Error parsing source property [" + e.getMessage() + "]");
        }
        try {
            String targetPropertyValue = targetProperty.getValue();
            targetXmlObject = XmlObject.Factory.parse((String)targetPropertyValue);
            targetXml = targetXmlObject.newCursor();
        }
        catch (XmlException e) {
            throw new Exception("Error parsing target property [" + e.getMessage() + "]");
        }
        XmlCursor lastSource = null;
        try {
            String sp;
            ArrayList<String> result = new ArrayList<String>();
            String tp = PropertyExpander.expandProperties(context, this.getTargetPath());
            targetXml.selectPath(tp);
            if (!targetXml.hasNextSelection()) {
                throw new Exception("Missing match for Target XPath [" + tp + "]");
            }
            if (sourceXml == null) {
                if (this.getSetNullOnMissingSource()) {
                    while (targetXml.toNextSelection()) {
                        result.add(this.setNodeValue(null, targetXml.getDomNode()));
                        if (this.getTransferToAll()) continue;
                        break;
                    }
                }
            } else if (this.getUseXQuery()) {
                boolean hasTarget;
                sp = PropertyExpander.expandProperties(context, this.getSourcePath());
                XmlCursor resultCursor = sourceXml.execQuery(sp);
                sourceXml.dispose();
                sourceXml = resultCursor;
                if (sourceXml.toNextToken() != XmlCursor.TokenType.START) {
                    if (this.getSetNullOnMissingSource()) {
                        while (targetXml.toNextSelection()) {
                            result.add(this.setNodeValue(null, targetXml.getDomNode()));
                            if (this.getTransferToAll()) continue;
                            break;
                        }
                    } else if (!this.getIgnoreEmpty()) {
                        throw new Exception("Missing match for Source XQuery [" + sp + "]");
                    }
                }
                if (hasTarget = targetXml.toNextSelection()) {
                    lastSource = sourceXml.newCursor();
                    result.add(this.transferXmlValue(sourceXml, targetXml));
                }
            } else {
                sp = PropertyExpander.expandProperties(context, this.getSourcePath());
                sourceXml.selectPath(sp);
                if (!sourceXml.hasNextSelection()) {
                    if (this.getSetNullOnMissingSource()) {
                        while (targetXml.toNextSelection()) {
                            result.add(this.setNodeValue(null, targetXml.getDomNode()));
                            if (this.getTransferToAll()) continue;
                            break;
                        }
                    } else if (!this.getIgnoreEmpty()) {
                        throw new Exception("Missing match for Source XPath [" + sp + "]");
                    }
                } else {
                    boolean hasSource = sourceXml.toNextSelection();
                    boolean hasTarget = targetXml.toNextSelection();
                    while (hasSource && hasTarget) {
                        if (lastSource != null) {
                            lastSource.dispose();
                        }
                        lastSource = sourceXml.newCursor();
                        result.add(this.transferXmlValue(sourceXml, targetXml));
                        hasSource = sourceXml.toNextSelection();
                        hasTarget = targetXml.toNextSelection();
                    }
                    if (this.getTransferToAll() && !hasSource && hasTarget && lastSource != null) {
                        while (hasTarget) {
                            result.add(this.transferXmlValue(lastSource, targetXml));
                            hasTarget = targetXml.toNextSelection();
                        }
                    }
                }
            }
            if (result.size() > 0) {
                String value = targetXmlObject.xmlText(new XmlOptions().setSaveAggressiveNamespaces());
                targetProperty.setValue(value);
            }
            stringArray = result.toArray(new String[result.size()]);
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            block33: {
                Object var14_18 = null;
                sourceXml.dispose();
                targetXml.dispose();
                if (lastSource == null) break block33;
                lastSource.dispose();
            }
            throw throwable;
        }
        sourceXml.dispose();
        targetXml.dispose();
        if (lastSource != null) {
            lastSource.dispose();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] transferStringToXml(TestProperty sourceProperty, TestProperty targetProperty, SubmitContext context) throws XmlException, Exception {
        String[] stringArray;
        if (!StringUtils.hasContent(targetProperty.getValue())) {
            throw new Exception("Missing target property value");
        }
        XmlObject targetXml = XmlObject.Factory.parse((String)targetProperty.getValue());
        XmlCursor targetCursor = targetXml.newCursor();
        try {
            ArrayList<String> result = new ArrayList<String>();
            String tp = PropertyExpander.expandProperties(context, this.getTargetPath());
            targetCursor.selectPath(tp);
            if (!targetCursor.toNextSelection()) {
                throw new Exception("Missing match for Target XPath [" + tp + "]");
            }
            String value = sourceProperty.getValue();
            Node targetNode = targetCursor.getDomNode();
            this.setNodeValue(value, targetNode);
            result.add(value);
            if (this.getTransferToAll()) {
                while (targetCursor.toNextSelection()) {
                    targetNode = targetCursor.getDomNode();
                    this.setNodeValue(value, targetNode);
                    result.add(value);
                }
            }
            targetProperty.setValue(targetXml.xmlText(new XmlOptions().setSaveAggressiveNamespaces()));
            stringArray = result.toArray(new String[result.size()]);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            targetCursor.dispose();
            throw throwable;
        }
        targetCursor.dispose();
        return stringArray;
    }

    private String setNodeValue(String value, Node node) throws Exception {
        short targetNodeType = node.getNodeType();
        if (targetNodeType == 11) {
            if ((node = node.getFirstChild()) != null) {
                targetNodeType = node.getNodeType();
            } else {
                throw new Exception("Missing source value for " + this.getSourcePropertyName());
            }
        }
        if (!XmlUtils.setNodeValue(node, value)) {
            throw new Exception("Failed to set value to node [" + node.toString() + "] of type [" + targetNodeType + "]");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transferXPathToString(TestProperty sourceProperty, TestProperty targetProperty, SubmitContext context) throws Exception {
        String string;
        String sourceValue = sourceProperty.getValue();
        if (!StringUtils.hasContent(sourceValue)) {
            if (!this.getIgnoreEmpty()) {
                throw new Exception("Missing source value");
            }
            if (this.getSetNullOnMissingSource()) {
                targetProperty.setValue(null);
            }
            return null;
        }
        XmlObject sourceXml = sourceValue == null ? null : XmlObject.Factory.parse((String)sourceValue);
        XmlCursor sourceCursor = sourceValue == null ? null : sourceXml.newCursor();
        try {
            String value = null;
            String xquery = PropertyExpander.expandProperties(context, this.getSourcePath());
            if (this.getUseXQuery()) {
                XmlCursor resultCursor = sourceCursor.execQuery(xquery);
                sourceCursor.dispose();
                sourceCursor = resultCursor;
            } else {
                sourceCursor.selectPath(xquery);
            }
            if (!this.getUseXQuery() && !sourceCursor.toNextSelection()) {
                if (!this.getSetNullOnMissingSource() && !this.getIgnoreEmpty()) {
                    throw new Exception("Missing match for Source XPath [" + xquery + "]");
                }
            } else if (this.getUseXQuery() && sourceCursor.toNextToken() != XmlCursor.TokenType.START) {
                if (!this.getSetNullOnMissingSource() && !this.getIgnoreEmpty()) {
                    throw new Exception("Missing match for Source XQuery [" + xquery + "]");
                }
            } else {
                Node sourceNode = sourceCursor.getDomNode();
                short sourceNodeType = sourceNode.getNodeType();
                if (sourceNodeType == 11) {
                    if ((sourceNode = sourceNode.getFirstChild()) != null) {
                        sourceNodeType = sourceNode.getNodeType();
                    } else {
                        throw new Exception("Missing source value for " + this.getSourcePropertyName());
                    }
                }
                if (sourceNodeType == 3 || sourceNodeType == 2) {
                    value = sourceNode.getNodeValue();
                } else if (sourceNodeType == 1) {
                    if (this.getTransferTextContent()) {
                        value = XmlUtils.getElementText((Element)sourceNode);
                    }
                    if (value == null || !this.getTransferTextContent()) {
                        value = sourceCursor.getObject().xmlText(new XmlOptions().setSaveOuter().setSaveAggressiveNamespaces());
                    }
                }
            }
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0 || this.getSetNullOnMissingSource() && !StringUtils.hasContent(value)) {
                if (StringUtils.hasContent(value) && this.getEntitize()) {
                    value = XmlUtils.entitize(value);
                }
                targetProperty.setValue(value);
            } else {
                value = "";
            }
            string = value;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            sourceCursor.dispose();
            throw throwable;
        }
        sourceCursor.dispose();
        return string;
    }

    private String transferXmlValue(XmlCursor source, XmlCursor dest) throws Exception {
        Node destNode = dest.getDomNode();
        Node sourceNode = source.getDomNode();
        short destNodeType = destNode.getNodeType();
        short sourceNodeType = sourceNode.getNodeType();
        String value = null;
        if (this.getTransferChildNodes()) {
            while (destNode.hasChildNodes()) {
                destNode.removeChild(destNode.getFirstChild());
            }
            NodeList childNodes = sourceNode.getChildNodes();
            for (int c = 0; c < childNodes.getLength(); ++c) {
                destNode.appendChild(destNode.getOwnerDocument().importNode(childNodes.item(c), true));
            }
            return XmlUtils.serialize(destNode, false);
        }
        if (sourceNodeType == 11) {
            if ((sourceNode = sourceNode.getFirstChild()) != null) {
                sourceNodeType = sourceNode.getNodeType();
            } else {
                throw new Exception("Missing source value for " + source);
            }
        }
        if (destNodeType == sourceNodeType) {
            if (destNodeType == 3 || destNodeType == 2) {
                value = sourceNode.getNodeValue();
                if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                    if (this.getEntitize()) {
                        value = XmlUtils.entitize(value);
                    }
                    destNode.setNodeValue(value);
                }
            } else if (this.config.getTransferTextContent() && destNodeType == 1) {
                value = XmlUtils.getElementText((Element)sourceNode);
                if (value == null && sourceNode.getFirstChild() != null) {
                    value = source.getObject().xmlText(new XmlOptions().setSaveOuter().setSaveAggressiveNamespaces());
                    if (this.getEntitize()) {
                        value = XmlUtils.entitize(value);
                    }
                    destNode.getParentNode().replaceChild(destNode.getOwnerDocument().importNode(sourceNode, true), destNode);
                } else if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                    if (this.getEntitize()) {
                        value = XmlUtils.entitize(value);
                    }
                    XmlUtils.setElementText((Element)destNode, value);
                }
            } else {
                destNode = destNode.getParentNode().replaceChild(destNode.getOwnerDocument().importNode(sourceNode, true), destNode);
                value = dest.xmlText();
            }
        } else if (sourceNodeType == 3 && destNodeType == 2 || sourceNodeType == 2 && destNodeType == 3) {
            value = sourceNode.getNodeValue();
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                if (this.getEntitize()) {
                    value = XmlUtils.entitize(value);
                }
                destNode.setNodeValue(value);
            }
        } else if (sourceNodeType == 1 && destNodeType == 2 || destNodeType == 3) {
            value = XmlUtils.getElementText((Element)sourceNode);
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                if (this.getEntitize()) {
                    value = XmlUtils.entitize(value);
                }
                destNode.setNodeValue(value);
            }
        } else if (destNodeType == 1 && sourceNodeType == 2 || sourceNodeType == 3) {
            value = sourceNode.getNodeValue();
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                if (this.getEntitize()) {
                    value = XmlUtils.entitize(value);
                }
                XmlUtils.setElementText((Element)destNode, value);
            }
        }
        return value;
    }

    public String getSourcePropertyName() {
        if (this.sourceType == null) {
            return null;
        }
        if (this.currentSourceProperty != null) {
            return this.currentSourceProperty.getName();
        }
        TestPropertyHolder actualSourceStep = this.getSourceStep();
        if (actualSourceStep == null) {
            return this.sourceType;
        }
        TestProperty property = actualSourceStep.getProperty(this.sourceType);
        return property == null ? this.sourceType : property.getName();
    }

    public void setSourcePropertyName(String name) {
        String old = this.getSourcePropertyName();
        if (name == null && old == null || name != null && old != null && name.equals(old)) {
            return;
        }
        this.sourceType = name;
        this.config.setSourceType(name);
        TestPropertyHolder sourceStep2 = this.getSourceStep();
        this.currentSourceProperty = sourceStep2 != null && this.sourceType != null ? sourceStep2.getProperty(this.sourceType) : null;
        this.propertyChangeSupport.firePropertyChange(SOURCE_TYPE_PROPERTY, old, name);
    }

    public TestProperty getTargetProperty() {
        if (this.targetType == null) {
            return null;
        }
        if (this.currentTargetProperty != null) {
            return this.currentTargetProperty;
        }
        TestPropertyHolder actualTargetStep = this.getTargetStep();
        return actualTargetStep == null ? null : actualTargetStep.getProperty(this.targetType);
    }

    public String getTargetPropertyName() {
        if (this.targetType == null) {
            return null;
        }
        if (this.currentTargetProperty != null) {
            return this.currentTargetProperty.getName();
        }
        TestPropertyHolder actualTargetStep = this.getTargetStep();
        TestProperty property = actualTargetStep == null ? null : actualTargetStep.getProperty(this.targetType);
        return actualTargetStep == null || property == null ? this.targetType : property.getName();
    }

    public void setTargetPropertyName(String name) {
        String old = this.getTargetPropertyName();
        if (name == null && old == null || name != null && old != null && name.equals(old)) {
            return;
        }
        this.targetType = name;
        this.config.setTargetType(name);
        TestPropertyHolder targetStep2 = this.getTargetStep();
        this.currentTargetProperty = targetStep2 != null && this.targetType != null ? targetStep2.getProperty(this.targetType) : null;
        this.propertyChangeSupport.firePropertyChange(TARGET_TYPE_PROPERTY, old, name);
    }

    public String getName() {
        return this.config.getName();
    }

    public void setSourcePath(String path) {
        String old = this.sourcePath;
        this.sourcePath = path;
        this.config.setSourcePath(path);
        this.propertyChangeSupport.firePropertyChange(SOURCE_PATH_PROPERTY, old, path);
    }

    public void setTargetPath(String path) {
        String old = this.targetPath;
        this.targetPath = path;
        this.config.setTargetPath(path);
        this.propertyChangeSupport.firePropertyChange(TARGET_PATH_PROPERTY, old, path);
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.config.setName(name);
        this.propertyChangeSupport.firePropertyChange(NAME_PROPERTY, old, name);
    }

    public TestPropertyHolder getSourceStep() {
        return this.getPropertyHolder(this.getSourceStepName());
    }

    public String getSourceStepName() {
        if (this.sourceStep != null) {
            return this.sourceStep;
        }
        if (this.testCase == null) {
            return null;
        }
        HttpRequestTestStep step = this.testCase.findPreviousStepOfType(this.testStep, HttpRequestTestStep.class);
        return step == null ? null : step.getName();
    }

    public void setSourceStepName(String sourceStep) {
        String old = this.getSourceStepName();
        if (sourceStep == null && old == null || sourceStep != null && old != null && sourceStep.equals(old)) {
            return;
        }
        if (sourceStep == null) {
            log.debug((Object)("Setting sourceStep for transfer [" + this.getName() + "] to null"));
        }
        this.sourceStep = sourceStep;
        this.config.setSourceStep(sourceStep);
        if (this.currentSourceStep != null) {
            if (this.currentSourceStep instanceof TestStep) {
                ((TestStep)this.currentSourceStep).removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentSourceStep.removeTestPropertyListener(this.propertyNameChangeListener);
        }
        this.currentSourceStep = this.getPropertyHolder(sourceStep);
        if (this.currentSourceStep != null) {
            if (this.currentSourceStep instanceof TestStep) {
                ((TestStep)this.currentSourceStep).addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentSourceStep.addTestPropertyListener(this.propertyNameChangeListener);
        } else {
            log.warn((Object)("Failed to get sourceStep [" + sourceStep + "]"));
        }
        this.propertyChangeSupport.firePropertyChange(SOURCE_STEP_PROPERTY, old, sourceStep);
        this.setSourcePropertyName(null);
    }

    public TestPropertyHolder getTargetStep() {
        return this.getPropertyHolder(this.getTargetStepName());
    }

    public String getTargetStepName() {
        if (this.targetStep != null) {
            return this.targetStep;
        }
        if (this.testCase == null) {
            return null;
        }
        HttpRequestTestStep step = this.testCase.findNextStepOfType(this.testStep, HttpRequestTestStep.class);
        return step == null ? null : step.getName();
    }

    public void setTargetStepName(String targetStep) {
        String old = this.getTargetStepName();
        if (targetStep == null && old == null || targetStep != null && old != null && targetStep.equals(old)) {
            return;
        }
        if (targetStep == null) {
            log.debug((Object)("Setting targetStep for transfer [" + this.getName() + "] to null"));
        }
        this.targetStep = targetStep;
        this.config.setTargetStep(targetStep);
        if (this.currentTargetStep != null) {
            if (this.currentTargetStep instanceof TestStep) {
                ((TestStep)this.currentTargetStep).removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentTargetStep.removeTestPropertyListener(this.propertyNameChangeListener);
        }
        this.currentTargetStep = this.getPropertyHolder(targetStep);
        if (this.currentTargetStep != null) {
            if (this.currentTargetStep instanceof TestStep) {
                ((TestStep)this.currentTargetStep).addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            }
            this.currentTargetStep.addTestPropertyListener(this.propertyNameChangeListener);
        } else {
            log.warn((Object)("Failed to get targetStep [" + targetStep + "]"));
        }
        this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, old, targetStep);
        this.setTargetPropertyName(null);
    }

    private TestPropertyHolder getPropertyHolder(String name) {
        if (!StringUtils.hasContent(name) || this.testCase == null) {
            return null;
        }
        if (name.charAt(0) == '#') {
            if (name.equals("#Global#")) {
                return PropertyExpansionUtils.getGlobalProperties();
            }
            if (name.equals("#Project#")) {
                return this.testCase.getTestSuite().getProject();
            }
            if (name.equals("#TestSuite#")) {
                return this.testCase.getTestSuite();
            }
            if (name.equals("#TestCase#")) {
                return this.testCase;
            }
        }
        return this.testStep.getTestCase().getTestStepByName(name);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public boolean getFailOnError() {
        return this.config.getFailOnError();
    }

    public void setFailOnError(boolean failOnError) {
        this.config.setFailOnError(failOnError);
    }

    public boolean getTransferToAll() {
        return this.config.getTransferToAll();
    }

    public void setTransferToAll(boolean transferToAll) {
        this.config.setTransferToAll(transferToAll);
    }

    public boolean getUseXQuery() {
        return this.config.getUseXQuery();
    }

    public void setUseXQuery(boolean useXQuery) {
        this.config.setUseXQuery(useXQuery);
    }

    public boolean getEntitize() {
        return this.config.getEntitize();
    }

    public void setEntitize(boolean entitize) {
        this.config.setEntitize(entitize);
    }

    public boolean getIgnoreEmpty() {
        return this.config.getIgnoreEmpty();
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.config.setIgnoreEmpty(ignoreEmpty);
    }

    public boolean getSetNullOnMissingSource() {
        return this.config.getSetNullOnMissingSource();
    }

    public void setSetNullOnMissingSource(boolean setNullOnMissingSource) {
        this.config.setSetNullOnMissingSource(setNullOnMissingSource);
    }

    public boolean getTransferTextContent() {
        return this.config.getTransferTextContent();
    }

    public void setTransferTextContent(boolean transferTextContent) {
        this.config.setTransferTextContent(transferTextContent);
    }

    public boolean isDisabled() {
        return this.config.getDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.config.setDisabled(disabled);
    }

    public boolean getTransferChildNodes() {
        return this.config.getTransferChildNodes();
    }

    public void setTransferChildNodes(boolean b) {
        this.config.setTransferChildNodes(b);
    }

    public void resolve(ResolveContext<?> context, PropertyTransfersTestStep parent) {
        ResolveContext.PathToResolve path;
        if (this.isDisabled()) {
            return;
        }
        if (this.getSourceProperty() == null) {
            if (context.hasThisModelItem(parent, "Resolve source property", this.getConfig().getSourceStep())) {
                return;
            }
            context.addPathToResolve(parent, "Resolve source property", this.getConfig().getSourceStep()).addResolvers(new DisablePropertyTransferResolver(this), new CreateMissingPropertyResolver(this, parent), new ChooseAnotherPropertySourceResolver(this, parent));
        } else if (context.hasThisModelItem(parent, "Resolve source property", this.getConfig().getSourceStep())) {
            path = context.getPath(parent, "Resolve source property", this.getConfig().getSourceStep());
            path.setSolved(true);
        }
        if (this.getTargetProperty() == null) {
            if (context.hasThisModelItem(parent, "Resolve target property", this.getConfig().getTargetStep())) {
                return;
            }
            context.addPathToResolve(parent, "Resolve target property", this.getConfig().getTargetStep()).addResolvers(new DisablePropertyTransferResolver(this), new CreateMissingPropertyResolver(this, parent), new ChooseAnotherPropertyTargetResolver(this, parent));
        } else if (context.hasThisModelItem(parent, "Resolve target property", this.getConfig().getTargetStep())) {
            path = context.getPath(parent, "Resolve target property", this.getConfig().getTargetStep());
            path.setSolved(true);
        }
    }

    private class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        public void propertyRenamed(String oldName, String newName) {
            if (oldName.equals(PropertyTransfer.this.sourceType)) {
                PropertyTransfer.this.sourceType = newName;
                PropertyTransfer.this.config.setSourceType(PropertyTransfer.this.sourceType);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(SOURCE_TYPE_PROPERTY, oldName, PropertyTransfer.this.sourceType);
            }
            if (oldName.equals(PropertyTransfer.this.targetType)) {
                PropertyTransfer.this.targetType = newName;
                PropertyTransfer.this.config.setTargetType(PropertyTransfer.this.targetType);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(TARGET_TYPE_PROPERTY, oldName, PropertyTransfer.this.targetType);
            }
        }

        public void propertyRemoved(String name) {
            if (name.equals(PropertyTransfer.this.sourceType)) {
                log.warn((Object)("source property for transfer [" + PropertyTransfer.this.getName() + "] in teststep [" + PropertyTransfer.this.testStep.getName() + "/" + PropertyTransfer.this.testStep.getTestCase().getName() + "/" + PropertyTransfer.this.testStep.getTestCase().getTestSuite().getName() + "] set to null, was [" + name + "]"));
                PropertyTransfer.this.currentSourceProperty = null;
                PropertyTransfer.this.setSourcePropertyName(null);
            }
            if (name.equals(PropertyTransfer.this.targetType)) {
                log.warn((Object)("target property for transfer [" + PropertyTransfer.this.getName() + "] in teststep [" + PropertyTransfer.this.testStep.getName() + "/" + PropertyTransfer.this.testStep.getTestCase().getName() + "/" + PropertyTransfer.this.testStep.getTestCase().getTestSuite().getName() + "] set to null, was [" + name + "]"));
                PropertyTransfer.this.currentTargetProperty = null;
                PropertyTransfer.this.setTargetPropertyName(null);
            }
        }
    }

    private class StepNameChangeListener
    implements PropertyChangeListener {
        private StepNameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String oldName = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            if (newValue == null) {
                log.error((Object)"Tried to change stepname to null!");
                Thread.dumpStack();
                return;
            }
            if (oldName.equals(PropertyTransfer.this.sourceStep) && PropertyTransfer.this.currentSourceStep instanceof TestStep) {
                PropertyTransfer.this.sourceStep = newValue;
                PropertyTransfer.this.config.setSourceStep(PropertyTransfer.this.sourceStep);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(SOURCE_STEP_PROPERTY, oldName, PropertyTransfer.this.sourceStep);
            }
            if (oldName.equals(PropertyTransfer.this.targetStep) && PropertyTransfer.this.currentTargetStep instanceof TestStep) {
                PropertyTransfer.this.targetStep = newValue;
                PropertyTransfer.this.config.setTargetStep(PropertyTransfer.this.targetStep);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, oldName, PropertyTransfer.this.targetStep);
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == PropertyTransfer.this.testCase) {
                String stepName = testStep.getName();
                if (stepName.equals(PropertyTransfer.this.sourceStep)) {
                    PropertyTransfer.this.setSourceStepName(null);
                }
                if (stepName.equals(PropertyTransfer.this.targetStep)) {
                    PropertyTransfer.this.setTargetStepName(null);
                }
            }
        }
    }
}

