/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.OutgoingWssConfig;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntryRegistry;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingWss
implements PropertyExpansionContainer {
    public static final String WSSENTRY_PROPERTY = OutgoingWss.class.getName() + "@wssEntry";
    private OutgoingWssConfig config;
    private List<WssEntry> entries = new ArrayList<WssEntry>();
    private final DefaultWssContainer container;

    public OutgoingWss(OutgoingWssConfig config, DefaultWssContainer container) {
        this.config = config;
        this.container = container;
        for (WSSEntryConfig entryConfig : config.getEntryList()) {
            WssEntry entry = (WssEntry)WssEntryRegistry.get().build(entryConfig, this);
            if (entry == null) continue;
            this.entries.add(entry);
        }
    }

    public WssContainer getWssContainer() {
        return this.container;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getPassword() {
        return this.config.getPassword();
    }

    public String getUsername() {
        return this.config.getUsername();
    }

    public void setName(String arg0) {
        this.config.setName(arg0);
    }

    public void setPassword(String arg0) {
        this.config.setPassword(arg0);
    }

    public void setUsername(String arg0) {
        this.config.setUsername(arg0);
    }

    public String getActor() {
        return this.config.getActor();
    }

    public boolean getMustUnderstand() {
        return this.config.getMustUnderstand();
    }

    public void setActor(String arg0) {
        this.config.setActor(arg0);
    }

    public void setMustUnderstand(boolean arg0) {
        this.config.setMustUnderstand(arg0);
    }

    public WssEntry addEntry(String type) {
        WssEntry newEntry = (WssEntry)WssEntryRegistry.get().create(type, this);
        this.entries.add(newEntry);
        this.container.fireWssEntryAdded(newEntry);
        return newEntry;
    }

    public void removeEntry(WssEntry entry) {
        int index = this.entries.indexOf(entry);
        this.container.fireWssEntryRemoved(this.entries.remove(index));
        this.config.removeEntry(index);
        entry.release();
    }

    public OutgoingWssConfig getConfig() {
        return this.config;
    }

    public void processOutgoing(Document soapDocument, PropertyExpansionContext context) {
        Element header = WSSecurityUtil.findWsseSecurityHeaderBlock((Document)soapDocument, (Element)soapDocument.getDocumentElement(), (boolean)false);
        while (header != null) {
            header.getParentNode().removeChild(header);
            header = WSSecurityUtil.findWsseSecurityHeaderBlock((Document)soapDocument, (Element)soapDocument.getDocumentElement(), (boolean)false);
        }
        WSSecHeader secHeader = new WSSecHeader();
        if (StringUtils.hasContent(this.getActor())) {
            secHeader.setActor(this.getActor());
        }
        secHeader.setMustUnderstand(this.getMustUnderstand());
        secHeader.insertSecurityHeader(soapDocument);
        for (WssEntry entry : this.entries) {
            try {
                entry.process(secHeader, soapDocument, context);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    public List<WssEntry> getEntries() {
        return this.entries;
    }

    public void updateConfig(OutgoingWssConfig config) {
        this.config = config;
        for (int c = 0; c < this.entries.size(); ++c) {
            this.entries.get(c).udpateConfig(this.config.getEntryArray(c));
        }
    }

    public void release() {
        for (WssEntry entry : this.entries) {
            entry.release();
        }
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.getWssContainer().getModelItem(), this);
        result.extractAndAddAll("username");
        result.extractAndAddAll("password");
        for (WssEntry entry : this.entries) {
            if (!(entry instanceof PropertyExpansionContainer)) continue;
            result.addAll(((PropertyExpansionContainer)((Object)entry)).getPropertyExpansions());
        }
        return result.toArray();
    }

    public void resolve(ResolveContext<?> context) {
    }
}

