/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSoapVersion
implements SoapVersion {
    private static final Logger log = Logger.getLogger(AbstractSoapVersion.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSoapEnvelope(String soapMessage, List<XmlError> errors) {
        ArrayList errorList = new ArrayList();
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            xmlOptions.setValidateTreatLaxAsSkip();
            xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            XmlObject xmlObject = this.getSoapEnvelopeSchemaLoader().parse(soapMessage, this.getEnvelopeType(), xmlOptions);
            xmlOptions.setErrorListener(errorList);
            xmlObject.validate(xmlOptions);
        }
        catch (XmlException e) {
            if (e.getErrors() != null) {
                errorList.addAll(e.getErrors());
            }
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        finally {
            for (XmlError error : errorList) {
                if (error instanceof XmlValidationError && this.shouldIgnore((XmlValidationError)error)) {
                    log.warn((Object)("Ignoring validation error: " + error.toString()));
                    continue;
                }
                errors.add(error);
            }
        }
    }

    protected abstract SchemaTypeLoader getSoapEnvelopeSchemaLoader();

    @Override
    public boolean shouldIgnore(XmlValidationError error) {
        QName offendingQName = error.getOffendingQName();
        if (offendingQName != null) {
            if (offendingQName.equals(new QName(this.getEnvelopeNamespace(), "encodingStyle"))) {
                return true;
            }
            if (offendingQName.equals(new QName(this.getEnvelopeNamespace(), "mustUnderstand"))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract SchemaType getFaultType();

    @Override
    public abstract SchemaType getEnvelopeType();
}

