/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.assertions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionsSupport
implements PropertyChangeListener {
    private List<AssertionsListener> assertionsListeners = new ArrayList<AssertionsListener>();
    private List<WsdlMessageAssertion> assertions = new ArrayList<WsdlMessageAssertion>();
    private final Assertable assertable;
    private AssertableConfig modelItemConfig;

    public AssertionsSupport(Assertable assertable, AssertableConfig modelItemConfig) {
        this.assertable = assertable;
        this.modelItemConfig = modelItemConfig;
        for (TestAssertionConfig rac : modelItemConfig.getAssertionList()) {
            this.addWsdlAssertion(rac);
        }
    }

    public WsdlMessageAssertion addWsdlAssertion(TestAssertionConfig config) {
        try {
            WsdlMessageAssertion assertion = TestAssertionRegistry.getInstance().buildAssertion(config, this.assertable);
            if (assertion == null) {
                return null;
            }
            this.assertions.add(assertion);
            assertion.addPropertyChangeListener(this);
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.assertable instanceof PropertyChangeListener) {
            ((PropertyChangeListener)((Object)this.assertable)).propertyChange(arg0);
        }
    }

    public int getAssertionCount() {
        return this.assertions.size();
    }

    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertions.get(c);
    }

    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsListeners.add(listener);
    }

    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsListeners.remove(listener);
    }

    public void removeAssertion(WsdlMessageAssertion assertion) {
        int ix = this.assertions.indexOf(assertion);
        if (ix == -1) {
            throw new RuntimeException("assertion [" + assertion.getName() + "] not available ");
        }
        assertion.removePropertyChangeListener(this);
        this.assertions.remove(ix);
        this.fireAssertionRemoved(assertion);
        assertion.release();
        this.modelItemConfig.removeAssertion(ix);
    }

    public WsdlMessageAssertion moveAssertion(int ix, int offset) {
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        if (ix == -1) {
            throw new RuntimeException("assertion [" + assertion.getName() + "] not available ");
        }
        if (ix == 0 && offset == -1 || ix == this.assertions.size() - 1 && offset == 1) {
            return assertion;
        }
        TestAssertionConfig conf = assertion.getConfig();
        XmlObject newXmlObject = conf.copy();
        TestAssertionConfig newConf = TestAssertionConfig.Factory.newInstance();
        newConf.set(newXmlObject);
        WsdlMessageAssertion newAssertion = TestAssertionRegistry.getInstance().buildAssertion(newConf, this.assertable);
        assertion.removePropertyChangeListener(this);
        this.assertions.remove(ix);
        assertion.release();
        this.modelItemConfig.removeAssertion(ix);
        newAssertion.addPropertyChangeListener(this);
        this.assertions.add(ix + offset, newAssertion);
        this.modelItemConfig.insertAssertion(newConf, ix + offset);
        this.fireAssertionMoved(newAssertion, ix, offset);
        return newAssertion;
    }

    public void release() {
        for (WsdlMessageAssertion assertion : this.assertions) {
            assertion.release();
        }
    }

    public Iterator<WsdlMessageAssertion> iterator() {
        return this.assertions.iterator();
    }

    public void fireAssertionAdded(WsdlMessageAssertion assertion) {
        AssertionsListener[] listeners = this.assertionsListeners.toArray(new AssertionsListener[this.assertionsListeners.size()]);
        for (int c = 0; c < listeners.length; ++c) {
            listeners[c].assertionAdded(assertion);
        }
    }

    public void fireAssertionRemoved(WsdlMessageAssertion assertion) {
        AssertionsListener[] listeners = this.assertionsListeners.toArray(new AssertionsListener[this.assertionsListeners.size()]);
        for (int c = 0; c < listeners.length; ++c) {
            listeners[c].assertionRemoved(assertion);
        }
    }

    public void fireAssertionMoved(WsdlMessageAssertion assertion, int ix, int offset) {
        AssertionsListener[] listeners = this.assertionsListeners.toArray(new AssertionsListener[this.assertionsListeners.size()]);
        for (int c = 0; c < listeners.length; ++c) {
            listeners[c].assertionMoved(assertion, ix, offset);
        }
    }

    public void refresh() {
        int mod = 0;
        List<TestAssertionConfig> assertionList = this.modelItemConfig.getAssertionList();
        for (int i = 0; i < assertionList.size(); ++i) {
            TestAssertionConfig config = assertionList.get(i);
            if (TestAssertionRegistry.getInstance().canBuildAssertion(config)) {
                this.assertions.get(i - mod).updateConfig(config);
                continue;
            }
            ++mod;
        }
    }

    public List<WsdlMessageAssertion> getAssertionList() {
        return this.assertions;
    }

    public List<WsdlMessageAssertion> getAssertionsOfType(Class<? extends WsdlMessageAssertion> class1) {
        ArrayList<WsdlMessageAssertion> result = new ArrayList<WsdlMessageAssertion>();
        for (WsdlMessageAssertion assertion : this.assertions) {
            if (!assertion.getClass().equals(class1)) continue;
            result.add(assertion);
        }
        return result;
    }

    public WsdlMessageAssertion getAssertionByName(String name) {
        for (WsdlMessageAssertion assertion : this.assertions) {
            if (!assertion.getName().equals(name)) continue;
            return assertion;
        }
        return null;
    }

    public Map<String, TestAssertion> getAssertions() {
        HashMap<String, TestAssertion> result = new HashMap<String, TestAssertion>();
        for (WsdlMessageAssertion assertion : this.assertions) {
            result.put(assertion.getName(), assertion);
        }
        return result;
    }

    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy) {
        TestAssertionConfig conf = this.modelItemConfig.addNewAssertion();
        conf.set((XmlObject)source.getConfig());
        if (createCopy && conf.isSetId()) {
            conf.unsetId();
        }
        if (!source.isAllowMultiple()) {
            List<WsdlMessageAssertion> existing = this.getAssertionsOfType(source.getClass());
            if (!existing.isEmpty() && !overwrite2) {
                return null;
            }
            while (!existing.isEmpty()) {
                this.removeAssertion(existing.remove(0));
            }
        }
        WsdlMessageAssertion result = this.addWsdlAssertion(conf);
        this.fireAssertionAdded(result);
        return result;
    }

    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        TestAssertionConfig conf = this.modelItemConfig.addNewAssertion();
        conf.set((XmlObject)((WsdlMessageAssertion)source).getConfig());
        conf.setName(name);
        WsdlMessageAssertion result = this.addWsdlAssertion(conf);
        this.fireAssertionAdded(result);
        return result;
    }

    public WsdlMessageAssertion addWsdlAssertion(String assertionLabel) {
        try {
            TestAssertionConfig assertionConfig = this.modelItemConfig.addNewAssertion();
            assertionConfig.setType(TestAssertionRegistry.getInstance().getAssertionTypeForName(assertionLabel));
            WsdlMessageAssertion assertion = this.addWsdlAssertion(assertionConfig);
            if (assertion == null) {
                return null;
            }
            this.fireAssertionAdded(assertion);
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public void resolve(ResolveContext<?> context) {
        for (WsdlMessageAssertion assertion : this.assertions) {
            assertion.resolve(context);
        }
    }
}

