/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileAttachment<T extends AbstractWsdlModelItem<?>>
implements WsdlAttachment {
    private AttachmentConfig config;
    private static final Logger log = Logger.getLogger(FileAttachment.class);
    private final T modelItem;
    private BeanPathPropertySupport urlProperty;

    public FileAttachment(T modelItem, AttachmentConfig config) {
        this.modelItem = modelItem;
        this.config = config;
        if (config.getTempFilename() != null) {
            try {
                log.info((Object)("Moving locally cached file [" + config.getTempFilename() + "] to internal cache.."));
                File tempFile = new File(config.getTempFilename());
                this.cacheFileLocally(tempFile);
            }
            catch (IOException e) {
                if (!config.isSetData()) {
                    config.setData(new byte[0]);
                    config.setSize(0L);
                }
                SoapUI.logError(e);
            }
        }
        if (this.isCached()) {
            if (config.isSetTempFilename()) {
                config.unsetTempFilename();
            }
            if (config.isSetUrl()) {
                config.unsetUrl();
            }
        }
        this.urlProperty = new BeanPathPropertySupport((AbstractWsdlModelItem<?>)modelItem, config, "url");
    }

    public FileAttachment(T modelItem, File file, boolean cache, AttachmentConfig config) throws IOException {
        this(modelItem, config);
        config.setName(file.getName());
        config.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
        if (cache) {
            this.cacheFileLocally(file);
        }
        this.urlProperty.set(file.getPath(), false);
    }

    @Override
    public void setName(String value) {
        this.config.setName(value);
    }

    @Override
    public void setUrl(String url) {
        this.urlProperty.set(url, true);
    }

    @Override
    public void reload(File file, boolean cache) throws IOException {
        this.config.setName(file.getName());
        this.config.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
        if (cache) {
            this.cacheFileLocally(file);
        } else {
            this.urlProperty.set(file.getPath(), false);
            this.config.unsetData();
        }
    }

    public T getModelItem() {
        return this.modelItem;
    }

    public void cacheFileLocally(File file) throws FileNotFoundException, IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(data);
        out.putNextEntry(new ZipEntry(this.config.getName()));
        FileInputStream in = new FileInputStream(file);
        long sz = file.length();
        this.config.setSize(sz);
        Tools.writeAll(out, in);
        ((InputStream)in).close();
        out.closeEntry();
        out.finish();
        out.close();
        data.close();
        this.config.setData(data.toByteArray());
    }

    @Override
    public String getContentType() {
        Attachment.AttachmentEncoding encoding = this.getEncoding();
        if (encoding == Attachment.AttachmentEncoding.NONE) {
            return this.config.getContentType();
        }
        return "application/octet-stream";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        BufferedInputStream inputStream = null;
        if (this.isCached()) {
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.config.getData()));
            zipInputStream.getNextEntry();
            inputStream = new BufferedInputStream(zipInputStream);
        } else {
            String url = this.urlProperty.expand();
            inputStream = new BufferedInputStream(url == null ? new ByteArrayInputStream(new byte[0]) : new FileInputStream(url));
        }
        Attachment.AttachmentEncoding encoding = this.getEncoding();
        if (encoding == Attachment.AttachmentEncoding.BASE64) {
            ByteArrayOutputStream data = Tools.readAll(inputStream, 0L);
            return new ByteArrayInputStream(Base64.encodeBase64((byte[])data.toByteArray()));
        }
        if (encoding == Attachment.AttachmentEncoding.HEX) {
            ByteArrayOutputStream data = Tools.readAll(inputStream, 0L);
            return new ByteArrayInputStream(new String(Hex.encodeHex((byte[])data.toByteArray())).getBytes());
        }
        return inputStream;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public long getSize() {
        File file;
        if (this.isCached()) {
            return this.config.getSize();
        }
        String url = this.urlProperty.expand();
        if (url != null && (file = new File(url)).exists()) {
            return file.length();
        }
        return -1L;
    }

    public void release() {
        if (this.isCached()) {
            new File(this.config.getTempFilename()).delete();
        }
    }

    @Override
    public String getPart() {
        return this.config.getPart();
    }

    @Override
    public void setContentType(String contentType) {
        this.config.setContentType(contentType);
    }

    @Override
    public void setPart(String part) {
        this.config.setPart(part);
    }

    public void setData(byte[] data) {
        try {
            ByteArrayOutputStream tempData = new ByteArrayOutputStream();
            ZipOutputStream out = new ZipOutputStream(tempData);
            out.putNextEntry(new ZipEntry(this.config.getName()));
            this.config.setSize((long)data.length);
            out.write(data);
            out.closeEntry();
            out.finish();
            out.close();
            this.config.setData(tempData.toByteArray());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public byte[] getData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Tools.writeAll(out, this.getInputStream());
        return out.toByteArray();
    }

    @Override
    public String getUrl() {
        return this.urlProperty.get();
    }

    @Override
    public boolean isCached() {
        return this.config.isSetData();
    }

    @Override
    public abstract Attachment.AttachmentType getAttachmentType();

    @Override
    public void updateConfig(AttachmentConfig config) {
        this.config = config;
        this.urlProperty.setConfig(config);
    }

    public AttachmentConfig getConfig() {
        return this.config;
    }

    @Override
    public void setContentID(String contentID) {
        if ((contentID == null || contentID.length() == 0) && this.config.isSetContentId()) {
            this.config.unsetContentId();
        } else {
            this.config.setContentId(contentID);
        }
    }

    @Override
    public String getContentID() {
        return this.config.getContentId();
    }

    public void resolve(ResolveContext<?> context) {
        if (this.isCached()) {
            return;
        }
        this.urlProperty.resolveFile(context, "Missing attachment [" + this.getName() + "]", null, null, false);
    }

    @Override
    public String getContentEncoding() {
        Attachment.AttachmentEncoding encoding = this.getEncoding();
        if (encoding == Attachment.AttachmentEncoding.BASE64) {
            return "base64";
        }
        if (encoding == Attachment.AttachmentEncoding.HEX) {
            return "hex";
        }
        return "binary";
    }
}

