/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.PostResponseDataSource;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.settings.HttpSettings;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeMessageResponse
extends BaseHttpResponse {
    private long timeTaken;
    private long responseContentLength;
    private String requestContent;
    private MultipartMessageSupport mmSupport;
    private PostResponseDataSource postResponseDataSource;

    public MimeMessageResponse(AbstractHttpRequestInterface<?> httpRequest, ExtendedHttpMethod httpMethod, String requestContent, PropertyExpansionContext context) {
        super(httpMethod, httpRequest);
        if (this.getRequestContent() == null || !this.getRequestContent().equals(requestContent)) {
            this.requestContent = requestContent;
        }
        try {
            this.postResponseDataSource = new PostResponseDataSource(httpMethod);
            this.responseContentLength = this.postResponseDataSource.getDataSize();
            Header h = httpMethod.getResponseHeader("Content-Type");
            HeaderElement[] elements = h.getElements();
            String rootPartId = null;
            for (HeaderElement element : elements) {
                NameValuePair parameter;
                String name = element.getName().toUpperCase();
                if (!name.startsWith("MULTIPART/") || (parameter = element.getParameterByName("start")) == null) continue;
                rootPartId = parameter.getValue();
            }
            this.mmSupport = new MultipartMessageSupport(this.postResponseDataSource, rootPartId, (AbstractHttpOperation)httpRequest.getOperation(), false, httpRequest.isPrettyPrint());
            if (httpRequest.getSettings().getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)) {
                this.timeTaken += httpMethod.getResponseReadTime();
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected MultipartMessageSupport getMmSupport() {
        return this.mmSupport;
    }

    @Override
    public long getContentLength() {
        return this.responseContentLength;
    }

    @Override
    public String getRequestContent() {
        return this.requestContent == null ? super.getRequestContent() : this.requestContent;
    }

    @Override
    public void setResponseContent(String responseContent) {
        String oldContent = this.getContentAsString();
        this.mmSupport.setResponseContent(responseContent);
        ((AbstractHttpRequest)this.getRequest()).notifyPropertyChanged(WsdlRequest.RESPONSE_CONTENT_PROPERTY, oldContent, responseContent);
    }

    @Override
    public Attachment[] getAttachments() {
        return this.mmSupport.getAttachments();
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        return this.mmSupport.getAttachmentsForPart(partName);
    }

    @Override
    public String getContentAsString() {
        return this.mmSupport.getContentAsString();
    }
}

