/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmContainer;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmUtils;
import com.eviware.soapui.model.iface.SubmitContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmRequestFilter
extends AbstractRequestFilter {
    public static final Logger log = Logger.getLogger(WsrmRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        if (!(wsdlRequest instanceof WsrmContainer) || !((WsrmContainer)((Object)wsdlRequest)).isWsrmEnabled() || ((WsrmContainer)((Object)wsdlRequest)).getWsrmConfig().getSequenceIdentifier() == null) {
            return;
        }
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn((Object)"Missing request content in context, skipping ws-addressing");
        } else {
            long msgNumber;
            String identifier;
            ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)context.getProperty("httpMethod");
            WsdlOperation operation = ((WsdlRequest)wsdlRequest).getOperation();
            SoapVersion soapVersion = operation.getInterface().getSoapVersion();
            if ((content = new WsrmUtils(content, soapVersion, context).createNewWSReliableMessagingRequest((WsdlRequest)wsdlRequest, httpMethod, identifier = ((WsdlRequest)wsdlRequest).getWsrmConfig().getSequenceIdentifier(), msgNumber = ((WsdlRequest)wsdlRequest).getWsrmConfig().getLastMessageId().longValue(), wsdlRequest.getEndpoint())) != null) {
                context.setProperty("requestContent", content);
            }
        }
    }
}

