/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.RestRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.RestRequestMimeMessageRequestEntity;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.xmlbeans.XmlBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterHttpRequest(SubmitContext context, HttpRequestInterface<?> request) {
        String requestContent;
        String acceptEncoding;
        HttpMethod httpMethod = (HttpMethod)context.getProperty("httpMethod");
        String path = PropertyExpander.expandProperties(context, request.getPath());
        StringBuffer query = new StringBuffer();
        StringToStringMap responseProperties = (StringToStringMap)context.getProperty("httpResponseProperties");
        MimeMultipart formMp = "multipart/form-data".equals(request.getMediaType()) && httpMethod instanceof EntityEnclosingMethod ? new MimeMultipart() : null;
        RestParamsPropertyHolder params = request.getParams();
        block18: for (int c = 0; c < params.getPropertyCount(); ++c) {
            RestParamProperty param = params.getPropertyAt(c);
            String value = PropertyExpander.expandProperties(context, param.getValue());
            responseProperties.put(param.getName(), value);
            if (value != null && !param.isDisableUrlEncoding()) {
                try {
                    String encoding = System.getProperty("soapui.request.encoding", request.getEncoding());
                    value = StringUtils.hasContent(encoding) ? URLEncoder.encode(value, encoding) : URLEncoder.encode(value);
                }
                catch (UnsupportedEncodingException e1) {
                    SoapUI.logError(e1);
                    value = URLEncoder.encode(value);
                }
                value = value.replaceAll("\\+", "%20");
            }
            if (!StringUtils.hasContent(value) && !param.getRequired()) continue;
            switch (param.getStyle()) {
                case HEADER: {
                    httpMethod.setRequestHeader(param.getName(), value);
                    continue block18;
                }
                case QUERY: {
                    if (formMp == null || !request.isPostQueryString()) {
                        if (query.length() > 0) {
                            query.append('&');
                        }
                        query.append(URLEncoder.encode(param.getName()));
                        query.append('=');
                        if (!StringUtils.hasContent(value)) continue block18;
                        query.append(value);
                        continue block18;
                    }
                    try {
                        this.addFormMultipart(request, formMp, param.getName(), value);
                    }
                    catch (MessagingException e) {
                        e.printStackTrace();
                    }
                    continue block18;
                }
                case TEMPLATE: {
                    path = path.replaceAll("\\{" + param.getName() + "\\}", value);
                    continue block18;
                }
                case MATRIX: {
                    if (param.getType().equals(XmlBoolean.type.getName())) {
                        if (!value.toUpperCase().equals("TRUE") && !value.equals("1")) continue block18;
                        path = path + ";" + param.getName();
                        continue block18;
                    }
                    path = path + ";" + param.getName();
                    if (!StringUtils.hasContent(value)) continue block18;
                    path = path + "=" + value;
                }
            }
        }
        if (PathUtils.isHttpPath(path = PathUtils.fixForwardSlashesInPath(path))) {
            try {
                URI uri = new URI(URLDecoder.decode(path));
                context.setProperty("requestUri", uri);
                httpMethod.setURI(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (StringUtils.hasContent(path)) {
            httpMethod.setPath(path);
        }
        if (query.length() > 0 && !request.isPostQueryString()) {
            httpMethod.setQueryString(query.toString());
        }
        if (request instanceof RestRequest && StringUtils.hasContent(acceptEncoding = ((RestRequest)request).getAccept())) {
            httpMethod.setRequestHeader("Accept", acceptEncoding);
        }
        String encoding = System.getProperty("soapui.request.encoding", StringUtils.unquote(request.getEncoding()));
        if (formMp != null) {
            try {
                if (request.hasRequestBody() && httpMethod instanceof EntityEnclosingMethod && StringUtils.hasContent(requestContent = PropertyExpansionUtils.expandProperties(context, request.getRequestContent(), request.isEntitizeProperties()))) {
                    this.initRootPart(request, requestContent, formMp);
                }
                for (Attachment attachment : request.getAttachments()) {
                    PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                    if (attachment instanceof FileAttachment) {
                        part.setDisposition("form-data; name=\"" + attachment.getName() + "\"; filename=\"" + ((FileAttachment)attachment).getName() + "\"");
                    } else {
                        part.setDisposition("form-data; name=\"" + attachment.getName() + "\"");
                    }
                    part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(attachment)));
                    formMp.addBodyPart((BodyPart)part);
                }
                MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
                message.setContent((Multipart)formMp);
                message.saveChanges();
                RestRequestMimeMessageRequestEntity mimeMessageRequestEntity = new RestRequestMimeMessageRequestEntity(message, request);
                ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)mimeMessageRequestEntity);
                httpMethod.setRequestHeader("Content-Type", mimeMessageRequestEntity.getContentType());
                httpMethod.setRequestHeader("MIME-Version", "1.0");
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        } else if (request.hasRequestBody() && httpMethod instanceof EntityEnclosingMethod) {
            httpMethod.setRequestHeader("Content-Type", this.getContentTypeHeader(request.getMediaType(), encoding));
            if (request.isPostQueryString()) {
                ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(query.toString()));
            } else {
                requestContent = PropertyExpansionUtils.expandProperties(context, request.getRequestContent(), request.isEntitizeProperties());
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Attachment attachment : request.getAttachments()) {
                    if (!attachment.getContentType().equals(request.getMediaType())) continue;
                    attachments.add(attachment);
                }
                if (StringUtils.hasContent(requestContent) && attachments.isEmpty()) {
                    try {
                        byte[] content = encoding == null ? requestContent.getBytes() : requestContent.getBytes(encoding);
                        ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
                    }
                    catch (UnsupportedEncodingException e) {
                        ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)new ByteArrayRequestEntity(requestContent.getBytes()));
                    }
                } else if (attachments.size() > 0) {
                    try {
                        MimeMultipart mp = null;
                        if (StringUtils.hasContent(requestContent)) {
                            mp = new MimeMultipart();
                            this.initRootPart(request, requestContent, mp);
                        } else if (attachments.size() == 1) {
                            ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)new InputStreamRequestEntity(((Attachment)attachments.get(0)).getInputStream()));
                            httpMethod.setRequestHeader("Content-Type", this.getContentTypeHeader(request.getMediaType(), encoding));
                        }
                        if (((EntityEnclosingMethod)httpMethod).getRequestEntity() == null) {
                            if (mp == null) {
                                mp = new MimeMultipart();
                            }
                            AttachmentUtils.addMimeParts(request, attachments, mp, new StringToStringMap());
                            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
                            message.setContent((Multipart)mp);
                            message.saveChanges();
                            RestRequestMimeMessageRequestEntity mimeMessageRequestEntity = new RestRequestMimeMessageRequestEntity(message, request);
                            ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)mimeMessageRequestEntity);
                            httpMethod.setRequestHeader("Content-Type", this.getContentTypeHeader(mimeMessageRequestEntity.getContentType(), encoding));
                            httpMethod.setRequestHeader("MIME-Version", "1.0");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String getContentTypeHeader(String contentType, String encoding) {
        return encoding == null || encoding.trim().length() == 0 ? contentType : contentType + ";charset=" + encoding;
    }

    private void addFormMultipart(HttpRequestInterface<?> request, MimeMultipart formMp, String name, String value) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        if (value.startsWith("file:")) {
            String fileName = value.substring(5);
            File file = new File(fileName);
            part.setDisposition("form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"");
            if (file.exists()) {
                part.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
            } else {
                for (Attachment attachment : request.getAttachments()) {
                    if (!attachment.getName().equals(fileName)) continue;
                    part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(attachment)));
                    break;
                }
            }
            part.setHeader("Content-Type", ContentTypeHandler.getContentTypeFromFilename(file.getName()));
            part.setHeader("Content-Transfer-Encoding", "binary");
        } else {
            part.setDisposition("form-data; name=\"" + name + "\"");
            part.setText(value, System.getProperty("soapui.request.encoding", request.getEncoding()));
        }
        if (part != null) {
            formMp.addBodyPart((BodyPart)part);
        }
    }

    protected void initRootPart(HttpRequestInterface<?> wsdlRequest, String requestContent, MimeMultipart mp) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new RestRequestDataSource(wsdlRequest, requestContent));
        rootPart.setDataHandler(dataHandler);
    }
}

