/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlMimeMessageResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlSinglePartHttpResponse;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPackagingResponseFilter
extends AbstractRequestFilter {
    @Override
    public void afterAbstractHttpResponse(SubmitContext context, AbstractHttpRequestInterface<?> request) {
        ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)context.getProperty("httpMethod");
        String requestContent = (String)context.getProperty("requestContent");
        Header responseContentTypeHeader = httpMethod.getResponseHeader("Content-Type");
        Response response = null;
        if (request instanceof WsdlRequest) {
            response = this.wsdlRequest(context, (WsdlRequest)request, httpMethod, responseContentTypeHeader, requestContent);
        } else if (request instanceof HttpRequestInterface) {
            response = this.httpRequest(context, (HttpRequestInterface)request, httpMethod, responseContentTypeHeader, requestContent);
        }
        context.setProperty("httpResponse", response);
    }

    private Response wsdlRequest(SubmitContext context, WsdlRequest request, ExtendedHttpMethod httpMethod, Header responseContentTypeHeader, String requestContent) {
        XmlBeansSettingsImpl settings;
        if (context.hasProperty("PreWssProcessedDocument")) {
            requestContent = String.valueOf(context.getProperty("PreWssProcessedDocument"));
        }
        if (!(settings = request.getSettings()).getBoolean(WsdlRequest.INLINE_RESPONSE_ATTACHMENTS) && responseContentTypeHeader != null && responseContentTypeHeader.getValue().toUpperCase().startsWith("MULTIPART")) {
            return new WsdlMimeMessageResponse(request, httpMethod, requestContent, (PropertyExpansionContext)context);
        }
        return new WsdlSinglePartHttpResponse(request, httpMethod, requestContent, (PropertyExpansionContext)context);
    }

    private Response httpRequest(SubmitContext context, HttpRequestInterface<?> request, ExtendedHttpMethod httpMethod, Header responseContentTypeHeader, String requestContent) {
        if (responseContentTypeHeader != null && responseContentTypeHeader.getValue().toUpperCase().startsWith("MULTIPART")) {
            return new MimeMessageResponse(request, httpMethod, requestContent, context);
        }
        return new SinglePartHttpResponse(request, httpMethod, requestContent, context);
    }
}

