/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.AbstractWsdlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestRequestDesktopPanel
extends AbstractWsdlRequestDesktopPanel<WsdlTestRequestStep, WsdlTestRequest> {
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JButton addAssertionButton;
    protected boolean updatingRequest;
    private AssertionsPanel assertionsPanel;
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<?> assertionInspector;
    private JComponentInspector<?> logInspector;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private long startTime;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public WsdlTestRequestDesktopPanel(WsdlTestRequestStep requestStep) {
        super(requestStep, requestStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(requestStep.getTestCase()));
        requestStep.getTestRequest().addAssertionsListener(this.assertionsListener);
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            public void dataChanged(ListModel model) {
                WsdlTestRequestDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AssertionsPanel((Assertable)this.getRequest()){

            protected void selectError(AssertionError error) {
                ModelItemXmlEditor<?, ?> editor = WsdlTestRequestDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/functional/testrequests.html#The_TestRequest_Editor";
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.inspectorPanel = JInspectorPanelFactory.build(component);
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((WsdlTestRequestStep)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Test Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        return this.inspectorPanel.getComponent();
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((WsdlTestRequestStep)this.getModelItem()).getTestRequest().getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    @Override
    protected JComponent buildToolbar() {
        this.addAssertionButton = WsdlTestRequestDesktopPanel.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        return super.buildToolbar();
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addAssertionButton);
        super.insertButtons(toolbar);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((WsdlTestRequestStep)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((WsdlTestRequest)this.getRequest()).getTestCase())) {
            ((WsdlTestRequest)this.getRequest()).removeSubmitListener(this);
        } else {
            ((WsdlTestRequest)this.getRequest()).addSubmitListener(this);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((WsdlTestRequest)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.startTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected void logMessages(String message, String infoMessage) {
        super.logMessages(message, infoMessage);
        this.logArea.addLine(this.sdf.format(new Date(this.startTime)) + " - " + message);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        super.afterSubmit(submit, context);
        if (!this.isHasClosed()) {
            this.updateStatusIcon();
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            this.assertionsPanel.release();
            this.inspectorPanel.release();
            SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            this.logArea.release();
            ((WsdlTestRequestStep)this.getModelItem()).getTestRequest().removeAssertionsListener(this.assertionsListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation().getInterface() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation().getInterface().getProject() || modelItem == ((WsdlTestRequestStep)this.getModelItem()).getTestCase() || modelItem == ((WsdlTestRequestStep)this.getModelItem()).getTestCase().getTestSuite();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals(WsdlTestRequest.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestFinished(LoadTestRunner runner) {
            WsdlTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        public void testCaseFinished(TestCaseRunner runner) {
            WsdlTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlTestRequestDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        public void assertionAdded(TestAssertion assertion) {
            WsdlTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionRemoved(TestAssertion assertion) {
            WsdlTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            WsdlTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }
}

