/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfersTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTransfersDesktopPanel
extends ModelItemDesktopPanel<PropertyTransfersTestStep> {
    private final PropertyTransfersTestStep transferStep;
    private DefaultListModel listModel;
    private JList transferList;
    private JTextArea sourceArea;
    private JTextArea targetArea;
    private JButton copyButton;
    private JButton deleteButton;
    private JButton declareButton;
    private JComboBox sourcePropertyCombo;
    private JComboBox targetPropertyCombo;
    private JComboBox sourceStepCombo;
    private JComboBox targetStepCombo;
    private DefaultComboBoxModel sourceStepModel;
    private DefaultComboBoxModel targetStepModel;
    private TestStepPropertiesListener sourceStepPropertiesListener;
    private TestStepPropertiesListener targetStepPropertiesListener;
    private TransferPropertyChangeListener transferPropertyChangeListener = new TransferPropertyChangeListener();
    private boolean selecting;
    private InternalTestSuiteListener testSuiteListener;
    private TestRunComponentEnabler componentEnabler;
    private JCheckBox failTransferCheckBox;
    private JButton runButton;
    private JButton renameButton;
    private JCheckBox setNullCheckBox;
    private JCheckBox transferTextContentCheckBox;
    private JCheckBox ignoreEmptyCheckBox;
    private JCheckBox transferAllCheckBox;
    private JCheckBox entitizeCheckBox;
    private JCheckBox transferChildNodesCheckBox;
    private DesktopPanel resultDesktopPanel;
    private TransfersTableModel transferLogTableModel;
    private InternalTestRunListener testRunListener;
    private JComponentInspector<JComponent> logInspector;
    private JCheckBox useXQueryCheckBox;
    private JButton runAllButton;
    private JInspectorPanel inspectorPanel;
    private JXTable logTable;
    private JToggleButton disableButton;

    public PropertyTransfersDesktopPanel(PropertyTransfersTestStep testStep) {
        super(testStep);
        this.transferStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.buildUI();
        this.testSuiteListener = new InternalTestSuiteListener();
        this.transferStep.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
        this.testRunListener = new InternalTestRunListener();
        this.transferStep.getTestCase().addTestRunListener(this.testRunListener);
    }

    protected void buildUI() {
        JSplitPane splitPane = UISupport.createHorizontalSplit();
        this.listModel = new DefaultListModel();
        for (int c = 0; c < this.transferStep.getTransferCount(); ++c) {
            String name = this.transferStep.getTransferAt(c).getName();
            if (this.transferStep.getTransferAt(c).isDisabled()) {
                name = name + " (disabled)";
            }
            this.listModel.addElement(name);
        }
        this.transferList = new JList(this.listModel);
        this.transferList.setSelectionMode(0);
        this.transferList.addListSelectionListener(new TransferListSelectionListener());
        this.componentEnabler.add(this.transferList);
        JScrollPane listScrollPane = new JScrollPane(this.transferList);
        UISupport.addTitledBorder(listScrollPane, "Transfers");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)listScrollPane, "Center");
        p.add((Component)this.createPropertiesToolbar(), "North");
        splitPane.setLeftComponent(p);
        JSplitPane innerSplit = UISupport.createVerticalSplit();
        innerSplit.setBorder(null);
        this.sourceArea = new JUndoableTextArea();
        this.sourceArea.setToolTipText("XPath selection from source property");
        this.sourceArea.setEnabled(false);
        this.sourceArea.getDocument().addDocumentListener(new SourceAreaDocumentListener());
        this.componentEnabler.add(this.sourceArea);
        this.targetArea = new JUndoableTextArea();
        this.targetArea.setToolTipText("XPath target in target property");
        this.targetArea.setEnabled(false);
        this.targetArea.getDocument().addDocumentListener(new TargetAreaDocumentListener());
        this.componentEnabler.add(this.targetArea);
        JPanel sourcePanel = new JPanel(new BorderLayout());
        sourcePanel.add((Component)new JScrollPane(this.sourceArea), "Center");
        JXToolBar toolbar = this.createSourceToolbar();
        sourcePanel.add((Component)toolbar, "North");
        sourcePanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        innerSplit.setTopComponent(sourcePanel);
        JPanel targetPanel = new JPanel(new BorderLayout());
        targetPanel.add((Component)new JScrollPane(this.targetArea), "Center");
        toolbar = this.createTargetToolbar();
        targetPanel.add((Component)toolbar, "North");
        targetPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        innerSplit.setBottomComponent(targetPanel);
        innerSplit.setResizeWeight(0.5);
        innerSplit.setDividerLocation(0.5);
        JPanel panel = this.createTransferOptions();
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)innerSplit, "Center");
        innerPanel.add((Component)panel, "South");
        innerPanel.add((Component)this.createConfigToolbar(), "North");
        splitPane.setRightComponent(innerPanel);
        splitPane.setResizeWeight(0.1);
        splitPane.setDividerLocation(120);
        this.inspectorPanel = JInspectorPanelFactory.build(splitPane);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLog(), "Transfer Log (0)", "A log of performed transfers while the editor was open", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setPreferredSize(new Dimension(550, 400));
        if (this.listModel.getSize() > 0) {
            this.transferList.setSelectedIndex(0);
        } else {
            this.setSelectedTransfer(null);
        }
        this.componentEnabler.add(this.deleteButton);
        this.componentEnabler.add(this.declareButton);
        this.componentEnabler.add(this.runButton);
        this.componentEnabler.add(this.runAllButton);
        this.componentEnabler.add(this.copyButton);
        this.componentEnabler.add(this.renameButton);
        this.componentEnabler.add(this.failTransferCheckBox);
        this.componentEnabler.add(this.setNullCheckBox);
        this.componentEnabler.add(this.transferTextContentCheckBox);
        this.componentEnabler.add(this.ignoreEmptyCheckBox);
        this.componentEnabler.add(this.transferAllCheckBox);
        this.componentEnabler.add(this.useXQueryCheckBox);
        this.componentEnabler.add(this.entitizeCheckBox);
        this.componentEnabler.add(this.transferChildNodesCheckBox);
    }

    private JComponent buildLog() {
        JPanel logPanel = new JPanel(new BorderLayout());
        this.transferLogTableModel = new TransfersTableModel();
        this.logTable = new JXTable((TableModel)this.transferLogTableModel);
        this.logTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = PropertyTransfersDesktopPanel.this.logTable.getSelectedRow();
                if (row != -1) {
                    String transferName = PropertyTransfersDesktopPanel.this.transferLogTableModel.getValueAt(row, 1).toString();
                    int ix = PropertyTransfersDesktopPanel.this.listModel.indexOf(transferName);
                    if (ix != -1) {
                        PropertyTransfersDesktopPanel.this.transferList.setSelectedIndex(ix);
                    }
                }
            }
        });
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.packAll();
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.add(new ClearLogAction());
        JScrollPane scrollPane = new JScrollPane((Component)this.logTable);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), scrollPane.getBorder()));
        logPanel.add((Component)toolbar, "North");
        logPanel.add((Component)scrollPane, "Center");
        return logPanel;
    }

    protected JXToolBar createPropertiesToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddAction()));
        this.deleteButton = UISupport.createToolbarButton(new DeleteAction());
        this.deleteButton.setEnabled(false);
        toolbar.addFixed(this.deleteButton);
        this.copyButton = UISupport.createToolbarButton(new CopyAction());
        this.copyButton.setEnabled(false);
        toolbar.addFixed(this.copyButton);
        this.renameButton = UISupport.createToolbarButton(new RenameAction());
        this.renameButton.setEnabled(false);
        toolbar.addFixed(this.renameButton);
        this.disableButton = new JToggleButton(new DisableAction());
        this.disableButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.disableButton.setSelectedIcon(UISupport.createImageIcon("/bullet_red.png"));
        toolbar.addSeparator();
        toolbar.addFixed(this.disableButton);
        return toolbar;
    }

    protected JXToolBar createConfigToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.runButton = UISupport.createToolbarButton(new RunAction());
        this.runButton.setEnabled(this.transferList.getSelectedIndex() != -1);
        toolbar.addFixed(this.runButton);
        this.runAllButton = UISupport.createToolbarButton(new RunAllAction());
        this.runAllButton.setEnabled(this.transferStep.getTransferCount() > 0);
        toolbar.addFixed(this.runAllButton);
        this.declareButton = UISupport.createToolbarButton(new DeclareNamespacesAction());
        this.declareButton.setEnabled(false);
        toolbar.addFixed(this.declareButton);
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertytransfers.html#The_PropertyTransfer_Editor")));
        return toolbar;
    }

    protected JPanel createTransferOptions() {
        JPanel panel = new JPanel(new GridLayout(4, 2));
        this.failTransferCheckBox = new JCheckBox("Fail transfer on error", false);
        this.failTransferCheckBox.setToolTipText("Fails the Property Transfer Step if an error occurs");
        this.failTransferCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setFailOnError(PropertyTransfersDesktopPanel.this.failTransferCheckBox.isSelected());
                }
            }
        });
        this.setNullCheckBox = new JCheckBox("Set null on missing source", false);
        this.setNullCheckBox.setToolTipText("Will set target to null if source is missing or null");
        this.setNullCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setSetNullOnMissingSource(PropertyTransfersDesktopPanel.this.setNullCheckBox.isSelected());
                }
            }
        });
        this.transferTextContentCheckBox = new JCheckBox("Transfer text content", false);
        this.transferTextContentCheckBox.setToolTipText("Will only transfer text content of source/target elements");
        this.transferTextContentCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setTransferTextContent(PropertyTransfersDesktopPanel.this.transferTextContentCheckBox.isSelected());
                }
            }
        });
        this.ignoreEmptyCheckBox = new JCheckBox("Ignore empty/missing values", false);
        this.ignoreEmptyCheckBox.setToolTipText("Will not transfer empty or missing values");
        this.ignoreEmptyCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setIgnoreEmpty(PropertyTransfersDesktopPanel.this.ignoreEmptyCheckBox.isSelected());
                }
            }
        });
        this.transferAllCheckBox = new JCheckBox("Transfer to all", false);
        this.transferAllCheckBox.setToolTipText("Will transfer to all matching target selections");
        this.transferAllCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setTransferToAll(PropertyTransfersDesktopPanel.this.transferAllCheckBox.isSelected());
                }
            }
        });
        this.useXQueryCheckBox = new JCheckBox("Use XQuery", false);
        this.useXQueryCheckBox.setToolTipText("Interprets the source xpath as an XQuery expression");
        this.useXQueryCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setUseXQuery(PropertyTransfersDesktopPanel.this.useXQueryCheckBox.isSelected());
                }
            }
        });
        this.entitizeCheckBox = new JCheckBox("Entitize transferred value(s)", false);
        this.entitizeCheckBox.setToolTipText("Entitize transferred values when possible");
        this.entitizeCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setEntitize(PropertyTransfersDesktopPanel.this.entitizeCheckBox.isSelected());
                }
            }
        });
        this.transferChildNodesCheckBox = new JCheckBox("Transfer Child Nodes", false);
        this.transferChildNodesCheckBox.setToolTipText("Transfers child nodes of specified source node to children of specified target");
        this.transferChildNodesCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setTransferChildNodes(PropertyTransfersDesktopPanel.this.transferChildNodesCheckBox.isSelected());
                }
            }
        });
        panel.add(this.failTransferCheckBox);
        panel.add(this.setNullCheckBox);
        panel.add(this.transferTextContentCheckBox);
        panel.add(this.ignoreEmptyCheckBox);
        panel.add(this.transferAllCheckBox);
        panel.add(this.useXQueryCheckBox);
        panel.add(this.entitizeCheckBox);
        panel.add(this.transferChildNodesCheckBox);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return panel;
    }

    protected JXToolBar createTargetToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(new JLabel("<html><b>Target:</b></html>"));
        toolbar.addUnrelatedGap();
        this.targetStepCombo.setSelectedItem(null);
        this.targetStepCombo.setToolTipText("The step the value will be transferred to");
        this.targetStepCombo.setEnabled(false);
        this.targetStepCombo.addItemListener(new StepComboItemListener(this.targetPropertyCombo, this.targetStepPropertiesListener));
        this.targetStepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !PropertyTransfersDesktopPanel.this.selecting) {
                    TestPropertyHolder targetStep = (TestPropertyHolder)PropertyTransfersDesktopPanel.this.targetStepCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        String name = "";
                        name = targetStep == PropertyExpansionUtils.getGlobalProperties() ? "#Global#" : (targetStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase().getTestSuite().getProject() ? "#Project#" : (targetStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase().getTestSuite() ? "#TestSuite#" : (targetStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase() ? "#TestCase#" : targetStep.getModelItem().getName())));
                        valueTransfer.setTargetStepName(name);
                    }
                }
            }
        });
        toolbar.add(UISupport.setFixedSize(this.targetStepCombo, 200, 21));
        toolbar.addUnrelatedGap();
        toolbar.addFixed(new JLabel("Property:"));
        toolbar.addRelatedGap();
        this.targetPropertyCombo.setToolTipText("The property the value will be transferred to");
        this.targetPropertyCombo.setEnabled(false);
        this.targetPropertyCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !PropertyTransfersDesktopPanel.this.selecting) {
                    TestProperty targetProperty = (TestProperty)PropertyTransfersDesktopPanel.this.targetPropertyCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setTargetPropertyName(targetProperty.getName());
                    }
                }
            }
        });
        toolbar.add(UISupport.setFixedSize(this.targetPropertyCombo, 200, 21));
        toolbar.addGlue();
        return toolbar;
    }

    protected JXToolBar createSourceToolbar() {
        int c;
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(new JLabel("<html><b>Source:</b></html>"));
        toolbar.addUnrelatedGap();
        this.sourcePropertyCombo = UISupport.addTooltipListener(new JComboBox(), "Source Property");
        this.sourceStepModel = new DefaultComboBoxModel();
        this.sourceStepCombo = UISupport.addTooltipListener(new JComboBox(this.sourceStepModel), "Source Step or Property Container");
        this.sourceStepCombo.setRenderer(new StepComboRenderer());
        this.sourcePropertyCombo.setRenderer(new PropertyComboRenderer());
        this.componentEnabler.add(this.sourcePropertyCombo);
        this.componentEnabler.add(this.sourceStepCombo);
        this.targetPropertyCombo = UISupport.addTooltipListener(new JComboBox(), "Target Property");
        this.targetStepModel = new DefaultComboBoxModel();
        this.targetStepCombo = UISupport.addTooltipListener(new JComboBox(this.targetStepModel), "Target Step or Property Container");
        this.targetStepCombo.setRenderer(new StepComboRenderer());
        this.targetPropertyCombo.setRenderer(new PropertyComboRenderer());
        this.componentEnabler.add(this.targetPropertyCombo);
        this.componentEnabler.add(this.targetStepCombo);
        this.sourceStepPropertiesListener = new TestStepPropertiesListener(this.sourcePropertyCombo);
        this.targetStepPropertiesListener = new TestStepPropertiesListener(this.targetPropertyCombo);
        this.sourceStepModel.addElement(PropertyExpansionUtils.getGlobalProperties());
        this.sourceStepModel.addElement(this.transferStep.getTestCase().getTestSuite().getProject());
        this.sourceStepModel.addElement(this.transferStep.getTestCase().getTestSuite());
        this.sourceStepModel.addElement(this.transferStep.getTestCase());
        for (c = 0; c < this.transferStep.getTestCase().getTestStepCount(); ++c) {
            WsdlTestStep testStep = this.transferStep.getTestCase().getTestStepAt(c);
            if (testStep == this.transferStep) continue;
            this.sourceStepModel.addElement(testStep);
        }
        for (c = 0; c < this.sourceStepModel.getSize(); ++c) {
            this.targetStepModel.addElement(this.sourceStepModel.getElementAt(c));
        }
        this.sourceStepCombo.setSelectedItem(null);
        this.sourceStepCombo.setEnabled(false);
        this.sourceStepCombo.addItemListener(new StepComboItemListener(this.sourcePropertyCombo, this.sourceStepPropertiesListener));
        this.sourceStepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !PropertyTransfersDesktopPanel.this.selecting) {
                    TestPropertyHolder sourceStep = (TestPropertyHolder)PropertyTransfersDesktopPanel.this.sourceStepCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        String name = "";
                        name = sourceStep == PropertyExpansionUtils.getGlobalProperties() ? "#Global#" : (sourceStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase().getTestSuite().getProject() ? "#Project#" : (sourceStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase().getTestSuite() ? "#TestSuite#" : (sourceStep == PropertyTransfersDesktopPanel.this.transferStep.getTestCase() ? "#TestCase#" : sourceStep.getModelItem().getName())));
                        valueTransfer.setSourceStepName(name);
                    }
                }
            }
        });
        toolbar.add(UISupport.setFixedSize(this.sourceStepCombo, 200, 21));
        toolbar.addUnrelatedGap();
        toolbar.addFixed(new JLabel("Property:"));
        toolbar.addRelatedGap();
        this.sourcePropertyCombo.setToolTipText("The property the value will be transferred from");
        this.sourcePropertyCombo.setEnabled(false);
        this.sourcePropertyCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !PropertyTransfersDesktopPanel.this.selecting) {
                    TestProperty sourceProperty = (TestProperty)PropertyTransfersDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setSourcePropertyName(sourceProperty.getName());
                    }
                }
            }
        });
        toolbar.add(UISupport.setFixedSize(this.sourcePropertyCombo, 200, 21));
        toolbar.addGlue();
        return toolbar;
    }

    public PropertyTransfer getCurrentTransfer() {
        int ix = this.transferList.getSelectedIndex();
        return ix == -1 ? null : this.transferStep.getTransferAt(ix);
    }

    private void setSelectedTransfer(PropertyTransfer transfer) {
        if (transfer == null) {
            this.sourceArea.setText("");
            this.targetArea.setText("");
            this.sourcePropertyCombo.removeAllItems();
            this.targetPropertyCombo.removeAllItems();
            this.sourceStepCombo.setSelectedIndex(-1);
            this.targetStepCombo.setSelectedIndex(-1);
        } else {
            transfer.addPropertyChangeListener(this.transferPropertyChangeListener);
            this.sourceArea.setText(transfer.getSourcePath());
            this.sourceArea.setCaretPosition(0);
            this.targetArea.setText(transfer.getTargetPath());
            this.targetArea.setCaretPosition(0);
            this.sourceStepCombo.setSelectedItem(transfer.getSourceStep());
            this.sourcePropertyCombo.setSelectedItem(transfer.getSourceProperty());
            this.targetStepCombo.setSelectedItem(transfer.getTargetStep());
            this.targetPropertyCombo.setSelectedItem(transfer.getTargetProperty());
            this.failTransferCheckBox.setSelected(transfer.getFailOnError());
            this.setNullCheckBox.setSelected(transfer.getSetNullOnMissingSource());
            this.transferTextContentCheckBox.setSelected(transfer.getTransferTextContent());
            this.ignoreEmptyCheckBox.setSelected(transfer.getIgnoreEmpty());
            this.transferAllCheckBox.setSelected(transfer.getTransferToAll());
            this.useXQueryCheckBox.setSelected(transfer.getUseXQuery());
            this.entitizeCheckBox.setSelected(transfer.getEntitize());
            this.transferChildNodesCheckBox.setSelected(transfer.getTransferChildNodes());
            this.disableButton.setSelected(transfer.isDisabled());
        }
        this.copyButton.setEnabled(transfer != null);
        this.renameButton.setEnabled(transfer != null);
        this.deleteButton.setEnabled(transfer != null);
        this.disableButton.setEnabled(transfer != null);
        this.declareButton.setEnabled(transfer != null);
        this.sourceStepCombo.setEnabled(transfer != null);
        this.targetStepCombo.setEnabled(transfer != null);
        this.sourceArea.setEnabled(transfer != null);
        this.targetArea.setEnabled(transfer != null);
        this.failTransferCheckBox.setEnabled(transfer != null);
        this.setNullCheckBox.setEnabled(transfer != null);
        this.transferTextContentCheckBox.setEnabled(transfer != null);
        this.ignoreEmptyCheckBox.setEnabled(transfer != null);
        this.transferAllCheckBox.setEnabled(transfer != null);
        this.useXQueryCheckBox.setEnabled(transfer != null);
        this.entitizeCheckBox.setEnabled(transfer != null);
        this.transferChildNodesCheckBox.setEnabled(transfer != null);
        this.runAllButton.setEnabled(this.transferList.getModel().getSize() > 0);
        this.runButton.setEnabled(transfer != null);
        this.sourcePropertyCombo.setEnabled(transfer != null);
        this.targetPropertyCombo.setEnabled(transfer != null);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        TestPropertyHolder item;
        super.release();
        this.transferStep.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        this.transferStep.getTestCase().removeTestRunListener(this.testRunListener);
        PropertyTransfer transfer = this.getCurrentTransfer();
        if (transfer != null) {
            transfer.removePropertyChangeListener(this.transferPropertyChangeListener);
        }
        if ((item = (TestPropertyHolder)this.sourceStepCombo.getSelectedItem()) != null) {
            item.removeTestPropertyListener(this.sourceStepPropertiesListener);
        }
        if ((item = (TestPropertyHolder)this.targetStepCombo.getSelectedItem()) != null) {
            item.removeTestPropertyListener(this.targetStepPropertiesListener);
        }
        this.componentEnabler.release();
        if (this.resultDesktopPanel != null) {
            SoapUI.getDesktop().closeDesktopPanel(this.resultDesktopPanel);
        }
        this.inspectorPanel.release();
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    protected JTextArea getSourceArea() {
        return this.sourceArea;
    }

    protected JTextArea getTargetArea() {
        return this.targetArea;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.transferStep || modelItem == this.transferStep.getTestCase() || modelItem == this.transferStep.getTestCase().getTestSuite() || modelItem == this.transferStep.getTestCase().getTestSuite().getProject();
    }

    public boolean selectTransfer(PropertyTransfer transfer) {
        for (int c = 0; c < this.transferStep.getTransferCount(); ++c) {
            if (this.transferStep.getTransferAt(c) != transfer) continue;
            this.transferList.setSelectedIndex(c);
            return true;
        }
        return false;
    }

    private class PropertyComboRenderer
    extends DefaultListCellRenderer {
        private PropertyComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                TestProperty item = (TestProperty)value;
                this.setText(item.getName());
            }
            this.setToolTipText(this.getText());
            return result;
        }
    }

    private class StepComboRenderer
    extends DefaultListCellRenderer {
        private StepComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestModelItem) {
                TestModelItem item = (TestModelItem)value;
                this.setIcon(item.getIcon());
                this.setText(item.getName());
            } else if (value == PropertyExpansionUtils.getGlobalProperties()) {
                this.setText("Global");
            }
            this.setToolTipText(this.getText());
            return result;
        }
    }

    private class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            if (result.getTestStep() == PropertyTransfersDesktopPanel.this.transferStep) {
                PropertyTransfersDesktopPanel.this.transferLogTableModel.addResult((PropertyTransfersTestStep.PropertyTransferResult)result);
            }
        }
    }

    private class TransfersTableModel
    extends AbstractTableModel {
        private List<PropertyTransfersTestStep.PropertyTransferResult> results = new ArrayList<PropertyTransfersTestStep.PropertyTransferResult>();

        private TransfersTableModel() {
        }

        public synchronized int getRowCount() {
            int sum = 0;
            for (PropertyTransfersTestStep.PropertyTransferResult result : this.results) {
                sum += result.getTransferCount();
            }
            return sum;
        }

        public synchronized void clear() {
            this.results.clear();
            this.fireTableDataChanged();
            PropertyTransfersDesktopPanel.this.logInspector.setTitle("Transfer Log (0)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResult(PropertyTransfersTestStep.PropertyTransferResult result) {
            int rowCount;
            TransfersTableModel transfersTableModel = this;
            synchronized (transfersTableModel) {
                rowCount = this.getRowCount();
                this.results.add(result);
            }
            this.fireTableRowsInserted(rowCount, rowCount + result.getTransferCount());
            PropertyTransfersDesktopPanel.this.logInspector.setTitle("Transfer Log (" + this.getRowCount() + ")");
            PropertyTransfersDesktopPanel.this.inspectorPanel.activate(PropertyTransfersDesktopPanel.this.logInspector);
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Timestamp";
                }
                case 1: {
                    return "Transfer Name";
                }
                case 2: {
                    return "Transferred Values";
                }
            }
            return null;
        }

        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            WsdlTestStepResult result = null;
            int sum = 0;
            for (int c = 0; c < this.results.size(); ++c) {
                if (sum + this.results.get(c).getTransferCount() > rowIndex) {
                    result = this.results.get(c);
                    break;
                }
                sum += this.results.get(c).getTransferCount();
            }
            if (result != null) {
                switch (columnIndex) {
                    case 0: {
                        return new Date(result.getTimeStamp()).toString();
                    }
                    case 1: {
                        return ((PropertyTransfersTestStep.PropertyTransferResult)result).getTransferAt(rowIndex - sum).getName();
                    }
                    case 2: {
                        return Arrays.toString(((PropertyTransfersTestStep.PropertyTransferResult)result).getTransferredValuesAt(rowIndex - sum));
                    }
                }
            }
            return null;
        }
    }

    private final class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.gif"));
            this.putValue("ShortDescription", "Runs selected PropertyTransfer");
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex() == -1) {
                UISupport.showErrorMessage("No transfer selectd!");
                return;
            }
            MockTestRunner mockRunner = new MockTestRunner(PropertyTransfersDesktopPanel.this.transferStep.getTestCase());
            MockTestRunContext context = new MockTestRunContext(mockRunner, PropertyTransfersDesktopPanel.this.transferStep);
            PropertyTransfersTestStep.PropertyTransferResult result = (PropertyTransfersTestStep.PropertyTransferResult)PropertyTransfersDesktopPanel.this.transferStep.run(mockRunner, context, PropertyTransfersDesktopPanel.this.getCurrentTransfer());
            PropertyTransfersDesktopPanel.this.transferLogTableModel.addResult(result);
        }
    }

    private final class RunAllAction
    extends AbstractAction {
        public RunAllAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_all.gif"));
            this.putValue("ShortDescription", "Runs all Property Transfers");
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertyTransfersDesktopPanel.this.listModel.getSize() == 0) {
                UISupport.showErrorMessage("Missing transfers!");
                return;
            }
            MockTestRunner mockRunner = new MockTestRunner(PropertyTransfersDesktopPanel.this.transferStep.getTestCase());
            MockTestRunContext context = new MockTestRunContext(mockRunner, PropertyTransfersDesktopPanel.this.transferStep);
            for (int c = 0; c < PropertyTransfersDesktopPanel.this.transferStep.getTransferCount(); ++c) {
                PropertyTransfer transfer = PropertyTransfersDesktopPanel.this.transferStep.getTransferAt(c);
                PropertyTransfersTestStep.PropertyTransferResult result = (PropertyTransfersTestStep.PropertyTransferResult)PropertyTransfersDesktopPanel.this.transferStep.run(mockRunner, context, transfer);
                PropertyTransfersDesktopPanel.this.transferLogTableModel.addResult(result);
            }
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/declareNs.gif"));
            this.putValue("ShortDescription", "Declare available response/request namespaces in source/target expressions");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TestPropertyHolder previousStep = PropertyTransfersDesktopPanel.this.getCurrentTransfer().getSourceStep();
                if (previousStep instanceof WsdlTestRequestStep) {
                    WsdlTestRequest testRequest = ((WsdlTestRequestStep)previousStep).getTestRequest();
                    PropertyTransfersDesktopPanel.this.sourceArea.setText(XmlUtils.declareXPathNamespaces(testRequest.getOperation().getInterface()) + PropertyTransfersDesktopPanel.this.sourceArea.getText());
                } else {
                    UISupport.showErrorMessage("Property Source is not a Request");
                }
                TestPropertyHolder nextStep = PropertyTransfersDesktopPanel.this.getCurrentTransfer().getTargetStep();
                if (nextStep instanceof WsdlTestRequestStep) {
                    WsdlTestRequest testRequest = ((WsdlTestRequestStep)nextStep).getTestRequest();
                    PropertyTransfersDesktopPanel.this.targetArea.setText(XmlUtils.declareXPathNamespaces(testRequest.getOperation().getInterface()) + PropertyTransfersDesktopPanel.this.targetArea.getText());
                } else {
                    UISupport.showErrorMessage("Property Target is not a Request");
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private final class DisableAction
    extends AbstractAction {
        public DisableAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/bullet_green.png"));
            this.putValue("ShortDescription", "Disables the selected Property Transfer");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyTransfer transfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
            transfer.setDisabled(PropertyTransfersDesktopPanel.this.disableButton.isSelected());
            String name = transfer.getName();
            if (transfer.isDisabled()) {
                name = name + " (disabled)";
            }
            PropertyTransfersDesktopPanel.this.listModel.setElementAt(name, PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex());
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/rename.gif"));
            this.putValue("ShortDescription", "Renames the selected Property Transfer");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyTransfer transfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
            String newName = UISupport.prompt("Specify new name for transfer", "Rename Transfer", transfer.getName());
            if (newName != null && !transfer.getName().equals(newName)) {
                PropertyTransfersDesktopPanel.this.listModel.setElementAt(newName, PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex());
                transfer.setName(newName);
            }
        }
    }

    private final class ClearLogAction
    extends AbstractAction {
        public ClearLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_properties.gif"));
            this.putValue("ShortDescription", "Clears the property-transfer log");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyTransfersDesktopPanel.this.transferLogTableModel.clear();
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Deletes the selected Property Transfer");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Delete selected transfer", "Delete Transfer")) {
                PropertyTransfersDesktopPanel.this.transferList.setSelectedIndex(-1);
                int ix = PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex();
                PropertyTransfersDesktopPanel.this.transferStep.removeTransferAt(ix);
                PropertyTransfersDesktopPanel.this.listModel.remove(ix);
                if (PropertyTransfersDesktopPanel.this.listModel.getSize() > 0) {
                    PropertyTransfersDesktopPanel.this.transferList.setSelectedIndex(ix > PropertyTransfersDesktopPanel.this.listModel.getSize() - 1 ? PropertyTransfersDesktopPanel.this.listModel.getSize() - 1 : ix);
                }
            }
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("ShortDescription", "Copies the selected Property Transfer");
            this.putValue("SmallIcon", UISupport.createImageIcon("/clone_request.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            int ix = PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex();
            PropertyTransfer config = PropertyTransfersDesktopPanel.this.transferStep.getTransferAt(ix);
            String name = UISupport.prompt("Specify name for value transfer", "Copy Transfer", config.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            PropertyTransfer transfer = PropertyTransfersDesktopPanel.this.transferStep.addTransfer(name);
            transfer.setSourceStepName(config.getSourceStepName());
            transfer.setSourcePropertyName(config.getSourcePropertyName());
            transfer.setSourcePath(config.getSourcePath());
            transfer.setTargetStepName(config.getTargetStepName());
            transfer.setTargetPropertyName(config.getTargetPropertyName());
            transfer.setTargetPath(config.getTargetPath());
            transfer.setDisabled(config.isDisabled());
            transfer.setEntitize(config.getEntitize());
            transfer.setFailOnError(config.getFailOnError());
            transfer.setIgnoreEmpty(config.getIgnoreEmpty());
            transfer.setSetNullOnMissingSource(config.getSetNullOnMissingSource());
            transfer.setTransferChildNodes(config.getTransferChildNodes());
            transfer.setTransferTextContent(config.getTransferTextContent());
            transfer.setTransferToAll(config.getTransferToAll());
            transfer.setUseXQuery(config.getUseXQuery());
            PropertyTransfersDesktopPanel.this.listModel.addElement(name);
            PropertyTransfersDesktopPanel.this.transferList.setSelectedIndex(PropertyTransfersDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("ShortDescription", "Adds a new Property Transfer");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for value transfer", "Add Transfer", "");
            if (name == null || name.trim().length() == 0) {
                return;
            }
            PropertyTransfersDesktopPanel.this.transferStep.addTransfer(name);
            PropertyTransfersDesktopPanel.this.listModel.addElement(name);
            PropertyTransfersDesktopPanel.this.transferList.setSelectedIndex(PropertyTransfersDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private class TransferPropertyChangeListener
    implements PropertyChangeListener {
        private TransferPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object selectedItem;
            Object newValue = evt.getNewValue();
            if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_PATH_PROPERTY)) {
                if (!PropertyTransfersDesktopPanel.this.sourceArea.getText().equals(newValue)) {
                    PropertyTransfersDesktopPanel.this.sourceArea.setText((String)newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_PATH_PROPERTY)) {
                if (!PropertyTransfersDesktopPanel.this.targetArea.getText().equals(newValue)) {
                    PropertyTransfersDesktopPanel.this.targetArea.setText((String)newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_STEP_PROPERTY)) {
                Object selectedItem2 = PropertyTransfersDesktopPanel.this.sourceStepCombo.getSelectedItem();
                if (newValue == null || selectedItem2 == null || !selectedItem2.equals(newValue)) {
                    PropertyTransfersDesktopPanel.this.selecting = true;
                    PropertyTransfersDesktopPanel.this.sourceStepCombo.setSelectedItem(newValue);
                    PropertyTransfersDesktopPanel.this.selecting = false;
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_STEP_PROPERTY)) {
                Object selectedItem3 = PropertyTransfersDesktopPanel.this.targetStepCombo.getSelectedItem();
                if (newValue == null || selectedItem3 == null || !selectedItem3.equals(newValue)) {
                    PropertyTransfersDesktopPanel.this.selecting = true;
                    PropertyTransfersDesktopPanel.this.targetStepCombo.setSelectedItem(newValue);
                    PropertyTransfersDesktopPanel.this.selecting = false;
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_TYPE_PROPERTY)) {
                Object selectedItem4 = PropertyTransfersDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                if (selectedItem4 == null || !selectedItem4.equals(newValue)) {
                    PropertyTransfersDesktopPanel.this.sourcePropertyCombo.setSelectedItem(newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_TYPE_PROPERTY) && ((selectedItem = PropertyTransfersDesktopPanel.this.targetPropertyCombo.getSelectedItem()) == null || !selectedItem.equals(newValue))) {
                PropertyTransfersDesktopPanel.this.targetPropertyCombo.setSelectedItem(newValue);
            }
        }
    }

    private final class TransferListSelectionListener
    implements ListSelectionListener {
        private PropertyTransfer transfer;

        private TransferListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            PropertyTransfersDesktopPanel.this.selecting = true;
            if (this.transfer != null) {
                this.transfer.removePropertyChangeListener(PropertyTransfersDesktopPanel.this.transferPropertyChangeListener);
            }
            this.transfer = PropertyTransfersDesktopPanel.this.getCurrentTransfer();
            PropertyTransfersDesktopPanel.this.setSelectedTransfer(this.transfer);
            PropertyTransfersDesktopPanel.this.selecting = false;
        }
    }

    private final class TargetAreaDocumentListener
    extends DocumentListenerAdapter {
        private TargetAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex();
            if (ix != -1) {
                PropertyTransfersDesktopPanel.this.transferStep.getTransferAt(ix).setTargetPath(PropertyTransfersDesktopPanel.this.targetArea.getText());
            }
        }
    }

    private final class SourceAreaDocumentListener
    extends DocumentListenerAdapter {
        private SourceAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = PropertyTransfersDesktopPanel.this.transferList.getSelectedIndex();
            if (ix != -1) {
                PropertyTransfersDesktopPanel.this.transferStep.getTransferAt(ix).setSourcePath(PropertyTransfersDesktopPanel.this.sourceArea.getText());
            }
        }
    }

    private final class StepComboItemListener
    implements ItemListener {
        private final JComboBox propertyCombo;
        private final TestStepPropertiesListener testStepPropertiesListener;

        public StepComboItemListener(JComboBox propertyCombo, TestStepPropertiesListener testStepPropertiesListener) {
            this.propertyCombo = propertyCombo;
            this.testStepPropertiesListener = testStepPropertiesListener;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                TestPropertyHolder selectedItem = (TestPropertyHolder)e.getItem();
                String[] propertyNames = selectedItem.getPropertyNames();
                if (this.propertyCombo == PropertyTransfersDesktopPanel.this.targetPropertyCombo) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (String name : propertyNames) {
                        TestProperty property = selectedItem.getProperty(name);
                        if (property == null || property.isReadOnly()) continue;
                        names.add(property.getName());
                    }
                    propertyNames = names.toArray(new String[names.size()]);
                }
                DefaultComboBoxModel<TestProperty> model = new DefaultComboBoxModel<TestProperty>();
                for (String name : propertyNames) {
                    model.addElement(selectedItem.getProperty(name));
                }
                this.propertyCombo.setModel(model);
                this.propertyCombo.setEnabled(propertyNames.length > 0);
                if (this.propertyCombo == PropertyTransfersDesktopPanel.this.targetPropertyCombo) {
                    this.propertyCombo.setSelectedItem(PropertyTransfersDesktopPanel.this.getCurrentTransfer().getTargetProperty());
                } else {
                    this.propertyCombo.setSelectedItem(PropertyTransfersDesktopPanel.this.getCurrentTransfer().getSourceProperty());
                }
                selectedItem.addTestPropertyListener(this.testStepPropertiesListener);
            } else {
                this.propertyCombo.removeAllItems();
                this.propertyCombo.setEnabled(false);
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == PropertyTransfersDesktopPanel.this.transferStep.getTestCase()) {
                PropertyTransfersDesktopPanel.this.sourceStepModel.addElement(testStep);
                PropertyTransfersDesktopPanel.this.targetStepModel.addElement(testStep);
            }
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            if (testStep.getTestCase() == PropertyTransfersDesktopPanel.this.transferStep.getTestCase()) {
                String testStepName = testStep.getName();
                if (PropertyTransfersDesktopPanel.this.sourceStepModel.getIndexOf(testStepName) == fromIndex) {
                    String sourceStep = (String)PropertyTransfersDesktopPanel.this.sourceStepCombo.getSelectedItem();
                    String sourceProperty = (String)PropertyTransfersDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                    PropertyTransfersDesktopPanel.this.sourceStepModel.removeElementAt(fromIndex);
                    if (fromIndex + offset > PropertyTransfersDesktopPanel.this.sourceStepModel.getSize()) {
                        PropertyTransfersDesktopPanel.this.sourceStepModel.addElement(testStepName);
                    } else {
                        PropertyTransfersDesktopPanel.this.sourceStepModel.insertElementAt(testStepName, fromIndex + offset);
                    }
                    PropertyTransfersDesktopPanel.this.sourceStepCombo.setSelectedItem(sourceStep);
                    PropertyTransfersDesktopPanel.this.sourcePropertyCombo.setSelectedItem(sourceProperty);
                }
                if (PropertyTransfersDesktopPanel.this.targetStepModel.getIndexOf(testStepName) == fromIndex) {
                    String targetStep = (String)PropertyTransfersDesktopPanel.this.targetStepCombo.getSelectedItem();
                    String targetProperty = (String)PropertyTransfersDesktopPanel.this.targetPropertyCombo.getSelectedItem();
                    PropertyTransfersDesktopPanel.this.targetStepModel.removeElementAt(fromIndex);
                    if (fromIndex + offset > PropertyTransfersDesktopPanel.this.targetStepModel.getSize()) {
                        PropertyTransfersDesktopPanel.this.targetStepModel.addElement(testStepName);
                    } else {
                        PropertyTransfersDesktopPanel.this.targetStepModel.insertElementAt(testStepName, fromIndex + offset);
                    }
                    PropertyTransfersDesktopPanel.this.targetStepCombo.setSelectedItem(targetStep);
                    PropertyTransfersDesktopPanel.this.targetPropertyCombo.setSelectedItem(targetProperty);
                }
            }
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == PropertyTransfersDesktopPanel.this.transferStep.getTestCase()) {
                PropertyTransfersDesktopPanel.this.sourceStepModel.removeElement(testStep);
                PropertyTransfersDesktopPanel.this.targetStepModel.removeElement(testStep);
            }
        }
    }

    private final class TestStepPropertiesListener
    implements TestPropertyListener {
        private final JComboBox combo;

        public TestStepPropertiesListener(JComboBox combo) {
            this.combo = combo;
        }

        public void propertyAdded(String name) {
            TestProperty property = this.combo == PropertyTransfersDesktopPanel.this.targetPropertyCombo ? PropertyTransfersDesktopPanel.this.getCurrentTransfer().getTargetStep().getProperty(name) : PropertyTransfersDesktopPanel.this.getCurrentTransfer().getSourceStep().getProperty(name);
            this.combo.addItem(property);
            this.combo.setEnabled(true);
        }

        public void propertyRemoved(String name) {
            if (this.combo.getSelectedItem() != null && ((TestProperty)this.combo.getSelectedItem()).getName().equals(name)) {
                this.combo.setSelectedItem(null);
            }
            for (int c = 0; c < this.combo.getItemCount(); ++c) {
                if (!((TestProperty)this.combo.getItemAt(c)).getName().equals(name)) continue;
                this.combo.removeItemAt(c);
                break;
            }
            this.combo.setEnabled(this.combo.getItemCount() > 0);
        }

        public void propertyRenamed(String oldName, String newName) {
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
        }

        public void propertyMoved(String name, int oldIndex, int newIndex) {
            this.combo.removeItemAt(oldIndex);
            TestProperty property = this.combo == PropertyTransfersDesktopPanel.this.targetPropertyCombo ? PropertyTransfersDesktopPanel.this.getCurrentTransfer().getTargetStep().getProperty(name) : PropertyTransfersDesktopPanel.this.getCurrentTransfer().getSourceStep().getProperty(name);
            this.combo.insertItemAt(property, newIndex);
        }
    }
}

