/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.CaptureInputStream;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.mortbay.util.IO;

public class ProxyServlet
implements Servlet {
    protected ServletConfig config;
    protected ServletContext context;
    protected SoapMonitor monitor;
    protected WsdlProject project;
    protected HttpState httpState = new HttpState();
    protected Settings settings;
    static HashSet<String> dontProxyHeaders = new HashSet();

    public ProxyServlet(SoapMonitor soapMonitor) {
        dontProxyHeaders.add("proxy-connection");
        dontProxyHeaders.add("connection");
        dontProxyHeaders.add("keep-alive");
        dontProxyHeaders.add("transfer-encoding");
        dontProxyHeaders.add("te");
        dontProxyHeaders.add("trailer");
        dontProxyHeaders.add("proxy-authorization");
        dontProxyHeaders.add("proxy-authenticate");
        dontProxyHeaders.add("upgrade");
        this.monitor = soapMonitor;
        this.project = this.monitor.getProject();
        this.settings = this.project.getSettings();
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "SoapUI Monitor";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.monitor.fireOnRequest(request, response);
        if (response.isCommitted()) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExtendedHttpMethod method = httpRequest.getMethod().equals("GET") ? new ExtendedGetMethod() : new ExtendedPostMethod();
        JProxyServletWsdlMonitorMessageExchange capturedData = new JProxyServletWsdlMonitorMessageExchange(this.project);
        capturedData.setRequestHost(httpRequest.getServerName());
        capturedData.setRequestHeader(httpRequest);
        capturedData.setTargetURL(httpRequest.getRequestURL().toString());
        CaptureInputStream capture = new CaptureInputStream((InputStream)httpRequest.getInputStream());
        String connectionHeader = httpRequest.getHeader("Connection");
        if (connectionHeader != null && (connectionHeader = connectionHeader.toLowerCase()).indexOf("keep-alive") < 0 && connectionHeader.indexOf("close") < 0) {
            connectionHeader = null;
        }
        boolean xForwardedFor = false;
        long contentLength = -1L;
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hdr = (String)headerNames.nextElement();
            String lhdr = hdr.toLowerCase();
            if (dontProxyHeaders.contains(lhdr) || connectionHeader != null && connectionHeader.indexOf(lhdr) >= 0) continue;
            if ("content-length".equals(lhdr)) {
                contentLength = request.getContentLength();
            }
            Enumeration vals = httpRequest.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null) continue;
                method.setRequestHeader(lhdr, val);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
            }
        }
        method.setRequestHeader("Via", "SoapUI Monitor");
        if (!xForwardedFor) {
            method.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
        }
        if (method instanceof ExtendedPostMethod) {
            ((ExtendedPostMethod)method).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)capture, request.getContentType()));
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        StringBuffer url = new StringBuffer("http://");
        url.append(httpRequest.getServerName());
        if (httpRequest.getServerPort() != 80) {
            url.append(":" + httpRequest.getServerPort());
        }
        if (httpRequest.getServletPath() != null) {
            url.append(httpRequest.getServletPath());
            method.setPath(httpRequest.getServletPath());
            if (httpRequest.getQueryString() != null) {
                url.append("?" + httpRequest.getQueryString());
                method.setPath(httpRequest.getServletPath() + "?" + httpRequest.getQueryString());
            }
        }
        hostConfiguration.setHost(new URI(url.toString(), true));
        this.monitor.fireBeforeProxy(request, response, method, hostConfiguration);
        if (this.settings.getBoolean("Reuse request state")) {
            if (this.httpState == null) {
                this.httpState = new HttpState();
            }
            HttpClientSupport.getHttpClient().executeMethod(hostConfiguration, (HttpMethod)method, this.httpState);
        } else {
            HttpClientSupport.getHttpClient().executeMethod(hostConfiguration, (HttpMethod)method);
        }
        capturedData.stopCapture();
        capturedData.setRequest(capture.getCapturedData());
        capturedData.setRawResponseBody(method.getResponseBody());
        capturedData.setResponseHeader((HttpMethodBase)method);
        capturedData.setRawRequestData(this.getRequestToBytes(request.toString(), (HttpMethodBase)method, capture));
        capturedData.setRawResponseData(this.getResponseToBytes(response.toString(), (HttpMethodBase)method, capturedData.getRawResponseBody()));
        this.monitor.fireAfterProxy(request, response, method, capturedData);
        if (!response.isCommitted()) {
            StringToStringMap responseHeaders = capturedData.getResponseHeaders();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (String name : responseHeaders.keySet()) {
                String header = (String)responseHeaders.get(name);
                if (httpResponse.containsHeader(name)) continue;
                httpResponse.addHeader(name, header);
            }
            IO.copy((InputStream)new ByteArrayInputStream(capturedData.getRawResponseBody()), (OutputStream)httpResponse.getOutputStream());
        }
        ProxyServlet proxyServlet = this;
        synchronized (proxyServlet) {
            this.monitor.addMessageExchange(capturedData);
        }
    }

    private byte[] getResponseToBytes(String footer, HttpMethodBase postMethod, byte[] res) {
        Header[] headers;
        String response = footer;
        for (Header header : headers = postMethod.getResponseHeaders()) {
            response = response + header.toString();
        }
        response = response + "\n";
        response = response + XmlUtils.prettyPrintXml(new String(res));
        return response.getBytes();
    }

    private byte[] getRequestToBytes(String footer, HttpMethodBase postMethod, CaptureInputStream capture) {
        String request = footer;
        request = request + "\n";
        request = request + XmlUtils.prettyPrintXml(new String(capture.getCapturedData()));
        return request.getBytes();
    }
}

