/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.mock.WsdlMockServiceDesktopPanel;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMockServiceAction
extends AbstractSoapUIAction<WsdlInterface> {
    private static final String CREATE_MOCKSUITE_OPTION = "<create>";

    public GenerateMockServiceAction() {
        super("Generate MockService", "Generates a MockService containing all Operations in this Interface");
    }

    @Override
    public void perform(WsdlInterface iface, Object param) {
        this.generateMockService(iface, false);
    }

    public WsdlMockService generateMockService(WsdlInterface iface, boolean atCreation) {
        XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
        dialog.setBooleanValue("Add Endpoint", true);
        Object[] names = ModelSupport.getNames(iface.getOperationList());
        dialog.setOptions("Operations", names);
        XFormOptionsField operationsFormField = (XFormOptionsField)dialog.getFormField("Operations");
        operationsFormField.setSelectedOptions(names);
        dialog.getFormField("Start MockService").setEnabled(!atCreation);
        WsdlProject project = iface.getProject();
        Object[] mockServices = ModelSupport.getNames(new String[]{CREATE_MOCKSUITE_OPTION}, project.getMockServiceList());
        dialog.setOptions("MockService", mockServices);
        dialog.setValue("Path", "/mock" + iface.getName());
        dialog.setValue("Port", "8088");
        if (dialog.show()) {
            List<String> operations = StringUtils.toStringList(operationsFormField.getSelectedOptions());
            if (operations.size() == 0) {
                UISupport.showErrorMessage("No Operations selected..");
                return null;
            }
            String mockServiceName = dialog.getValue("MockService");
            WsdlMockService mockService = project.getMockServiceByName(mockServiceName);
            if (mockService == null || mockServiceName.equals(CREATE_MOCKSUITE_OPTION)) {
                mockServiceName = UISupport.prompt("Specify name of MockService to create", this.getName(), iface.getName() + " MockService");
                if (mockServiceName == null) {
                    return null;
                }
                mockService = project.addNewMockService(mockServiceName);
            }
            mockService.setPath(dialog.getValue("Path"));
            try {
                mockService.setPort(Integer.parseInt(dialog.getValue("Port")));
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            for (int i = 0; i < iface.getOperationCount(); ++i) {
                WsdlMockOperation mockOperation;
                WsdlOperation operation = iface.getOperationAt(i);
                if (!operations.contains(operation.getName()) || (mockOperation = mockService.addNewMockOperation(operation)) == null) continue;
                mockOperation.addNewMockResponse("Response 1", true);
            }
            if (dialog.getBooleanValue("Add Endpoint")) {
                iface.addEndpoint(mockService.getLocalEndpoint());
            }
            if (!atCreation) {
                WsdlMockServiceDesktopPanel desktopPanel = (WsdlMockServiceDesktopPanel)UISupport.showDesktopPanel(mockService);
                if (dialog.getBooleanValue("Start MockService")) {
                    desktopPanel.startMockService();
                    SoapUI.getDesktop().minimize(desktopPanel);
                }
            }
            return mockService;
        }
        return null;
    }

    @AForm(name="Generate MockService", description="Set options for generated MockOperations for this Interface", helpUrl="http://www.soapui.org/userguide/mock/services.html", icon="/applications-system.png")
    private static interface Form {
        @AField(name="MockService", description="The MockService to create or use", type=AField.AFieldType.ENUMERATION)
        public static final String MOCKSERVICE = "MockService";
        @AField(name="Operations", description="The Operations for which to Generate MockOperations", type=AField.AFieldType.MULTILIST)
        public static final String OPERATIONS = "Operations";
        @AField(name="Path", description="The URL path to mount on", type=AField.AFieldType.STRING)
        public static final String PATH = "Path";
        @AField(name="Port", description="The endpoint port to listen on", type=AField.AFieldType.STRING)
        public static final String PORT = "Port";
        @AField(name="Add Endpoint", description="Adds the MockServices endpoint to the mocked Interface", type=AField.AFieldType.BOOLEAN)
        public static final String ADD_ENDPOINT = "Add Endpoint";
        @AField(name="Start MockService", description="Starts the MockService immediately", type=AField.AFieldType.BOOLEAN)
        public static final String START_MOCKSERVICE = "Start MockService";
    }
}

