/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.support.UISupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointsComboBoxModel
implements ComboBoxModel,
PropertyChangeListener {
    private static final String ADD_NEW_ENDPOINT = "[add new endpoint..]";
    private static final String EDIT_ENDPOINT = "[edit current..]";
    private static final String DELETE_ENDPOINT = "[delete current]";
    private Set<ListDataListener> listeners = new HashSet<ListDataListener>();
    private String[] endpoints;
    private AbstractHttpRequestInterface<?> request;

    public EndpointsComboBoxModel(AbstractHttpRequestInterface<?> request) {
        this.request = request;
        this.initEndpoints();
        request.addPropertyChangeListener(this);
        if (request.getOperation() != null) {
            request.getOperation().getInterface().addPropertyChangeListener(this);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        final String endpoint = this.request.getEndpoint();
        if (anItem != null && anItem.equals(ADD_NEW_ENDPOINT)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String value = UISupport.prompt("Add new endpoint for interface [" + EndpointsComboBoxModel.this.request.getOperation().getInterface().getName() + "]", "Add new endpoint", endpoint);
                    if (value != null) {
                        if (EndpointsComboBoxModel.this.request.getOperation() != null) {
                            EndpointsComboBoxModel.this.request.getOperation().getInterface().addEndpoint(value);
                        }
                        EndpointsComboBoxModel.this.request.setEndpoint(value);
                    }
                }
            });
        } else if (anItem != null && anItem.equals(EDIT_ENDPOINT)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String value = UISupport.prompt("Edit endpoint for interface [" + EndpointsComboBoxModel.this.request.getOperation().getInterface().getName() + "]", "Edit endpoint", endpoint);
                    if (value != null) {
                        if (EndpointsComboBoxModel.this.request.getOperation() != null) {
                            EndpointsComboBoxModel.this.request.getOperation().getInterface().changeEndpoint(endpoint, value);
                        }
                        EndpointsComboBoxModel.this.request.setEndpoint(value);
                    }
                }
            });
        } else if (anItem != null && anItem.equals(DELETE_ENDPOINT)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UISupport.confirm("Delete endpoint [" + endpoint + "]", "Delete endpoint")) {
                        if (EndpointsComboBoxModel.this.request.getOperation() != null) {
                            EndpointsComboBoxModel.this.request.getOperation().getInterface().removeEndpoint(endpoint);
                        }
                        EndpointsComboBoxModel.this.request.setEndpoint(null);
                    }
                }
            });
        } else {
            this.request.setEndpoint((String)anItem);
        }
        this.notifyContentsChanged();
    }

    public void refresh() {
        this.initEndpoints();
        this.notifyContentsChanged();
    }

    private void initEndpoints() {
        this.endpoints = this.request.getOperation() != null ? this.request.getOperation().getInterface().getEndpoints() : new String[0];
    }

    private void notifyContentsChanged() {
        Iterator<ListDataListener> iterator = this.listeners.iterator();
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.getSize());
        while (iterator.hasNext()) {
            iterator.next().contentsChanged(e);
        }
    }

    @Override
    public Object getSelectedItem() {
        String endpoint = this.request.getEndpoint();
        return endpoint == null ? "- no endpoint set -" : endpoint;
    }

    @Override
    public int getSize() {
        return this.endpoints.length + 3;
    }

    @Override
    public Object getElementAt(int index) {
        if (index == this.endpoints.length) {
            return EDIT_ENDPOINT;
        }
        if (index == this.endpoints.length + 1) {
            return ADD_NEW_ENDPOINT;
        }
        if (index == this.endpoints.length + 2) {
            return DELETE_ENDPOINT;
        }
        return this.endpoints[index];
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("endpoint")) {
            this.notifyContentsChanged();
        } else if (propertyName.equals(WsdlInterface.ENDPOINT_PROPERTY)) {
            this.refresh();
        }
    }

    public void release() {
        this.request.removePropertyChangeListener(this);
        if (this.request.getOperation() != null) {
            this.request.getOperation().getInterface().removePropertyChangeListener(this);
        }
    }
}

