/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayRestParamsPropertyHolder
implements RestParamsPropertyHolder {
    private RestParamsPropertyHolder parent;
    private RestParamsPropertyHolder overlay;
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();

    public OverlayRestParamsPropertyHolder(RestParamsPropertyHolder parent, RestParamsPropertyHolder overlay) {
        this.parent = parent;
        this.overlay = overlay;
        parent.addTestPropertyListener(new ParentListener());
        overlay.addTestPropertyListener(new OverlayListener());
    }

    @Override
    public void addParameter(RestParamProperty prop) {
        this.overlay.addParameter(prop);
    }

    @Override
    public RestParamProperty addProperty(String name) {
        return this.overlay.addProperty(name);
    }

    @Override
    public void clear() {
        this.overlay.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.overlay.containsKey(key) || this.parent.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.overlay.containsValue(value) || this.parent.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        return this.getProperties().entrySet();
    }

    @Override
    public RestParamProperty get(Object key) {
        return this.overlay.containsKey(key) ? this.overlay.get(key) : this.parent.get(key);
    }

    @Override
    public ModelItem getModelItem() {
        return this.overlay.getModelItem();
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
        for (TestProperty p : this.values()) {
            result.put(p.getName(), p);
        }
        return result;
    }

    @Override
    public String getPropertiesLabel() {
        return this.overlay.getPropertiesLabel();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.get(name);
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.values().toArray(new RestParamProperty[0])[index];
    }

    @Override
    public int getPropertyCount() {
        return this.values().size();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        return this.overlay.getPropertyExpansions();
    }

    @Override
    public int getPropertyIndex(String name) {
        int index = 0;
        for (TestProperty prop : this.values()) {
            if (prop.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public String[] getPropertyNames() {
        return this.keySet().toArray(new String[0]);
    }

    @Override
    public String getPropertyValue(String name) {
        return this.overlay.hasProperty(name) ? this.overlay.getPropertyValue(name) : this.parent.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.containsKey(name);
    }

    @Override
    public boolean isEmpty() {
        return this.overlay.isEmpty() && this.parent.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> names = new HashSet<String>();
        for (TestProperty prop : this.values()) {
            names.add(prop.getName());
        }
        return names;
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.overlay.moveProperty(propertyName, targetIndex);
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        return this.overlay.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        this.overlay.putAll(m);
    }

    @Override
    public TestProperty remove(Object key) {
        return (TestProperty)this.overlay.remove(key);
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        return this.overlay.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.overlay.renameProperty(name, newName);
    }

    @Override
    public void resetValues() {
        this.overlay.resetValues();
    }

    @Override
    public void saveTo(Properties props) {
        for (TestProperty prop : this.values()) {
            props.setProperty(prop.getName(), prop.getValue() != null ? prop.getValue() : "");
        }
    }

    @Override
    public void setPropertiesLabel(String propertiesLabel) {
        this.overlay.setPropertiesLabel(propertiesLabel);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.overlay.setPropertyValue(name, value);
    }

    @Override
    public int size() {
        return this.getPropertyCount();
    }

    @Override
    public Collection<TestProperty> values() {
        ArrayList<TestProperty> values = new ArrayList<TestProperty>();
        for (TestProperty prop : this.parent.values()) {
            if (this.overlay.hasProperty(prop.getName())) {
                values.add(this.overlay.getProperty(prop.getName()));
                continue;
            }
            values.add(prop);
        }
        for (TestProperty prop : this.overlay.values()) {
            if (this.parent.hasProperty(prop.getName())) continue;
            values.add(prop);
        }
        return values;
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.overlay.getPropertyList();
    }

    private class OverlayListener
    implements TestPropertyListener {
        private OverlayListener() {
        }

        public void propertyAdded(String name) {
            if (OverlayRestParamsPropertyHolder.this.parent.hasProperty(name)) {
                if (!OverlayRestParamsPropertyHolder.this.parent.getPropertyValue(name).equals(OverlayRestParamsPropertyHolder.this.overlay.getPropertyValue(name))) {
                    OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(name, OverlayRestParamsPropertyHolder.this.parent.getPropertyValue(name), OverlayRestParamsPropertyHolder.this.overlay.getPropertyValue(name));
                }
            } else {
                OverlayRestParamsPropertyHolder.this.firePropertyAdded(name);
            }
        }

        public void propertyMoved(String name, int oldIndex, int newIndex) {
        }

        public void propertyRemoved(String name) {
            if (OverlayRestParamsPropertyHolder.this.parent.hasProperty(name)) {
                OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(name, null, OverlayRestParamsPropertyHolder.this.parent.getPropertyValue(name));
            } else {
                OverlayRestParamsPropertyHolder.this.firePropertyRemoved(name);
            }
        }

        public void propertyRenamed(String oldName, String newName) {
            if (!OverlayRestParamsPropertyHolder.this.parent.hasProperty(oldName) && !OverlayRestParamsPropertyHolder.this.parent.hasProperty(newName)) {
                OverlayRestParamsPropertyHolder.this.firePropertyRenamed(oldName, newName);
            } else if (OverlayRestParamsPropertyHolder.this.parent.hasProperty(oldName) && OverlayRestParamsPropertyHolder.this.parent.hasProperty(newName)) {
                OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(oldName, OverlayRestParamsPropertyHolder.this.overlay.getPropertyValue(newName), OverlayRestParamsPropertyHolder.this.parent.getPropertyValue(oldName));
                OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(newName, OverlayRestParamsPropertyHolder.this.parent.getPropertyValue(newName), OverlayRestParamsPropertyHolder.this.overlay.getPropertyValue(newName));
            } else if (OverlayRestParamsPropertyHolder.this.parent.hasProperty(oldName)) {
                OverlayRestParamsPropertyHolder.this.firePropertyAdded(newName);
            } else {
                OverlayRestParamsPropertyHolder.this.firePropertyRemoved(oldName);
            }
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(name, oldValue, newValue);
        }
    }

    private class ParentListener
    implements TestPropertyListener {
        private ParentListener() {
        }

        public void propertyAdded(String name) {
            if (!OverlayRestParamsPropertyHolder.this.overlay.hasProperty(name)) {
                OverlayRestParamsPropertyHolder.this.firePropertyAdded(name);
            }
        }

        public void propertyMoved(String name, int oldIndex, int newIndex) {
        }

        public void propertyRemoved(String name) {
            if (!OverlayRestParamsPropertyHolder.this.overlay.hasProperty(name)) {
                OverlayRestParamsPropertyHolder.this.firePropertyRemoved(name);
            }
        }

        public void propertyRenamed(String oldName, String newName) {
            if (OverlayRestParamsPropertyHolder.this.overlay.hasProperty(oldName)) {
                if (!OverlayRestParamsPropertyHolder.this.overlay.hasProperty(newName)) {
                    OverlayRestParamsPropertyHolder.this.firePropertyAdded(newName);
                }
            } else if (OverlayRestParamsPropertyHolder.this.overlay.hasProperty(newName)) {
                OverlayRestParamsPropertyHolder.this.firePropertyRemoved(oldName);
            }
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            if (!OverlayRestParamsPropertyHolder.this.overlay.hasProperty(name)) {
                OverlayRestParamsPropertyHolder.this.firePropertyValueChanged(name, oldValue, newValue);
            }
        }
    }
}

