/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.http.transport;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import wsattacker.http.transport.HttpHeader;
import wsattacker.http.transport.SoapResponse;
import wsattacker.http.transport.TlsWrapperClient;

public class SoapHttpClient {
    private static int MAX_RETRY_NUMBER = 3;
    private static SoapHttpClient currentInstance = null;
    private HttpClient client = TlsWrapperClient.wrapClient((HttpClient)new DefaultHttpClient());
    private HttpPost post;
    private static Logger LOG = Logger.getLogger(SoapHttpClient.class);

    SoapHttpClient(WsdlRequest request) {
        this(request.getEndpoint());
        this.setSoapUiHeaders(request);
    }

    SoapHttpClient(String destinationUrl) {
        this.post = new HttpPost(destinationUrl);
        this.setConfigProxy();
    }

    private void setConfigProxy() {
        String[] protocols;
        for (String protocol : protocols = new String[]{"http", "https"}) {
            String httpProxyHost = System.getProperty(protocol + ".proxyHost");
            String proxyPortAsString = System.getProperty(protocol + ".proxyPort");
            if (httpProxyHost == null || httpProxyHost.isEmpty() || proxyPortAsString == null || proxyPortAsString.isEmpty()) continue;
            try {
                int httpProxyPort = Integer.parseInt(proxyPortAsString);
                if (httpProxyHost == null || httpProxyHost.isEmpty()) continue;
                HttpHost proxy = new HttpHost(httpProxyHost, httpProxyPort, protocol);
                this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            catch (NumberFormatException e) {
                Logger.getLogger(SoapHttpClient.class).warn((Object)String.format("Could not set Proxy for %s with value with value '%s'", protocol, proxyPortAsString), (Throwable)e);
            }
        }
    }

    public static boolean isContentLengthHeader(String name) {
        return "Content-Length".equals(name);
    }

    private void setSoapUiHeaders(WsdlRequest request) {
        WsdlResponse response = request.getResponse();
        if (response != null) {
            StringToStringsMap requestBasicHeaders = response.getRequestHeaders();
            this.setHeaders(requestBasicHeaders);
        }
        StringToStringsMap additionalHeaders = request.getRequestHeaders();
        this.setHeaders(additionalHeaders);
    }

    private void setHeaders(StringToStringsMap headers) {
        for (Map.Entry header : headers.entrySet()) {
            String name = (String)header.getKey();
            if (SoapHttpClient.isContentLengthHeader(name)) {
                LOG.debug((Object)"HTTP-Header 'Content-Length' will be recalculated.");
                continue;
            }
            for (String value : (List)header.getValue()) {
                this.post.setHeader(name, value);
            }
        }
    }

    public static SoapHttpClient getSoapHttpClient() {
        return currentInstance;
    }

    public SoapResponse sendSoap(String soap) throws IOException {
        StringEntity httpBody = new StringEntity(soap);
        this.post.setEntity((HttpEntity)httpBody);
        int maxTries = MAX_RETRY_NUMBER;
        HttpResponse httpResponse = null;
        while (httpResponse == null) {
            try {
                httpResponse = this.client.execute((HttpUriRequest)this.post);
            }
            catch (IOException ex) {
                if (maxTries == 0) {
                    throw ex;
                }
                --maxTries;
                LOG.warn((Object)ex.getLocalizedMessage());
                LOG.warn((Object)"Trying to send the message once more");
                LOG.debug((Object)ex);
            }
        }
        SoapResponse soapResponse = new SoapResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)httpResponse.getStatusLine());
        }
        soapResponse.setStatusLine(httpResponse.getStatusLine().toString());
        for (Header h : httpResponse.getAllHeaders()) {
            String name = h.getName();
            String value = h.getValue();
            if (LOG.isDebugEnabled()) {
                String headerDebug = name + ": " + value;
                LOG.debug((Object)headerDebug);
            }
            HttpHeader newHeader = new HttpHeader(name, value);
            soapResponse.getHeaders().add(newHeader);
        }
        LOG.debug((Object)"waiting for response: ");
        HttpEntity entity = httpResponse.getEntity();
        String charset = EntityUtils.getContentCharSet((HttpEntity)entity);
        String responseString = EntityUtils.toString((HttpEntity)entity, (String)charset);
        soapResponse.setBody(responseString);
        return soapResponse;
    }

    public void shutDownConnectionManager() {
        this.client.getConnectionManager().shutdown();
    }
}

