/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultTreeCheckingModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingMode;
import javax.swing.tree.TreePath;

public class PropagateTreeCheckingMode
extends TreeCheckingMode {
    PropagateTreeCheckingMode(DefaultTreeCheckingModel model) {
        super(model);
    }

    public void checkPath(TreePath path) {
        this.model.checkSubTree(path);
        this.model.updatePathGreyness(path);
        this.model.updateAncestorsGreyness(path);
    }

    public void uncheckPath(TreePath path) {
        this.model.uncheckSubTree(path);
        this.model.updatePathGreyness(path);
        this.model.updateAncestorsGreyness(path);
    }

    public void updateCheckAfterChildrenInserted(TreePath parent) {
        if (this.model.isPathChecked(parent)) {
            this.model.checkSubTree(parent);
        } else {
            this.model.uncheckSubTree(parent);
        }
    }

    public void updateCheckAfterChildrenRemoved(TreePath parent) {
        this.model.updatePathGreyness(parent);
        this.model.updateAncestorsGreyness(parent);
    }

    public void updateCheckAfterStructureChanged(TreePath parent) {
        if (this.model.isPathChecked(parent)) {
            this.model.checkSubTree(parent);
        } else {
            this.model.uncheckSubTree(parent);
        }
    }
}

