/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class HexUtils {
    private static final int ROW_BYTES = 16;
    private static final int ROW_QTR1 = 3;
    private static final int ROW_HALF = 7;
    private static final int ROW_QTR2 = 11;

    public static void dumpHexData(PrintStream out, String title, byte[] buf, int numBytes) {
        PrintWriter wrtr = new PrintWriter(new OutputStreamWriter(out));
        HexUtils.dumpHexData(wrtr, title, buf, 0, numBytes);
        wrtr.flush();
    }

    public static void dumpHexData(PrintWriter out, String title, byte[] buf, int offset, int numBytes) {
        String saveStr;
        int j;
        String idxStr;
        int hexVal;
        int i;
        byte[] save_buf = new byte[18];
        char[] hex_buf = new char[4];
        char[] idx_buf = new char[8];
        char[] hex_chars = new char[20];
        hex_chars[0] = 48;
        hex_chars[1] = 49;
        hex_chars[2] = 50;
        hex_chars[3] = 51;
        hex_chars[4] = 52;
        hex_chars[5] = 53;
        hex_chars[6] = 54;
        hex_chars[7] = 55;
        hex_chars[8] = 56;
        hex_chars[9] = 57;
        hex_chars[10] = 65;
        hex_chars[11] = 66;
        hex_chars[12] = 67;
        hex_chars[13] = 68;
        hex_chars[14] = 69;
        hex_chars[15] = 70;
        out.println(title + " - " + numBytes + " bytes.");
        int rows = numBytes >> 4;
        int residue = numBytes & 0xF;
        for (i = 0; i < rows; ++i) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 8);
            out.print(idxStr + ": ");
            for (j = 0; j < 16; ++j) {
                save_buf[j] = buf[offset + i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print(hex_buf[0]);
                out.print(hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] >= 32 && save_buf[j] <= 126) continue;
                save_buf[j] = 46;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(" | " + saveStr + " |");
        }
        if (residue > 0) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 4);
            out.print(idxStr + ": ");
            for (j = 0; j < residue; ++j) {
                save_buf[j] = buf[offset + i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print(hex_buf[0]);
                out.print(hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] >= 32 && save_buf[j] <= 126) continue;
                save_buf[j] = 46;
            }
            while (j < 16) {
                save_buf[j] = 32;
                out.print("   ");
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                ++j;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(" | " + saveStr + " |");
        }
    }

    public static void main(String[] args) {
        byte[] data = new byte[132];
        for (int i = 0; i < 132; ++i) {
            data[i] = (byte)i;
        }
        HexUtils.dumpHexData(System.out, "Test HexDump", data, 132);
        System.out.println("Done");
    }
}

