/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.swing.actions.ActionSupport;
import hermes.swing.actions.DirectoryCache;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class OpenConfigAction
extends ActionSupport {
    public OpenConfigAction() {
        this.putValue("Name", "Open Configuration...");
        this.putValue("ShortDescription", "Open another Hermes configuration.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.open"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser chooser = DirectoryCache.lastOpenConfigDirectory == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(DirectoryCache.lastOpenConfigDirectory);
        if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Open") == 0) {
            DirectoryCache.lastOpenConfigDirectory = chooser.getSelectedFile().getParentFile();
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"hermes.config");
                Unmarshaller u = jc.createUnmarshaller();
                u.unmarshal((InputStream)new FileInputStream(chooser.getSelectedFile()));
                HermesBrowser.getBrowser().setCurrentConfig(chooser.getSelectedFile().getAbsolutePath());
                HermesBrowser.getBrowser().loadConfig();
            }
            catch (Exception e) {
                HermesBrowser.getBrowser().showErrorDialog("Cannot load configuration: ", e);
            }
        }
    }
}

