/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.JideMenu;
import hermes.browser.actions.FIXMessageBrowserDocumentComponent;
import hermes.browser.tasks.BrowseFIXChainTask;
import hermes.fix.ChainByClOrdID;
import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageTable;
import hermes.swing.actions.ActionSupport;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.log4j.Logger;

public class ChainByClOrdIDAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(ChainByClOrdIDAction.class);
    private FIXMessageTable table;
    private ChainByClOrdID chain;

    public ChainByClOrdIDAction(JideMenu menu, FIXMessageTable table) {
        this.table = table;
        this.chain = new ChainByClOrdID(table);
        this.putValue("Name", "By ClOrdID...");
        this.putValue("ShortDescription", "Follow messages related to this order");
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChainByClOrdIDAction.this.doTableSelectionChanged();
            }
        });
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                ChainByClOrdIDAction.this.doTableSelectionChanged();
            }
        });
        this.setEnabled(false);
    }

    private void doTableSelectionChanged() {
        if (this.table.getSelectedRow() >= 0) {
            try {
                FIXMessage message = this.table.getMessageAt(this.table.getSelectedRow());
                this.setEnabled(this.chain.canChain(message));
            }
            catch (FIXException e) {
                this.setEnabled(false);
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FIXMessage message;
        if (this.table.getSelectedRow() >= 0 && (message = this.table.getMessageAt(this.table.getSelectedRow())).fieldExists(11)) {
            String clOrdID = message.getString(11);
            FIXMessageBrowserDocumentComponent frame = new FIXMessageBrowserDocumentComponent(this.table.getSessionKey(), clOrdID);
            BrowseFIXChainTask task = new BrowseFIXChainTask(this.table, frame, clOrdID, this.table.getSelectedRow());
            frame.setTask(task);
            task.start();
        }
    }
}

