/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.MessageStoreQueueTreeNode;
import hermes.browser.model.tree.MessageStoreTopicTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.config.DestinationConfig;
import hermes.swing.actions.ActionSupport;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BrowseDestinationWithSelectorAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(BrowseDestinationWithSelectorAction.class);

    public BrowseDestinationWithSelectorAction() {
        this.putValue("Name", "Browse with selector...");
        this.putValue("ShortDescription", "Browse the queue, topic or message store with a selector");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.browseWithSelector"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.setEnabled(false);
        this.enableOnBrowserTreeSelection(new Class[]{MessageStoreQueueTreeNode.class, MessageStoreTopicTreeNode.class, MessageStoreTreeNode.class, DestinationConfigTreeNode.class}, (Action)this, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(this.getBrowserTree().getSelectionModel().getSelectionPath());
    }

    public void actionPerformed(TreePath selectionPath) {
        if (selectionPath != null) {
            try {
                String selector = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Enter Selector", "");
                if (!TextUtils.isEmpty(selector)) {
                    MessageStoreTopicTreeNode topicNode;
                    if (selectionPath.getLastPathComponent() instanceof DestinationConfigTreeNode) {
                        DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)selectionPath.getLastPathComponent();
                        Hermes hermes = destinationNode.getHermesTreeNode().getHermes();
                        DestinationConfig newConfig = HermesBrowser.getConfigDAO().duplicate(destinationNode.getConfig());
                        newConfig.setSelector(selector);
                        log.info((Object)("browsing " + hermes.getId() + ": " + destinationNode.getDestinationName() + " with user selector " + selector));
                        HermesBrowser.getBrowser().getActionFactory().createQueueBrowseAction(hermes, newConfig);
                    } else if (selectionPath.getLastPathComponent() instanceof MessageStoreTreeNode) {
                        MessageStoreTreeNode node = (MessageStoreTreeNode)selectionPath.getLastPathComponent();
                        Hermes hermes = this.checkHermesForMessageStore();
                        HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(node.getMessageStore(), hermes, selector);
                    } else if (selectionPath.getLastPathComponent() instanceof MessageStoreQueueTreeNode) {
                        MessageStoreQueueTreeNode queueNode = (MessageStoreQueueTreeNode)selectionPath.getLastPathComponent();
                        if (queueNode.getParent() instanceof MessageStoreTreeNode) {
                            MessageStoreTreeNode storeNode = (MessageStoreTreeNode)queueNode.getParent();
                            Hermes hermes = this.checkHermesForMessageStore();
                            HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(storeNode.getMessageStore(), hermes, (Destination)((Queue)queueNode.getBean()), selector);
                        }
                    } else if (selectionPath.getLastPathComponent() instanceof MessageStoreTopicTreeNode && (topicNode = (MessageStoreTopicTreeNode)selectionPath.getLastPathComponent()).getParent() instanceof MessageStoreTreeNode) {
                        MessageStoreTreeNode storeNode = (MessageStoreTreeNode)topicNode.getParent();
                        Hermes hermes = this.checkHermesForMessageStore();
                        HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(storeNode.getMessageStore(), hermes, (Destination)((Topic)topicNode.getBean()), selector);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                HermesBrowser.getBrowser().showErrorDialog(ex);
            }
        }
    }

    private Hermes checkHermesForMessageStore() {
        return this.getBrowserTree().getLastSelectedHermesTreeNode() == null ? null : this.getBrowserTree().getLastSelectedHermesTreeNode().getHermes();
    }
}

