/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAuditLog;
import hermes.HermesDispatcher;
import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.MessageFactory;
import hermes.ProviderMetaData;
import hermes.browser.HermesBrowser;
import hermes.browser.MessageRenderer;
import hermes.config.DestinationConfig;
import hermes.config.HermesConfig;
import hermes.config.ProviderExtConfig;
import hermes.config.SessionConfig;
import hermes.impl.DefaultHermesDispatcherImpl;
import hermes.impl.DefaultHermesLogImpl;
import hermes.impl.DefaultProviderMetaData;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.DestinationManager;
import hermes.impl.HermesAdminAdapter;
import hermes.impl.RegexQueueBrowser;
import hermes.impl.SessionManager;
import hermes.impl.XMLHelper;
import hermes.util.JMSUtils;
import hermes.util.MessageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class DefaultHermesImpl
implements Hermes {
    private static final Logger log = Logger.getLogger(DefaultHermesImpl.class);
    private static final String DEFAULT_DISPATCHER = "defaultHermesDispatcher";
    private static final Timer timer = new Timer();
    private XMLHelper xmlSupport = new DefaultXMLHelper();
    private SessionManager sessionManager;
    private ProviderMetaData metaData;
    private Map dispatchers = new HashMap();
    private Map timerMap = new HashMap();
    private DefaultHermesDispatcherImpl defaultDespatcher;
    private ThreadLocal auditLogTL = new ThreadLocal();
    private boolean readOnly = false;
    private final boolean reconnecting = false;
    private ProviderExtConfig extConfig;
    private HermesAdminAdapter adminAdapter;
    private ClassLoader contextClassLoader;

    public DefaultHermesImpl(ProviderExtConfig extConfig, SessionManager sessionManager, ClassLoader contextClassLoader) throws JMSException, IOException {
        this.extConfig = extConfig;
        this.sessionManager = sessionManager;
        this.defaultDespatcher = this._getDispatcher(DEFAULT_DISPATCHER);
        this.contextClassLoader = contextClassLoader;
        try {
            this.getAdminAdapter();
        }
        catch (JMSException ex) {
            log.error((Object)("cannot bootstrap AdminAdapter: " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void reconnect(String username, String password) throws JMSException {
        this.sessionManager.reconnect(username, password);
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.sessionManager.getConfig();
    }

    private synchronized HermesAdminAdapter getAdminAdapter() throws JMSException {
        if (this.adminAdapter == null) {
            this.adminAdapter = new HermesAdminAdapter(this, this.sessionManager.getConnectionFactoryManager().getExtension(this.extConfig));
        }
        return this.adminAdapter;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().getTransacted();
    }

    @Override
    public void close(Destination destination, String selector) throws JMSException {
        this.sessionManager.closeConsumer(destination, selector);
    }

    public void closeConsumer(Destination d) throws JMSException {
        this.sessionManager.closeConsumer(d, null);
    }

    @Override
    public Session getSession() throws JMSException {
        return this.sessionManager.getSession();
    }

    @Override
    public synchronized void close() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.sessionManager.close();
        if (this.adminAdapter != null) {
            this.adminAdapter.close();
        }
        this.getAuditLog().rollback();
    }

    public synchronized boolean isOpen() {
        return this.sessionManager.isOpen();
    }

    @Override
    public void commit() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.sessionManager.getSession().getTransacted()) {
            this.sessionManager.getSession().commit();
        } else {
            log.warn((Object)("session " + this.getId() + " is not transacted"));
        }
        try {
            if (this.isAudit()) {
                this.getAuditLog().commit();
            }
        }
        catch (JMSException ex) {
            log.error((Object)("cannot log audit during commit: " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public QueueBrowser createBrowser(DestinationConfig config) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (config.getDomain().intValue() == Domain.TOPIC.getId() && config.isDurable()) {
            return this.getAdminAdapter().createDurableSubscriptionBrowser(config);
        }
        return this.sessionManager.createBrowser(this, config);
    }

    @Override
    public QueueBrowser createBrowser(Destination destination) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.createBrowser(this, destination, null);
    }

    @Override
    public QueueBrowser createBrowser(Destination destination, String selector) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.createBrowser(this, destination, selector);
    }

    @Override
    public final BytesMessage createBytesMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createBytesMessage();
    }

    @Override
    public final MapMessage createMapMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createMapMessage();
    }

    @Override
    public final ObjectMessage createObjectMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createObjectMessage();
    }

    @Override
    public final StreamMessage createStreamMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createStreamMessage();
    }

    @Override
    public final TextMessage createTextMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createTextMessage();
    }

    @Override
    public Message createMessage() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createMessage();
    }

    @Override
    public final TextMessage createTextMessage(String s) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getSession().createTextMessage(s);
    }

    @Override
    public final ConnectionFactory getConnectionFactory() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getConnectionFactory();
    }

    @Override
    public Connection getConnection() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getConnection();
    }

    @Override
    public final Destination getDestination(String name, Domain domain) throws JMSException, NamingException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        DestinationConfig dConfig = this.getDestinationConfig(name, domain);
        if (dConfig != null) {
            if (dConfig.getUsername() != null) {
                this.reconnect(dConfig.getUsername(), dConfig.getPassword());
            }
            return this.sessionManager.getDestination(name, Domain.getDomain(dConfig.getDomain()));
        }
        if (this.getConnectionFactory() instanceof QueueConnectionFactory) {
            return this.sessionManager.getDestination(name, Domain.QUEUE);
        }
        return this.sessionManager.getDestination(name, Domain.TOPIC);
    }

    @Override
    public Domain getDomain(Destination destination) throws JMSException {
        DestinationConfig dConfig = this.getDestinationConfig(this.getDestinationName(destination), Domain.UNKNOWN);
        if (dConfig != null) {
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                return Domain.QUEUE;
            }
            return Domain.TOPIC;
        }
        if (destination instanceof Queue) {
            return Domain.QUEUE;
        }
        return Domain.TOPIC;
    }

    @Override
    public final Iterator getDestinations() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getDestinations().iterator();
    }

    @Override
    public final String getId() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getId();
    }

    @Override
    public Message receive(Destination d) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d).receive();
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public Message receive(Destination d, String selector) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d, selector).receive();
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public Message receive(Destination d, long ms, String selector) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d, selector).receive(ms);
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public Message receive(Destination d, long ms) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d).receive(ms);
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public Message receiveNoWait(Destination d) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d).receiveNoWait();
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public Message receiveNoWait(Destination d, String selector) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        Message m = this.sessionManager.getConsumer(d, selector).receiveNoWait();
        if (m != null && this.isAudit()) {
            this.getAuditLog().onRead(d, m);
        }
        return m;
    }

    @Override
    public void rollback() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.sessionManager.getSession().getTransacted()) {
            this.sessionManager.getSession().rollback();
        } else {
            log.warn((Object)("session " + this.getId() + " is not transacted"));
        }
        if (this.isAudit()) {
            this.getAuditLog().rollback();
        }
    }

    @Override
    public void send(Destination d, Message m) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        boolean try102 = false;
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        if (Hermes.ui.getConfig().isDeliveryModePersistent()) {
            m.setJMSDeliveryMode(2);
        } else {
            m.setJMSDeliveryMode(1);
        }
        MessageProducer producer = this.sessionManager.getProducer();
        if (m.getJMSPriority() < 0) {
            m.setJMSPriority(0);
        }
        if (m.getJMSExpiration() < 0L) {
            m.setJMSExpiration(0L);
        }
        try {
            producer.send(d, m, m.getJMSDeliveryMode(), m.getJMSPriority(), m.getJMSExpiration());
        }
        catch (NoSuchMethodError ex) {
            try102 = true;
        }
        catch (AbstractMethodError ex) {
            try102 = true;
        }
        if (try102) {
            if (JMSUtils.isQueue(d)) {
                QueueSender sender = (QueueSender)producer;
                if (d != null) {
                    sender.send((Queue)d, m, m.getJMSDeliveryMode(), m.getJMSPriority(), m.getJMSExpiration());
                } else {
                    sender.send(m, m.getJMSDeliveryMode(), m.getJMSPriority(), m.getJMSExpiration());
                }
            } else {
                TopicPublisher publisher = (TopicPublisher)producer;
                if (d != null) {
                    publisher.publish((Topic)d, m, m.getJMSDeliveryMode(), m.getJMSPriority(), m.getJMSExpiration());
                } else {
                    publisher.publish(m, m.getJMSDeliveryMode(), m.getJMSPriority(), m.getJMSExpiration());
                }
            }
        }
        if (this.isAudit()) {
            this.getAuditLog().onWrite(d, m);
        }
    }

    @Override
    public Context createContext() throws NamingException, JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getConnectionFactoryManager().createContext();
    }

    @Override
    public void setMessageListener(final Destination d, final MessageListener l) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.isReadOnly()) {
            throw new JMSException("Hermes is in read-only mode");
        }
        if (this.isAudit()) {
            MessageListener auditListener = new MessageListener(){

                public void onMessage(Message arg0) {
                    try {
                        DefaultHermesImpl.this.getAuditLog().onRead(d, arg0);
                    }
                    catch (JMSException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    l.onMessage(arg0);
                }
            };
            this.defaultDespatcher.setMessageListener(d, auditListener);
        } else {
            this.defaultDespatcher.setMessageListener(d, l);
        }
    }

    public String toString() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.toString();
    }

    @Override
    public final boolean isQueue() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return JMSUtils.isQueue(this.getConnectionFactory());
    }

    @Override
    public final boolean isTopic() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return !JMSUtils.isQueue(this.getConnectionFactory());
    }

    @Override
    public ProviderMetaData getMetaData() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        if (this.metaData == null) {
            this.metaData = new DefaultProviderMetaData(this, this.sessionManager.getFactoryConfig(), true);
        }
        return this.metaData;
    }

    @Override
    public Message duplicate(Destination to, Message in) throws JMSException {
        HermesConfig config = HermesBrowser.getBrowser().getConfig();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        TextMessage out = null;
        if (in instanceof TextMessage) {
            out = this.createTextMessage(((TextMessage)in).getText());
        } else if (in instanceof ObjectMessage) {
            out = this.createObjectMessage();
            ((ObjectMessage)out).setObject(((ObjectMessage)in).getObject());
        } else if (in instanceof MapMessage) {
            out = this.createMapMessage();
            MapMessage inMap = (MapMessage)in;
            MapMessage outMap = (MapMessage)out;
            Enumeration iter = inMap.getMapNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                outMap.setObject(key, inMap.getObject(key));
            }
        } else if (in instanceof StreamMessage) {
            out = this.createStreamMessage();
            StreamMessage inS = (StreamMessage)in;
            StreamMessage outS = (StreamMessage)out;
            try {
                while (true) {
                    outS.writeObject(inS.readObject());
                }
            }
            catch (MessageEOFException ex2) {}
        } else if (in instanceof BytesMessage) {
            out = this.createBytesMessage();
            BytesMessage inBytes = (BytesMessage)in;
            BytesMessage outBytes = (BytesMessage)out;
            try {
                outBytes.writeBytes(MessageUtils.asBytes(inBytes));
            }
            catch (MessageEOFException ex2) {}
        } else if (in instanceof Message) {
            out = this.createMessage();
        } else {
            throw new HermesException("Cannot handle " + in.getClass().getName());
        }
        try {
            out.setJMSDestination(to);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (config.isCopyJMSCorrelationID()) {
            try {
                out.setJMSCorrelationID(in.getJMSCorrelationID());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (config.isCopyJMSExpiration()) {
            try {
                out.setJMSExpiration(in.getJMSExpiration());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (config.isCopyJMSPriority()) {
            try {
                out.setJMSPriority(in.getJMSPriority());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (config.isCopyJMSReplyTo()) {
            try {
                if (in.getJMSReplyTo() != null) {
                    out.setJMSReplyTo(this.getDestination(this.getDestinationName(in.getJMSReplyTo()), Domain.getDomain(in.getJMSReplyTo())));
                }
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (NamingException ex) {
                throw new HermesRuntimeException(ex);
            }
        }
        if (config.isCopyJMSType()) {
            try {
                out.setJMSType(in.getJMSType());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (in.getPropertyNames() != null) {
            Enumeration iter = in.getPropertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                if (key.startsWith("JMS") && !config.isCopyJMSProviderProperties()) continue;
                out.setObjectProperty(key, in.getObjectProperty(key));
            }
        }
        return out;
    }

    @Override
    public Message duplicate(Message in) throws JMSException {
        return this.duplicate(null, in);
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void schedule(final TimerTask task, long delay, boolean repeating) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    DefaultHermesImpl.this.invoke(task);
                }
                catch (JMSException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        };
        this.timerMap.put(task, timerTask);
        if (repeating) {
            timer.schedule(task, delay, delay);
        } else {
            timer.schedule(task, delay);
        }
    }

    @Override
    public void cancel(TimerTask task) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        TimerTask timerTask = (TimerTask)this.timerMap.remove(task);
        if (timerTask == null) {
            throw new JMSException("Unknown timer");
        }
        timerTask.cancel();
    }

    @Override
    public String getDestinationName(Destination to) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return JMSUtils.getDestinationName(to);
    }

    @Override
    public DestinationConfig getDestinationConfig(String d, Domain domain) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.sessionManager.getDestinationConfig(d, domain);
    }

    @Override
    public HermesDispatcher getDispatcher(String name) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this._getDispatcher(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DefaultHermesDispatcherImpl _getDispatcher(String name) throws JMSException {
        DefaultHermesDispatcherImpl dispatcher;
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        Map map = this.dispatchers;
        synchronized (map) {
            if (this.dispatchers.containsKey(name)) {
                dispatcher = (DefaultHermesDispatcherImpl)this.dispatchers.get(name);
            } else {
                dispatcher = new DefaultHermesDispatcherImpl(this);
                this.dispatchers.put(name, dispatcher);
            }
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeDispatcher(HermesDispatcher dispatcher) {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        Map map = this.dispatchers;
        synchronized (map) {
            this.dispatchers.remove(dispatcher);
        }
    }

    @Override
    public void setMessageListener(HermesDispatcher dispatcher, Destination d, MessageListener ml) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        dispatcher.setMessageListener(d, ml);
    }

    @Override
    public void invoke(Runnable runnable) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.defaultDespatcher.invoke(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAll(Runnable runnable) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        Map map = this.dispatchers;
        synchronized (map) {
            for (Map.Entry entry : this.dispatchers.entrySet()) {
                HermesDispatcher dispatcher = (HermesDispatcher)entry.getValue();
                dispatcher.invoke(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAllAndWait(Runnable runnable) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        Map map = this.dispatchers;
        synchronized (map) {
            for (Map.Entry entry : this.dispatchers.entrySet()) {
                HermesDispatcher dispatcher = (HermesDispatcher)entry.getValue();
                dispatcher.invokeAndWait(runnable);
            }
        }
    }

    @Override
    public void invokeAndWait(Runnable runnable) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.defaultDespatcher.invokeAndWait(runnable);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException, NamingException {
        return (Queue)this.getDestination(queueName, Domain.QUEUE);
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException, NamingException {
        return (Topic)this.getDestination(topicName, Domain.TOPIC);
    }

    public boolean isAudit() throws JMSException {
        return this.sessionManager.isAudit() && this.getTransacted();
    }

    public HermesAuditLog getAuditLog() throws JMSException {
        try {
            HermesAuditLog rval = (HermesAuditLog)this.auditLogTL.get();
            if (rval == null) {
                rval = new DefaultHermesLogImpl(this, this.sessionManager.getAuditDirectory(), true, true);
                this.auditLogTL.set(rval);
            }
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    @Override
    public Collection fromXML(InputStream istream) throws JMSException, IOException {
        return this.xmlSupport.fromXML((MessageFactory)this, istream);
    }

    @Override
    public Collection fromXML(String document) throws JMSException {
        return this.xmlSupport.fromXML((MessageFactory)this, document);
    }

    @Override
    public void toXML(Collection messages, OutputStream ostream) throws JMSException, IOException {
        this.xmlSupport.toXML(messages, ostream);
    }

    @Override
    public String toXML(Collection messages) throws JMSException {
        return this.xmlSupport.toXML(messages);
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.sessionManager.getSession().createObjectMessage(object);
    }

    @Override
    public boolean isConnectable() throws JMSException {
        this.sessionManager.getSession();
        this.sessionManager.close();
        return true;
    }

    @Override
    public void toXML(Message message, OutputStream ostream) throws JMSException, IOException {
        ArrayList<Message> c = new ArrayList<Message>();
        c.add(message);
        this.toXML(c, ostream);
    }

    @Override
    public String toXML(Message message) throws JMSException {
        ArrayList<Message> c = new ArrayList<Message>();
        c.add(message);
        return this.toXML(c);
    }

    @Override
    public void addDestinationConfig(DestinationConfig dConfig) throws JMSException {
        this.sessionManager.getConnectionFactoryManager().addDestinationConfig(dConfig);
    }

    @Override
    public void removeDestinationConfig(DestinationConfig dConfig) throws JMSException {
        this.sessionManager.getConnectionFactoryManager().removeDestinationConfig(dConfig);
    }

    @Override
    public long getAge(DestinationConfig dest) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().getAge(dest);
    }

    @Override
    public MessageRenderer getMessageRenderer() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().getMessageRenderer();
    }

    @Override
    public int getDepth(DestinationConfig dest) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().getDepth(dest);
    }

    @Override
    public Collection getStatistics(Collection destinations) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().getStatistics(destinations);
    }

    @Override
    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().getStatistics(dConfig);
    }

    @Override
    public QueueBrowser createDurableSubscriptionBrowser(DestinationConfig dConfig) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().createDurableSubscriptionBrowser(dConfig);
    }

    @Override
    public void delete(DestinationConfig dConfig, Collection<String> messageIds, ProgressMonitor progress) throws JMSException, NamingException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.getAdminAdapter().delete(dConfig, messageIds, progress);
    }

    @Override
    public void delete(DestinationConfig dConfig, Collection<String> messageIds) throws JMSException, NamingException {
        this.delete(dConfig, messageIds, null);
    }

    @Override
    public Collection discoverDestinationConfigs() throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().discoverDestinationConfigs();
    }

    @Override
    public int truncate(DestinationConfig dest) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().truncate(dest);
    }

    @Override
    public Enumeration createBrowserProxy(Enumeration iter) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return this.getAdminAdapter().createBrowserProxy(iter);
    }

    @Override
    public QueueBrowser createRegexBrowser(Destination d, String selector, String regex) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return new RegexQueueBrowser(this.createBrowser(d, selector), regex, false, true);
    }

    @Override
    public QueueBrowser createRegexBrowser(Destination d, String regex) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        return new RegexQueueBrowser(this.createBrowser(d), regex, false, true);
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.getSessionManager().unsubscribe(name);
    }

    @Override
    public DestinationManager getDestinationManager() {
        return this.getSessionManager().getDestinationManager();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hermes) {
            Hermes other = (Hermes)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }
}

