/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix.quickfix;

import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageFilter;
import hermes.fix.FIXReader;
import hermes.fix.MalformedMessageException;
import hermes.fix.quickfix.QuickFIXMessage;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.fix.quickfix.QuickFIXUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FIXInputStreamReader
implements Runnable,
FIXReader {
    private static final Logger log = Logger.getLogger(FIXInputStreamReader.class);
    private ArrayList<FIXMessage> messages = new ArrayList();
    private int maxMessages = 512;
    private int maxMessageBuffer = 524288;
    private byte[] messageBuffer;
    private int messageBufferIndex = 0;
    private byte[] startOfMessage = new byte[]{56, 61, 70, 73, 88};
    private int messageId = 0;
    private boolean keepRunning = true;
    private boolean eofReached = false;
    private InputStream istream;
    private QuickFIXMessageCache cache;
    private FIXMessageFilter filter = new FIXMessageFilter();

    @Override
    public FIXMessageFilter getFilter() {
        return this.filter;
    }

    public FIXInputStreamReader(QuickFIXMessageCache cache, InputStream istream) {
        this.istream = istream;
        this.messageBuffer = new byte[this.maxMessageBuffer];
        this.cache = cache;
        new Thread((Runnable)this, "FIXSniffer").start();
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
        this.keepRunning = false;
        this.eofReached = true;
        try {
            this.istream.close();
        }
        catch (IOException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public FIXMessage read() throws IOException {
        return this.read(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FIXMessage read(long timeout) throws IOException {
        ArrayList<FIXMessage> arrayList = this.messages;
        synchronized (arrayList) {
            while (this.messages.size() == 0) {
                this.checkEOF();
                try {
                    if (timeout == -1L) {
                        this.messages.wait();
                        continue;
                    }
                    if (timeout == 0L) {
                        return null;
                    }
                    this.messages.wait(timeout);
                }
                catch (InterruptedException e) {}
            }
            this.checkEOF();
            if (this.messages.size() > 0) {
                return this.messages.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEOF() throws EOFException {
        ArrayList<FIXMessage> arrayList = this.messages;
        synchronized (arrayList) {
            if (this.messages.size() == 0 && this.eofReached) {
                throw new EOFException("EOF");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            while (true) {
                ArrayList<FIXMessage> arrayList;
                if (!this.keepRunning) break block26;
                try {
                    FIXMessage message = this.readMessage();
                    if (message == null || !this.filter.filter(message.getMsgType())) continue;
                    arrayList = this.messages;
                    synchronized (arrayList) {
                        this.messages.add(message);
                        if (this.messages.size() == 1) {
                            this.messages.notifyAll();
                        }
                    }
                }
                catch (EOFException ex) {
                    this.eofReached = true;
                    arrayList = this.messages;
                    synchronized (arrayList) {
                        this.messages.notifyAll();
                    }
                    return;
                }
                catch (Exception ex) {
                    try {
                        log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (Throwable ex2) {
                        log.error((Object)ex2.getMessage(), ex2);
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.eofReached = true;
                ArrayList<FIXMessage> ex = this.messages;
                synchronized (ex) {
                    this.messages.notifyAll();
                }
            }
        }
    }

    byte readByte(InputStream istream, byte[] bytes, int offset, int length) throws IOException {
        int i = istream.read(bytes, offset, length);
        if (i == -1) {
            this.eofReached = true;
            throw new EOFException("EOF");
        }
        return (byte)i;
    }

    byte readByte(InputStream istream) throws IOException {
        int i = istream.read();
        if (i == -1) {
            this.eofReached = true;
            throw new EOFException("EOF");
        }
        return (byte)i;
    }

    private FIXMessage readMessage() throws IOException, MalformedMessageException, FIXException {
        byte b;
        this.checkEOF();
        while (this.messageBufferIndex < this.startOfMessage.length) {
            b = this.readByte(this.istream);
            if (this.startOfMessage[this.messageBufferIndex] == b) {
                this.messageBuffer[this.messageBufferIndex++] = b;
                continue;
            }
            this.messageBufferIndex = 0;
        }
        while ((b = this.readByte(this.istream)) != 1) {
            this.messageBuffer[this.messageBufferIndex++] = b;
        }
        this.messageBuffer[this.messageBufferIndex] = 0;
        String protocol = new String(this.messageBuffer, 0, this.messageBufferIndex).split("=")[1];
        this.messageBuffer[this.messageBufferIndex++] = 1;
        b = this.readByte(this.istream);
        if (b != 57) {
            throw new MalformedMessageException("Tag 9 does not follow tag 8");
        }
        this.messageBuffer[this.messageBufferIndex++] = b;
        this.messageBuffer[this.messageBufferIndex++] = (byte)this.istream.read();
        byte[] messageLengthBuffer = new byte[16];
        int messageLengthBufferOffset = 0;
        while ((b = this.readByte(this.istream)) != 1) {
            this.messageBuffer[this.messageBufferIndex++] = b;
            messageLengthBuffer[messageLengthBufferOffset++] = b;
        }
        messageLengthBuffer[messageLengthBufferOffset++] = 1;
        this.messageBuffer[this.messageBufferIndex++] = 1;
        String s = new String(messageLengthBuffer).trim();
        int messageLength = Integer.parseInt(s);
        if (messageLength > this.maxMessageBuffer) {
            throw new MalformedMessageException("BodyLength is too big, " + messageLength + " > " + this.maxMessageBuffer);
        }
        this.readByte(this.istream, this.messageBuffer, this.messageBufferIndex, messageLength);
        this.messageBufferIndex += messageLength;
        while ((b = this.readByte(this.istream)) != 1) {
            this.messageBuffer[this.messageBufferIndex++] = b;
        }
        this.messageBuffer[this.messageBufferIndex++] = 1;
        byte[] rval = new byte[this.messageBufferIndex];
        System.arraycopy(this.messageBuffer, 0, rval, 0, this.messageBufferIndex);
        this.messageBufferIndex = 0;
        return new QuickFIXMessage(this.cache, rval, QuickFIXUtils.getDictionary(protocol));
    }
}

