/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import hermes.fix.CompactFIXPrettyPrinter;
import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageViewTable;
import hermes.fix.FIXMessageViewTableModel;
import hermes.fix.FIXPrettyPrinter;
import hermes.util.ByteUtils;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.swing.JComponent;

public class FIXUtils {
    private static FIXPrettyPrinter defaultPrettyPrinter = new CompactFIXPrettyPrinter();
    private static FIXPrettyPrinter prettyPrinter = null;

    public static JComponent createView(FIXMessage message, boolean displayHeaderAndTrailer, boolean displayValueWithEnum) throws FIXException {
        return new FIXMessageViewTable(new FIXMessageViewTableModel(message));
    }

    public static String prettyPrint(FIXMessage message) {
        if (prettyPrinter != null) {
            return prettyPrinter.print(message);
        }
        return defaultPrettyPrinter.print(message);
    }

    public static FIXPrettyPrinter getPrettyPrinter() {
        return prettyPrinter;
    }

    public static void setPrettyPrinter(FIXPrettyPrinter prettyPrinter) {
        FIXUtils.prettyPrinter = prettyPrinter;
    }

    public static FIXPrettyPrinter getDefaultPrettyPrinter() {
        return defaultPrettyPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFIX(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText().startsWith("8=FIX");
        }
        if (message instanceof BytesMessage) {
            try {
                byte[] prefix = new byte[5];
                ((BytesMessage)message).reset();
                ((BytesMessage)message).readBytes(prefix);
                boolean bl = ByteUtils.startsWith(prefix, "8=FIX");
                return bl;
            }
            finally {
                ((BytesMessage)message).reset();
            }
        }
        return false;
    }
}

