/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.weblogic;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.weblogic.WebLogicJMSAdminFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicObjectName;
import weblogic.management.runtime.JMSDestinationRuntimeMBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebLogicJMSAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(WebLogicJMSAdmin.class);
    private final String[] JMS_DEST_MONITOR_ATTRIB_NAMES = new String[]{"BytesCurrentCount", "BytesHighCount", "BytesPendingCount", "BytesReceivedCount", "BytesThresholdTime", "ConsumersCurrentCount", "ConsumersHighCount", "ConsumersTotalCount", "DestinationType", "MessagesCurrentCount", "MessagesHighCount", "MessagesPendingCount", "MessagesReceivedCount", "MessagesThresholdTime"};
    private final String JMS_DEST_NAME_ATTRIB = "Name";
    private final String JMS_DEST_JNDI_NAME_ATTRIB = "JNDIName";
    private final String[] JMS_DEST_CONFIG_ATTRIB_NAMES = new String[]{"Name", "JNDIName"};
    private final String JMX_QUEUE_TYPE = "JMSQueue";
    private final String JMX_TOPIC_TYPE = "JMSTopic";
    private Context context;
    private WebLogicJMSAdminFactory factory;

    public WebLogicJMSAdmin(Hermes hermes, WebLogicJMSAdminFactory factory, Context context) {
        super(hermes);
        this.context = context;
        this.factory = factory;
    }

    @Override
    public synchronized int getDepth(DestinationConfig dConfig) throws JMSException {
        Map stats = this.getStatistics(dConfig);
        Long i1 = (Long)stats.get("MessagesCurrentCount");
        long i2 = i1.intValue();
        return (int)i2;
    }

    @Override
    public void close() throws JMSException {
    }

    @Override
    public synchronized Collection getStatistics(Collection destinations) throws JMSException {
        ArrayList<Map> rval = new ArrayList<Map>();
        Iterator iter = destinations.iterator();
        while (iter.hasNext()) {
            rval.add(this.getStatistics((Destination)iter.next()));
        }
        return rval;
    }

    @Override
    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        try {
            return this.getStatistics(this.getHermes().getDestination(dConfig.getName(), Domain.getDomain(dConfig.getDomain())));
        }
        catch (NamingException ex) {
            throw new HermesException(ex);
        }
    }

    private synchronized Map getStatistics(Destination destination) throws JMSException {
        TreeMap<String, Object> stats = null;
        try {
            JMSDestinationRuntimeMBean bean = this.getMBean(destination);
            AttributeList attributes = bean.getAttributes(this.JMS_DEST_MONITOR_ATTRIB_NAMES);
            stats = new TreeMap<String, Object>();
            for (Attribute attribute : attributes) {
                stats.put(attribute.getName(), attribute.getValue());
            }
            log.debug(stats);
            return stats;
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)"InstanceNotFoundException - ", (Throwable)e);
            throw new HermesException(e);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"MalformedObjectNameException - ", (Throwable)e);
            throw new HermesException(e);
        }
    }

    @Override
    public synchronized Collection discoverDestinationConfigs() throws JMSException {
        if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
            return super.discoverDestinationConfigs();
        }
        MBeanHome home = this.getHome(this.context);
        RemoteMBeanServer homeServer = home.getMBeanServer();
        ObjectName queueMBeanQuery = null;
        ObjectName topicMBeanQuery = null;
        try {
            queueMBeanQuery = this.getJmsQueueMBeanQuery();
            topicMBeanQuery = this.getJmsTopicMBeanQuery();
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"MalformedObjectNameException - ", (Throwable)e);
            throw new RuntimeException(e);
        }
        Collection queues = this.discoverDestinationConfigs((MBeanServer)homeServer, queueMBeanQuery, Domain.QUEUE);
        Collection topics = this.discoverDestinationConfigs((MBeanServer)homeServer, topicMBeanQuery, Domain.TOPIC);
        ArrayList rval = new ArrayList(queues.size() + topics.size());
        rval.addAll(queues);
        rval.addAll(topics);
        return rval;
    }

    private Collection discoverDestinationConfigs(MBeanServer homeServer, ObjectName query, Domain domain) {
        QueryExp queryExpr = null;
        Set<ObjectName> mBeans = null;
        mBeans = homeServer.queryNames(query, queryExpr);
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>(mBeans.size());
        for (ObjectName name : mBeans) {
            log.debug((Object)("Matches to the MBean query: " + name.toString()));
            String jndiName = null;
            String destName = null;
            try {
                AttributeList attributes = homeServer.getAttributes(name, this.JMS_DEST_CONFIG_ATTRIB_NAMES);
                destName = (String)WebLogicJMSAdmin.getAttributeEx((AttributeList)attributes, (String)"Name");
                jndiName = (String)WebLogicJMSAdmin.getAttributeEx((AttributeList)attributes, (String)"JNDIName");
            }
            catch (AttributeNotFoundException e) {
                log.error((Object)"AttributeNotFoundException - ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (InstanceNotFoundException e) {
                log.error((Object)"InstanceNotFoundException - ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (ReflectionException e) {
                log.error((Object)"ReflectionException - ", (Throwable)e);
                throw new RuntimeException(e);
            }
            DestinationConfig dConfig = new DestinationConfig();
            dConfig.setName(jndiName);
            dConfig.setShortName(destName);
            dConfig.setDomain(domain.getId());
            rval.add(dConfig);
        }
        return rval;
    }

    protected MBeanHome getHome(Context context) throws JMSException {
        try {
            log.debug((Object)("JNDI admin binding: " + this.getMBeanHomeJndiName()));
            return (MBeanHome)context.lookup(this.getMBeanHomeJndiName());
        }
        catch (NamingException e) {
            log.error((Object)"NamingException - ", (Throwable)e);
            throw new HermesException(e);
        }
    }

    private JMSDestinationRuntimeMBean getMBean(Destination destination) throws InstanceNotFoundException, MalformedObjectNameException, JMSException {
        MBeanHome home = this.getHome(this.context);
        ObjectName name = this.getJmsDestMBeanName(destination);
        JMSDestinationRuntimeMBean bean = (JMSDestinationRuntimeMBean)home.getMBean(name);
        log.debug((Object)("Found MBean: " + bean));
        return bean;
    }

    private String getMBeanHomeJndiName() {
        return "weblogic.management.home." + this.factory.getWebLogicServer();
    }

    private ObjectName getJmsDestMBeanName(Destination destination) throws MalformedObjectNameException {
        StringBuffer buff = new StringBuffer(this.factory.getWebLogicDomain());
        buff.append(":JMSServerRuntime=");
        buff.append(this.factory.getJmsServer());
        buff.append(",Location=");
        buff.append(this.factory.getWebLogicServer());
        buff.append(",Name=");
        buff.append(destination.toString());
        buff.append(",ServerRuntime=");
        buff.append(this.factory.getWebLogicServer());
        buff.append(",Type=JMSDestinationRuntime");
        String s = buff.toString();
        log.debug((Object)("Constructed JMSDestination MBean name: " + s));
        return new WebLogicObjectName(s);
    }

    private ObjectName getJmsQueueMBeanQuery() throws MalformedObjectNameException {
        return this.getJmsDestMBeanQuery("JMSQueue");
    }

    private ObjectName getJmsTopicMBeanQuery() throws MalformedObjectNameException {
        return this.getJmsDestMBeanQuery("JMSTopic");
    }

    private ObjectName getJmsDestMBeanQuery(String destType) throws MalformedObjectNameException {
        StringBuffer buff = new StringBuffer(this.factory.getWebLogicDomain());
        buff.append(":JMSServer=");
        buff.append(this.factory.getJmsServer());
        buff.append(",Type=");
        buff.append(destType);
        buff.append(",*");
        String s = buff.toString();
        return new ObjectName(s);
    }

    private static Object getAttributeEx(AttributeList attributes, String name) throws AttributeNotFoundException {
        Object o = WebLogicJMSAdmin.getAttribute((AttributeList)attributes, (String)name);
        if (o == null) {
            throw new AttributeNotFoundException("Attribute " + name + " not found.");
        }
        return o;
    }

    private static Object getAttribute(AttributeList attributes, String name) {
        Object rval = null;
        for (Attribute a : attributes) {
            if (!a.getName().equals(name)) continue;
            rval = a.getValue();
        }
        return rval;
    }
}

