/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.Hermes;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationFragmentTreeNode;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreeUtils {
    private static final Logger log = Logger.getLogger(TreeUtils.class);

    public static boolean pathContains(TreePath[] paths, Class clazz) {
        for (int i = 0; i < paths.length; ++i) {
            for (int j = 0; j < paths[i].getPathCount(); ++j) {
                if (!clazz.isAssignableFrom(paths[i].getPath()[j].getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static void add(BrowserTreeModel model, Hermes hermes, String path, String delimiter, AbstractTreeNode root, AbstractTreeNode leaf) {
        AbstractTreeNode currentNode = root;
        StringTokenizer tokens = new StringTokenizer(path, delimiter);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            boolean found = false;
            for (int i = 0; i < currentNode.getChildCount(); ++i) {
                AbstractTreeNode node = (AbstractTreeNode)currentNode.getChildAt(i);
                if (!node.getId().equals(token)) continue;
                if (!tokens.hasMoreTokens()) {
                    currentNode.remove(node);
                    currentNode.add(leaf);
                } else {
                    currentNode = node;
                }
                found = true;
                break;
            }
            if (found) continue;
            if (tokens.hasMoreTokens()) {
                DestinationFragmentTreeNode fragment = new DestinationFragmentTreeNode(hermes, token);
                currentNode.add(fragment);
                model.nodesWereInserted(currentNode, new int[]{currentNode.getIndex(fragment)});
                currentNode = fragment;
                continue;
            }
            currentNode.add(leaf);
            model.nodesWereInserted(currentNode, new int[]{currentNode.getIndex(leaf)});
        }
    }

    public static void expandFully(JTree tree, TreePath path) {
        tree.expandPath(path);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtils.expandFully(tree, path.pathByAddingChild(node.getChildAt(i)));
        }
    }
}

