/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.AbstractOptionDialog;
import hermes.browser.dialog.ConnectionConfigPanel;
import hermes.browser.dialog.ConnectionFactoryConfigPanel;
import hermes.browser.dialog.DestinationConfigPanel;
import hermes.browser.dialog.GeneralConfigPanel;
import hermes.browser.dialog.GeneralRendererConfigPanel;
import hermes.browser.dialog.HermesAdminFactoryConfigPanel;
import hermes.browser.dialog.ProviderConfigPanel;
import hermes.browser.dialog.SessionConfigPanel;
import hermes.config.ConnectionConfig;
import hermes.config.FactoryConfig;
import hermes.config.HermesConfig;
import hermes.config.PropertySetConfig;
import hermes.config.SessionConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Category;

public class PreferencesDialog
extends AbstractOptionDialog {
    private static final Category cat = Category.getInstance(PreferencesDialog.class);
    private HermesConfig model;
    private Map sessionToFactoryMap = new HashMap();
    private Set newFactories = new HashSet();
    private ConnectionFactoryConfigPanel connectionFactoryConfigPanel = new ConnectionFactoryConfigPanel(this);
    private ConnectionConfigPanel connectionConfigPanel = new ConnectionConfigPanel(this);
    private SessionConfigPanel sessionConfigPanel = new SessionConfigPanel(this);
    private DestinationConfigPanel destinationConfigPanel = new DestinationConfigPanel(this);
    private ProviderConfigPanel providerConfigPanel = new ProviderConfigPanel(this);
    private GeneralRendererConfigPanel rendererConfigPanel = new GeneralRendererConfigPanel(this);
    private GeneralConfigPanel generalConfigPanel = new GeneralConfigPanel(this);
    private HermesAdminFactoryConfigPanel adminConfigPanel = new HermesAdminFactoryConfigPanel(this);
    private JideTabbedPane topPanel;
    private JPanel sessionPanel;
    private JPanel factoryPanel;
    private String firstSessionId;
    private String currentSessionId;
    private Component lastSelectedTab;
    private Component currentSelectedTab;

    public String getSelectedLoader() {
        return this.connectionFactoryConfigPanel.getLoader();
    }

    public PreferencesDialog(Frame arg0) throws HeadlessException {
        super(arg0, "Preferences", true);
    }

    public FactoryConfig getFactoryConfigBySessionId(String id) {
        return (FactoryConfig)this.sessionToFactoryMap.get(id);
    }

    public void refocus(String sessionId) {
        cat.debug((Object)("refocusing on " + sessionId));
        this.providerConfigPanel.setHermesConfig(this.model);
        this.generalConfigPanel.setHermesConfig(this.model);
        this.rendererConfigPanel.setHermesConfig(this.model);
        if (sessionId != null && !sessionId.equals("") && !sessionId.equals(this.currentSessionId)) {
            try {
                this.currentSessionId = sessionId;
                FactoryConfig factoryConfig = this.getFactoryConfigBySessionId(sessionId);
                if (factoryConfig == null) {
                    factoryConfig = HermesBrowser.getConfigDAO().createDefaultFactoryConfig(sessionId);
                    factoryConfig.getDestination().addAll(this.destinationConfigPanel.getDestinations());
                    this.sessionToFactoryMap.put(sessionId, factoryConfig);
                    this.newFactories.add(factoryConfig);
                    this.setDirty();
                }
                this.connectionFactoryConfigPanel.setFactoryConfig(this.model, factoryConfig);
                this.destinationConfigPanel.setFactoryConfig(factoryConfig);
                this.connectionConfigPanel.setConnectionConfig(factoryConfig.getConnection().get(0));
                this.sessionConfigPanel.setSessionConfig(this.connectionConfigPanel.getConnectionConfig().getSession().get(0));
                if (this.model.isDisplayFactoryAdmin() && this.adminConfigPanel != null) {
                    this.adminConfigPanel.setConfig(factoryConfig.getClasspathId(), factoryConfig.getExtension());
                }
            }
            catch (Throwable ex) {
                cat.error((Object)ex.getMessage(), ex);
                HermesBrowser.getBrowser().showErrorDialog(ex);
            }
        }
    }

    @Override
    public void init() {
        try {
            this.model = HermesBrowser.getBrowser().getConfig();
            this.topPanel = new JideTabbedPane();
            this.sessionPanel = new JPanel();
            this.factoryPanel = new JPanel();
            for (FactoryConfig factoryConfig : this.model.getFactory()) {
                if (factoryConfig.getConnection().size() == 0) {
                    factoryConfig.getConnection().add(new ConnectionConfig());
                }
                if (factoryConfig.getProvider().getProperties() == null) {
                    factoryConfig.getProvider().setProperties(new PropertySetConfig());
                }
                this.connectionFactoryConfigPanel.setFactoryConfig(this.model, factoryConfig);
                this.destinationConfigPanel.setFactoryConfig(factoryConfig);
                for (ConnectionConfig connectionConfig : factoryConfig.getConnection()) {
                    this.connectionConfigPanel.setConnectionConfig(connectionConfig);
                    for (SessionConfig sessionConfig : connectionConfig.getSession()) {
                        if (this.firstSessionId == null) {
                            this.firstSessionId = sessionConfig.getId();
                        }
                        this.sessionConfigPanel.addSessionConfig(sessionConfig);
                        this.sessionToFactoryMap.put(sessionConfig.getId(), factoryConfig);
                    }
                }
            }
            this.sessionPanel.setLayout(new BorderLayout());
            this.factoryPanel.setLayout(new GridLayout(3, 1));
            if (this.model.isDisplayFactoryAdmin() && this.adminConfigPanel != null) {
                this.factoryPanel.setLayout(new GridLayout(3, 1));
                this.factoryPanel.add(this.adminConfigPanel);
            } else {
                this.factoryPanel.setLayout(new GridLayout(2, 1));
            }
            this.factoryPanel.add(this.connectionFactoryConfigPanel);
            this.factoryPanel.add(this.destinationConfigPanel);
            this.sessionPanel.add((Component)this.sessionConfigPanel, "North");
            this.sessionPanel.add((Component)this.factoryPanel, "Center");
            this.sessionPanel.add((Component)this.connectionConfigPanel, "South");
            this.topPanel.add("Sessions", (Component)this.sessionPanel);
            this.topPanel.add("Providers", (Component)this.providerConfigPanel);
            this.topPanel.add("General", (Component)this.generalConfigPanel);
            if (HermesBrowser.getRendererManager().getRenderers().size() > 0) {
                this.topPanel.add("Renderers", (Component)this.rendererConfigPanel);
            }
            this.topPanel.setTabPlacement(3);
            super.init();
            this.sessionConfigPanel.addListeners();
            this.refocus(this.firstSessionId);
            if (this.model.isDisplayFactoryAdmin()) {
                this.setSize(500, 700);
            } else {
                this.setSize(500, 600);
            }
            this.topPanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    PreferencesDialog.this.lastSelectedTab = PreferencesDialog.this.currentSelectedTab;
                    PreferencesDialog.this.currentSelectedTab = PreferencesDialog.this.topPanel.getSelectedComponent();
                    if (PreferencesDialog.this.lastSelectedTab == PreferencesDialog.this.providerConfigPanel && PreferencesDialog.this.providerConfigPanel.isModelChanged() && JOptionPane.showConfirmDialog(PreferencesDialog.this.providerConfigPanel, "You must apply any changes made to the ClasspathGroups before continuing, apply now?", "Please confirm.", 0) == 0) {
                        PreferencesDialog.this.updateData(true);
                    }
                }
            });
            JideSwingUtilities.centerWindow((Window)this);
        }
        catch (HermesException e) {
            cat.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected void updateData(boolean toModel) {
        if (toModel) {
            this.providerConfigPanel.updateModel();
            this.connectionFactoryConfigPanel.updateModel();
            this.connectionConfigPanel.updateModel();
            this.sessionConfigPanel.updateModel();
            this.rendererConfigPanel.updateModel();
            this.generalConfigPanel.updateModel();
            this.destinationConfigPanel.updateModel();
            if (this.model.isDisplayFactoryAdmin() && this.adminConfigPanel != null) {
                this.adminConfigPanel.updateModel();
            }
            if (this.newFactories.size() > 0) {
                for (FactoryConfig config : this.newFactories) {
                    cat.debug((Object)("new factory config for class=" + config.getProvider().getClassName()));
                    this.model.getFactory().add(config);
                }
                this.newFactories.clear();
            }
            try {
                for (FactoryConfig fConfig : HermesBrowser.getBrowser().getConfig().getFactory()) {
                    ConnectionConfig cConfig = fConfig.getConnection().get(0);
                    Iterator<SessionConfig> iter2 = cConfig.getSession().iterator();
                    while (iter2.hasNext()) {
                        SessionConfig sConfig = iter2.next();
                        if (sConfig.getId() != null && !sConfig.getId().equals("")) continue;
                        iter2.remove();
                    }
                }
            }
            catch (HermesException e) {
                cat.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            try {
                HermesBrowser.getBrowser().backupConfig();
            }
            catch (Exception ex) {
                HermesBrowser.getBrowser().showErrorDialog("Unable to backup the configuration: ", ex);
                cat.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                HermesBrowser.getBrowser().saveConfig();
            }
            catch (Exception ex) {
                HermesBrowser.getBrowser().showErrorDialog("Unable to save this configuration: ", ex);
                try {
                    HermesBrowser.getBrowser().restoreConfig();
                }
                catch (Exception ex2) {
                    HermesBrowser.getBrowser().showErrorDialog("Unable to restore this configuration: ", ex2);
                }
            }
            try {
                HermesBrowser.getBrowser().loadConfig();
            }
            catch (Exception ex) {
                HermesBrowser.getBrowser().showErrorDialog("Unable to load this configuration: ", ex);
                cat.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                this.model = HermesBrowser.getBrowser().getConfig();
            }
            catch (HermesException e) {
                HermesBrowser.getBrowser().showErrorDialog((Throwable)((Object)e));
            }
            this.refocus(this.currentSessionId);
        }
    }

    @Override
    protected Container initBodyPane() {
        if (this.firstSessionId != null) {
            this.refocus(this.firstSessionId);
        }
        return this.topPanel;
    }

    public DestinationConfigPanel getDestinationConfigPanel() {
        return this.destinationConfigPanel;
    }
}

