/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.ui.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import wsattacker.library.intelligentdos.helper.CommonParamItem;

public class CommonParamTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final Vector<CommonParamItem> commonParamItems = new Vector();

    public CommonParamTableModel(int[][] ommonParamItemsArray) {
        for (int[] possibleCommonParam : ommonParamItemsArray) {
            this.commonParamItems.add(new CommonParamItem(possibleCommonParam));
        }
    }

    public CommonParamTableModel(List<CommonParamItem> cpiList) {
        for (CommonParamItem commonParamItem : cpiList) {
            this.commonParamItems.add(commonParamItem);
        }
    }

    @Override
    public int getRowCount() {
        return this.commonParamItems.size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "requests";
            }
            case 1: {
                return "threads";
            }
            case 2: {
                return "millies between requests";
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Integer getValueAt(int rowIndex, int columnIndex) {
        CommonParamItem commonParamItem = this.commonParamItems.get(rowIndex);
        Integer valueAt = 0;
        switch (columnIndex) {
            case 0: {
                valueAt = commonParamItem.getNumberOfRequests();
                break;
            }
            case 1: {
                valueAt = commonParamItem.getNumberOfThreads();
                break;
            }
            case 2: {
                valueAt = commonParamItem.getMilliesBetweenRequests();
                break;
            }
            default: {
                throw new IllegalArgumentException(columnIndex + " is not defined!");
            }
        }
        return valueAt;
    }

    public void add(CommonParamItem commonParamItem) {
        this.commonParamItems.add(commonParamItem);
        TableModelEvent eAddRow = new TableModelEvent(this, -1, 1);
        this.fireTableChanged(eAddRow);
    }

    public void remove(int selectedRow) {
        if (selectedRow < 0 || selectedRow >= this.commonParamItems.size()) {
            throw new IllegalArgumentException("");
        }
        this.commonParamItems.remove(selectedRow);
        TableModelEvent r_remove = new TableModelEvent(this, -1, -1);
        this.fireTableChanged(r_remove);
    }

    public CommonParamItem get(int selectedRow) {
        if (selectedRow < 0 || selectedRow >= this.commonParamItems.size()) {
            throw new IllegalArgumentException("");
        }
        return this.commonParamItems.get(selectedRow);
    }

    public List<CommonParamItem> getItems() {
        return new ArrayList<CommonParamItem>(this.commonParamItems);
    }
}

