/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import wsattacker.plugin.intelligentdos.ui.helper.DefaultValidator;
import wsattacker.plugin.intelligentdos.ui.helper.JButtonStateController;
import wsattacker.plugin.intelligentdos.ui.helper.StringListValidator;

public class ConfigureStringList_NB
extends JPanel {
    private final JButtonStateController jButtonStateController;
    private StringListValidator validator;
    private JButton addBtn;
    private JTextField addTextField;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton removeBtn;

    public ConfigureStringList_NB() {
        this.initComponents();
        this.validator = new DefaultValidator();
        this.jButtonStateController = new JButtonStateController(this.addBtn);
        Document document = this.addTextField.getDocument();
        document.addDocumentListener(this.jButtonStateController);
    }

    public void setValidator(StringListValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("null is not allowed as validator!");
        }
        this.validator = validator;
        this.jButtonStateController.setValidator(validator);
    }

    public List<String> getStringList() {
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            list.add((String)model.get(i));
        }
        return list;
    }

    public void setStringList(List<String> strings) {
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        model.clear();
        for (String string : strings) {
            model.addElement(string);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.addTextField = new JTextField();
        this.removeBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.addBtn = new JButton();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConfigureStringList_NB.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.addTextField.setToolTipText("Valid xml string (e.g. <abc/>)");
        this.removeBtn.setText("remove");
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureStringList_NB.this.removeBtnActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.addBtn.setText("add");
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureStringList_NB.this.addBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.removeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addTextField, -1, 90, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeBtn).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addTextField, -2, -1, -2).addComponent(this.addBtn))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index != -1) {
            DefaultListModel model = (DefaultListModel)this.jList1.getModel();
            model.remove(index);
        }
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        String text = this.addTextField.getText();
        if (this.validator.isValid(text)) {
            model.addElement(text);
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (this.jList1.getSelectedIndex() == -1) {
                this.removeBtn.setEnabled(false);
            } else {
                this.removeBtn.setEnabled(true);
            }
        }
    }
}

