/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.option;

import org.apache.commons.lang3.StringUtils;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.plugin.intelligentdos.ui.option.PerformPersistOptionGUI_NB;

public class PerformPersistOption
extends AbstractOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_PERSIST = "persist";
    public static final String PROP_BASEDIR = "baseDir";
    private boolean persist;
    private String baseDir;

    public PerformPersistOption(String name, String description, String baseDir) {
        super(name, description);
        if (StringUtils.isEmpty((CharSequence)baseDir)) {
            baseDir = "";
            this.persist = false;
        } else {
            this.persist = true;
            this.baseDir = baseDir;
        }
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        if (!this.isValid(baseDir)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", baseDir));
        }
        String oldBaseDir = this.baseDir;
        this.baseDir = baseDir;
        this.firePropertyChange(PROP_BASEDIR, oldBaseDir, baseDir);
    }

    public boolean isValid(String value) {
        return StringUtils.isNotEmpty((CharSequence)value);
    }

    public void parseValue(String value) {
    }

    public String getValueAsString() {
        return null;
    }

    public OptionGUI createOptionGUI() {
        return new PerformPersistOptionGUI_NB(this);
    }
}

