/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.model;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;
import wsattacker.library.intelligentdos.common.Threshold;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.success.SimpleSuccessDecider;
import wsattacker.library.intelligentdos.success.SuccessDecider;
import wsattacker.plugin.intelligentdos.persistence.AttackMetaDataJAXB;
import wsattacker.plugin.intelligentdos.persistence.SuccessfulAttackJAXB;

public class ResultModel {
    private static final String FILENAME_METADATA = "metaData.xml";
    private static final String FILENAME_XML_PLACEHOLDER = "xmlWithPlaceholder.txt";
    private static final String FILENAME_TR_CONTENT = "tamperedContent.xml";
    private static final String FILENAME_URT_CONTENT = "untamperedContent.xml";
    private static final String FILENAME_UTR_DUR = "utrDurationInNano.csv";
    private static final String FILENAME_TR_DUR = "trDurationInNano.csv";
    private static final String FILENAME_TP_DUR = "tpDurationInNano.csv";
    private Date startDate;
    private Date stopDate;
    private List<SuccessfulAttack> attacks = Lists.newArrayList();
    private List<DoSAttack> notPossible = Lists.newArrayList();
    private List<Threshold> thresholds = Lists.newArrayList();
    private double maximumRequestsPerSecond;
    private static SuccessDecider successDecider = new SimpleSuccessDecider();

    public ResultModel() {
    }

    public ResultModel(List<SuccessfulAttack> attacks) {
        this.attacks = attacks;
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return new Date(this.startDate.getTime());
        }
        return null;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate != null ? new Date(startDate.getTime()) : null;
    }

    public Date getStopDate() {
        if (this.stopDate != null) {
            return new Date(this.stopDate.getTime());
        }
        return null;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate != null ? new Date(stopDate.getTime()) : null;
    }

    public long getAttackDurationInSeconds() {
        if (this.startDate == null || this.stopDate == null) {
            return 0L;
        }
        return (this.stopDate.getTime() - this.startDate.getTime()) / 1000L;
    }

    public List<SuccessfulAttack> getAttacks() {
        return this.attacks;
    }

    public List<DoSAttack> getNotPossible() {
        return this.notPossible;
    }

    public void setNotPossible(List<DoSAttack> notPossibleList) {
        this.notPossible = notPossibleList;
    }

    public List<Threshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<Threshold> thresholds) {
        this.thresholds = thresholds;
    }

    public double getMaximumRequestsPerSecond() {
        return this.maximumRequestsPerSecond;
    }

    public void setMaximumRequestsPerSecond(double maximumRequestsPerSecond) {
        this.maximumRequestsPerSecond = maximumRequestsPerSecond;
    }

    public void save(File selectedFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(selectedFile);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            this.createAttackMetaData(zipOutputStream, FILENAME_METADATA);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        int index = 1;
        for (SuccessfulAttack sa : this.attacks) {
            ZipEntry zipEntry = new ZipEntry(sa.getDoSAttack().getName() + "_a" + index + ".zip");
            zipOutputStream.putNextEntry(zipEntry);
            ZipOutputStream innerZipOutputStream = new ZipOutputStream(zipOutputStream);
            try {
                this.persistSA(sa, innerZipOutputStream);
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
            innerZipOutputStream.finish();
            zipOutputStream.closeEntry();
            ++index;
        }
        zipOutputStream.close();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readIn(File file) {
        this.attacks = Lists.newArrayList();
        ZipInputStream stream = null;
        try {
            ZipEntry entry;
            stream = new ZipInputStream(new FileInputStream(file));
            while ((entry = stream.getNextEntry()) != null) {
                if (FILENAME_METADATA.equals(entry.getName())) {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AttackMetaDataJAXB.class});
                    Unmarshaller um = context.createUnmarshaller();
                    AttackMetaDataJAXB amjaxb = (AttackMetaDataJAXB)um.unmarshal((InputStream)new CloseShieldInputStream((InputStream)stream));
                    ResultModel r = amjaxb.toResultModel();
                    this.setStartDate(r.getStartDate());
                    this.setStopDate(r.getStopDate());
                    this.setMaximumRequestsPerSecond(r.getMaximumRequestsPerSecond());
                    this.setNotPossible(r.getNotPossible());
                    this.setThresholds(r.getThresholds());
                    continue;
                }
                this.attacks.add(this.readIn(stream));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void persistSA(SuccessfulAttack sa, ZipOutputStream zipOutputStream) throws IOException, JAXBException {
        this.createMetaData(zipOutputStream, FILENAME_METADATA, sa);
        this.createXMLContentEntry(zipOutputStream, FILENAME_XML_PLACEHOLDER, sa.getXmlWithPlaceholder());
        this.createMetricEntry(zipOutputStream, FILENAME_UTR_DUR, sa.getUntamperedMetrics());
        this.createXMLContentEntry(zipOutputStream, FILENAME_URT_CONTENT, sa.getUntamperedContent());
        this.createMetricEntry(zipOutputStream, FILENAME_TR_DUR, sa.getTamperedMetrics());
        this.createXMLContentEntry(zipOutputStream, FILENAME_TR_CONTENT, sa.getTamperedContent());
        this.createMetricEntry(zipOutputStream, FILENAME_TP_DUR, sa.getTestProbes());
    }

    private void createAttackMetaData(ZipOutputStream zipOutputStream, String name) throws IOException, JAXBException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOutputStream.putNextEntry(zipEntry);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AttackMetaDataJAXB.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        AttackMetaDataJAXB fromResultModel = AttackMetaDataJAXB.fromResultModel(this);
        m.marshal((Object)fromResultModel, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private void createMetaData(ZipOutputStream zipOutputStream, String name, SuccessfulAttack successfulAttack) throws IOException, JAXBException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOutputStream.putNextEntry(zipEntry);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SuccessfulAttackJAXB.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        SuccessfulAttackJAXB fromAttackModel = SuccessfulAttackJAXB.fromAttackModel(successfulAttack);
        m.marshal((Object)fromAttackModel, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private void createXMLContentEntry(ZipOutputStream zipOutputStream, String name, String requestContent) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(requestContent.getBytes(Charset.defaultCharset()));
        zipOutputStream.closeEntry();
    }

    private void createMetricEntry(ZipOutputStream zipOutputStream, String name, List<Metric> metrics) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOutputStream.putNextEntry(zipEntry);
        int count = 0;
        for (Metric metric : metrics) {
            if (count++ != 0) {
                zipOutputStream.write(10);
            }
            zipOutputStream.write(String.valueOf(metric.getDuration()).getBytes(Charset.defaultCharset()));
        }
        zipOutputStream.closeEntry();
    }

    private SuccessfulAttack readIn(ZipInputStream stream) throws IOException, JAXBException {
        ZipEntry entry;
        ZipInputStream inputStream = new ZipInputStream(stream);
        SuccessfulAttack sa = null;
        String xmlWithPlaceholder = "";
        String utrContent = "";
        String trContent = "";
        List<Object> utrMetrics = Lists.newArrayList();
        List<Object> trMetrics = Lists.newArrayList();
        List<Object> tpMetrics = Lists.newArrayList();
        while ((entry = inputStream.getNextEntry()) != null) {
            if (FILENAME_METADATA.equals(entry.getName())) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SuccessfulAttackJAXB.class});
                Unmarshaller um = context.createUnmarshaller();
                SuccessfulAttackJAXB amjaxb = (SuccessfulAttackJAXB)um.unmarshal((InputStream)new CloseShieldInputStream((InputStream)inputStream));
                sa = amjaxb.toSuccessfulAttack();
                continue;
            }
            if (FILENAME_UTR_DUR.equals(entry.getName())) {
                utrMetrics = ResultModel.streamToMetric(inputStream);
                continue;
            }
            if (FILENAME_TR_DUR.equals(entry.getName())) {
                trMetrics = ResultModel.streamToMetric(inputStream);
                continue;
            }
            if (FILENAME_TP_DUR.equals(entry.getName())) {
                tpMetrics = ResultModel.streamToMetric(inputStream);
                continue;
            }
            if (FILENAME_XML_PLACEHOLDER.equals(entry.getName())) {
                xmlWithPlaceholder = IOUtils.toString((InputStream)inputStream);
                continue;
            }
            if (FILENAME_URT_CONTENT.equals(entry.getName())) {
                utrContent = IOUtils.toString((InputStream)inputStream);
                continue;
            }
            if (!FILENAME_TR_CONTENT.equals(entry.getName())) continue;
            trContent = IOUtils.toString((InputStream)inputStream);
        }
        if (sa != null) {
            sa.setXmlWithPlaceholder(xmlWithPlaceholder);
            sa.setUntamperedContent(utrContent);
            sa.setTamperedContent(trContent);
            Long[] run1 = new Long[utrMetrics.size()];
            Long[] run2 = new Long[trMetrics.size()];
            int index = 0;
            for (Metric metric : utrMetrics) {
                sa.getUntamperedMetrics().add(metric);
                run1[index++] = metric.getDuration();
            }
            index = 0;
            for (Metric metric : trMetrics) {
                sa.getTamperedMetrics().add(metric);
                run2[index++] = metric.getDuration();
            }
            for (Metric metric : tpMetrics) {
                sa.getTestProbeMetrics().add(metric);
            }
            sa.setEfficiency(successDecider.getEfficency(run1, run2));
            sa.setRatio(successDecider.calculateRatio(run1, run2));
        }
        return sa;
    }

    private static List<Metric> streamToMetric(ZipInputStream inputStream) throws IOException {
        ArrayList<Metric> list = new ArrayList<Metric>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.defaultCharset()));
        String data = null;
        while ((data = reader.readLine()) != null) {
            try {
                long parseLong = Long.parseLong(data.split(",")[0]);
                Metric metric = new Metric();
                metric.setDuration(parseLong);
                list.add(metric);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

