/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos;

import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import wsattacker.library.intelligentdos.IntelligentDoSLibrary;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.CommonParamItem;
import wsattacker.library.intelligentdos.position.MatcherPositionIterator;
import wsattacker.library.intelligentdos.position.PositionIterator;
import wsattacker.library.intelligentdos.success.SimpleSuccessDecider;
import wsattacker.library.intelligentdos.success.SuccessDecider;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.schemaanalyzer.SchemaAnalyzerFactory;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginFunctionInterface;
import wsattacker.main.composition.plugin.PluginObserver;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.plugin.intelligentdos.listener.PersistAttackListener;
import wsattacker.plugin.intelligentdos.option.ConfigureAttacksOption;
import wsattacker.plugin.intelligentdos.option.SchemaAnalyzerOption;
import wsattacker.plugin.intelligentdos.postanalyze.IntelligentDoSPostAnalyzeFunction;
import wsattacker.plugin.intelligentdos.requestSender.Http4RequestSenderImpl;
import wsattacker.plugin.intelligentdos.ui.DoSStatusFrame;
import wsattacker.plugin.intelligentdos.worker.IntelligentDoSWorker;

public class IntelligentDoS
extends AbstractPlugin
implements PluginObserver {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(IntelligentDoS.class);
    private static final String NAME = "Adaptive Intelligent Denial-of-Service";
    private static final URL logoPath = IntelligentDoS.class.getResource("/images/logo_red.png");
    private static final String DESCRIPTION = "<html><p>The Adaptive Intelligent Denial-of-Service (AdIDoS) attack is a composite of various DoS attacks. With these attack a given Web service can be fully-automatically testes for DoS weaknesses. The following DoS attacks can be chosen and configured individually:</p><ul><li>CoerciveParsing</li><li>XML Element Count</li><li>XML Attribute Count</li><li>XML Entity Expansion</li><li>XML External Entity</li><li>Hash Collision</li><li>XML Overlong Names</li></ul><p>The common parameters adjust the agressivnes by which the Web service is tested.The selected attacks are performed fully-automatically, whereby the attack vectors are adaptively adjusted. The Intelligent Denial-of-Service attack replaces the string $$PAYLOADELEMENT$$ and $$PAYLOADATTR$$ in the SOAP message below successively with the attack payload. The placeholders $$PAYLOADELEMENT$$ and $$PAYLOADATTR$$ can be set to any other position in the SOAP message.</p></html>";
    private static final String AUTHOR = "Christian Altmeier";
    private static final String VERSION = "1.0 / 2015-07-10";
    private static final String[] CATEGORY = new String[]{"Denial of Service"};
    private static final SchemaAnalyzer schemaAnalyzer = SchemaAnalyzerFactory.getInstance((String)"Web Service");
    private ConfigureAttacksOption configureLibraryOption;
    private OptionSimpleBoolean optionSimpleBoolean;
    private SchemaAnalyzerOption payloadPlaceholders;
    private transient IntelligentDoSLibrary intelligentDoSLibrary;
    private transient IntelligentDoSWorker doSWorker;
    private DoSStatusFrame doSStatusFrame;

    public void initializePlugin() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        this.setAuthor(AUTHOR);
        this.setVersion(VERSION);
        this.setCategory(CATEGORY);
        ImageIcon icon = new ImageIcon(logoPath);
        this.setIcon(icon);
        this.setState(PluginState.Ready);
        this.configureLibraryOption = new ConfigureAttacksOption(IntelligentDoSLibraryImpl.getAllAttacks(), IntelligentDoSLibraryImpl.COMMONPARAMS, 20000, Http4RequestSenderImpl.TIMEOUT);
        this.getPluginOptions().add((AbstractOption)this.configureLibraryOption);
        this.optionSimpleBoolean = new OptionSimpleBoolean("Use namespaces?", false, "checked = attributes with namespace, unchecked = attributes without namespace");
        this.getPluginOptions().add((AbstractOption)this.optionSimpleBoolean);
        this.payloadPlaceholders = new SchemaAnalyzerOption("Message", "set position of payload placeholder", schemaAnalyzer);
        this.getPluginOptions().add((AbstractOption)this.payloadPlaceholders);
    }

    public void clean() {
        this.setState(PluginState.Ready);
    }

    public boolean wasSuccessful() {
        return this.getCurrentPoints() > 1;
    }

    public void attackImplementationHook(RequestResponsePair original) {
        DoSAttack[] dosAttackArray = this.configureLibraryOption.getAttacks();
        List<CommonParamItem> commonParamList = this.configureLibraryOption.getCommonParamList();
        int serverRecoveryTime = this.configureLibraryOption.getServerRecoveryTime();
        int httpConnectionTimeout = this.configureLibraryOption.getHttpConnectionTimeout();
        if (this.optionSimpleBoolean.isOn()) {
            for (DoSAttack doSAttack : dosAttackArray) {
                doSAttack.setUseNamespace(this.optionSimpleBoolean.isOn());
            }
        }
        logger.trace((Object)("httpConnectionTimeout: " + httpConnectionTimeout));
        Http4RequestSenderImpl.setHttpConnectionTimeout(httpConnectionTimeout);
        String xmlMessage = original.getWsdlRequest().getRequestContent();
        MatcherPositionIterator positionIterator = new MatcherPositionIterator(this.payloadPlaceholders.getValue());
        this.intelligentDoSLibrary = IntelligentDoSLibraryImpl.create().withXmlMessage(xmlMessage).withPositionIterator((PositionIterator)positionIterator).withAttacks(dosAttackArray).withSuccessDecider((SuccessDecider)new SimpleSuccessDecider()).withCommonParams(commonParamList).withServerRecoveryTime(serverRecoveryTime).build();
        this.intelligentDoSLibrary.initialize();
        this.doSWorker = new IntelligentDoSWorker(this.intelligentDoSLibrary);
        String property = System.getProperty("persist.attack.dir");
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.doSWorker.addListener(new PersistAttackListener(property));
        }
        IntelligentDoSPostAnalyzeFunction function = new IntelligentDoSPostAnalyzeFunction(this.doSWorker);
        this.setPluginFunctions(new PluginFunctionInterface[]{function});
        this.addPluginObserver(this);
        this.doSStatusFrame = new DoSStatusFrame();
        this.doSStatusFrame.setVisible(true);
        this.doSWorker.addListener(this.doSStatusFrame);
        this.doSWorker.startAttack(original);
        this.doSStatusFrame.dispose();
        List successfulAttacks = this.intelligentDoSLibrary.getSuccessfulAttacks();
        int currentPoints = (int)(100.0 / (double)dosAttackArray.length * (double)successfulAttacks.size() * 1.0);
        if (currentPoints >= this.getMaxPoints()) {
            this.setCurrentPoints(this.getMaxPoints());
        } else {
            this.setCurrentPoints(currentPoints);
        }
    }

    public void restoreConfiguration(AbstractPlugin plugin) {
    }

    public void currentPointsChanged(AbstractPlugin plugin, int newPoints) {
    }

    public void pluginStateChanged(AbstractPlugin plugin, PluginState newState, PluginState oldState) {
        if (plugin == this) {
            this.doSWorker.stopAttack();
            this.doSStatusFrame.dispose();
        }
    }
}

