/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping.option;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.signature.SignatureManager;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionMultiFiles;
import wsattacker.main.composition.testsuite.CurrentRequestContentChangeObserver;
import wsattacker.main.plugin.PluginOptionContainer;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.main.plugin.option.OptionSimpleMultiFiles;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.main.plugin.option.OptionSoapAction;
import wsattacker.plugin.signatureWrapping.SignatureWrapping;
import wsattacker.plugin.signatureWrapping.option.OptionPayload;
import wsattacker.plugin.signatureWrapping.option.OptionViewButton;

public class OptionManager
implements CurrentRequestContentChangeObserver,
PropertyChangeListener {
    private SignatureWrapping plugin;
    private SignatureManager signatureManager;
    private final OptionSoapAction optionSoapAction = new OptionSoapAction("Change\nAction?", "Allows to change the SoapAction Header.");
    private final OptionSimpleBoolean optionMustContainString;
    private final OptionSimpleBoolean optionNoSchema;
    private final OptionSimpleBoolean abortOnFirstSuccess;
    private final OptionSimpleVarchar optionTheContainedString;
    private final OptionSimpleMultiFiles optionSchemaFiles = new OptionSimpleMultiFiles("Used\nSchema\nfiles", "Set the Schema Files.\nSoap11, Soap12, WSA, WSSE, WSU, DS and XPathFilter2\nare included by default.");
    private final OptionViewButton optionView;
    private final List<OptionPayload> optionPayloadList;
    private boolean working = false;
    private static final OptionManager INSTANCE = new OptionManager();

    public static OptionManager getInstance() {
        return INSTANCE;
    }

    public SignatureWrapping getPlugin() {
        return this.plugin;
    }

    public void setPlugin(SignatureWrapping plugin) {
        if (this.plugin != null) {
            this.plugin.getPluginOptions().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.plugin = plugin;
        if (plugin != null) {
            this.plugin.getPluginOptions().addPropertyChangeListener((PropertyChangeListener)this);
            this.plugin.getPluginOptions().setOptions(this.addConfigOptions());
        }
    }

    public SignatureManager getSignatureManager() {
        return this.signatureManager;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    private OptionManager() {
        this.optionMustContainString = new OptionSimpleBoolean("Search?", false, "SOAP Response must contain a specific String.");
        this.abortOnFirstSuccess = new OptionSimpleBoolean("Abort?", true, "Abort after first successful attack message.");
        this.optionTheContainedString = new OptionSimpleVarchar("Contains", "Search for this String...", 200);
        this.optionNoSchema = new OptionSimpleBoolean("Schema?", false, "Turn on, to not use any XML Schema.");
        this.optionPayloadList = new ArrayList<OptionPayload>();
        this.optionView = new OptionViewButton();
        this.optionMustContainString.addPropertyChangeListener("on", (PropertyChangeListener)this);
        this.optionSchemaFiles.addPropertyChangeListener("files", (PropertyChangeListener)this);
        this.optionNoSchema.addPropertyChangeListener("on", (PropertyChangeListener)this);
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public void currentRequestContentChanged(String newContent, String oldContent) {
        if (!this.working) {
            Document domDoc;
            this.working = true;
            this.log().trace((Object)"Current Request Content Changed");
            try {
                domDoc = DomUtilities.stringToDom((String)newContent);
            }
            catch (SAXException e) {
                this.getSignatureManager().setDocument(null);
                this.working = false;
                return;
            }
            this.getSignatureManager().setDocument(domDoc);
            for (int i = 0; i < this.optionPayloadList.size(); ++i) {
                OptionPayload option = this.optionPayloadList.get(i);
                option.removePropertyChangeListener(this);
            }
            this.optionPayloadList.clear();
            for (Payload payload : this.getSignatureManager().getPayloads()) {
                payload.addPropertyChangeListener((PropertyChangeListener)this);
                OptionPayload newPayload = new OptionPayload(payload);
                this.optionPayloadList.add(newPayload);
            }
            List<AbstractOption> allOptions = this.addConfigOptions();
            allOptions.addAll(this.optionPayloadList);
            if (this.plugin != null) {
                this.plugin.getPluginOptions().setOptions(allOptions);
            }
            this.working = false;
        }
    }

    public void noCurrentRequestcontent() {
        if (this.working) {
            return;
        }
        this.working = true;
        this.log().trace((Object)"No Current Message");
        this.getSignatureManager().setDocument(null);
        this.clearOptions();
        this.working = false;
    }

    private List<AbstractOption> addConfigOptions() {
        List<AbstractOption> result;
        if (this.getPlugin() == null) {
            this.log().debug((Object)"No plugin set?");
            result = Collections.emptyList();
        } else {
            ArrayList<AbstractOption> newOptions = new ArrayList<AbstractOption>();
            this.log().info((Object)"Adding optionSoapAction");
            newOptions.add(0, (AbstractOption)this.optionSoapAction);
            this.log().info((Object)"Adding abortOnFirstSuccess");
            newOptions.add(1, (AbstractOption)this.abortOnFirstSuccess);
            this.log().info((Object)"Adding optionNoSchema");
            newOptions.add(2, (AbstractOption)this.optionNoSchema);
            this.log().info((Object)"Adding optionSchemaFiles");
            newOptions.add(3, (AbstractOption)this.optionSchemaFiles);
            this.log().info((Object)"Adding optionMustContainString");
            newOptions.add(4, (AbstractOption)this.optionMustContainString);
            if (this.optionPayloadList.size() > 0) {
                this.log().info((Object)"Adding View Button");
                newOptions.add(5, this.optionView);
            }
            if (this.optionMustContainString.isOn()) {
                this.log().info((Object)"Adding optionTheContainedString");
                newOptions.add(5, (AbstractOption)this.optionTheContainedString);
            }
            result = newOptions;
        }
        return result;
    }

    public List<AbstractOption> popOptionsUpTo(AbstractOption needle) {
        AbstractOption last;
        ArrayList<AbstractOption> result = new ArrayList<AbstractOption>();
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        if (!container.contains(needle)) {
            return result;
        }
        while (container.size() > 0 && (last = container.getByIndex(container.size() - 1)) != needle) {
            container.remove(last);
            result.add(last);
        }
        this.log().info((Object)("Popped: " + ((Object)result).toString()));
        return result;
    }

    public void putOptions(List<AbstractOption> optionList) {
        this.log().info((Object)("Put: " + optionList.toString()));
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        for (int i = optionList.size() - 1; i >= 0; --i) {
            container.add(optionList.get(i));
        }
    }

    public void clearOptions() {
        if (this.getPlugin() == null) {
            this.log().debug((Object)"No plugin set?");
        } else {
            this.log().info((Object)"Clearing Options..");
            PluginOptionContainer container = this.getPlugin().getPluginOptions();
            while (container.size() > 0) {
                container.remove(container.getByIndex(0));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        PluginOptionContainer container = this.getPlugin().getPluginOptions();
        if (pce.getSource() instanceof OptionPayload) {
            this.plugin.checkState();
        } else if (pce.getSource() == this.optionMustContainString) {
            this.log().info((Object)"option == optionMustContainString");
            if (this.optionMustContainString.isOn() && !container.contains((AbstractOption)this.optionTheContainedString)) {
                this.log().info((Object)"true == optionMustContainString.isOn()");
                container.add(1 + container.indexOf((AbstractOption)this.optionMustContainString), (AbstractOption)this.optionTheContainedString);
            } else if (container.contains((AbstractOption)this.optionTheContainedString)) {
                this.log().info((Object)"false == optionMustContainString.isOn()");
                container.remove((AbstractOption)this.optionTheContainedString);
            }
        } else if (pce.getSource() == this.optionSchemaFiles) {
            this.plugin.setUsedSchemaFiles(this.optionSchemaFiles.getFiles());
        } else if (pce.getSource() == this.optionNoSchema) {
            this.log().info((Object)"Remove Schema Files Option");
            if (this.optionNoSchema.isOn() && container.contains((AbstractOption)this.optionSchemaFiles)) {
                container.remove((AbstractOption)this.optionSchemaFiles);
                this.plugin.setSchemaAnalyzerDepdingOnOption();
            } else if (!container.contains((AbstractOption)this.optionSchemaFiles)) {
                this.log().info((Object)"Add Schema Files Option");
                container.add(1 + container.indexOf((AbstractOption)this.optionNoSchema), (AbstractOption)this.optionSchemaFiles);
            }
        }
        this.getPlugin().checkState();
    }

    public OptionSoapAction getOptionSoapAction() {
        return this.optionSoapAction;
    }

    public AbstractOptionMultiFiles getOptionSchemaFiles() {
        return this.optionSchemaFiles;
    }

    public OptionSimpleBoolean getOptionMustContainString() {
        return this.optionMustContainString;
    }

    public OptionSimpleBoolean getOptionNoSchema() {
        return this.optionNoSchema;
    }

    public OptionSimpleBoolean getAbortOnFirstSuccess() {
        return this.abortOnFirstSuccess;
    }

    public OptionSimpleVarchar getOptionTheContainedString() {
        return this.optionTheContainedString;
    }
}

