/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.util;

public final class CryptoConstants {
    public static final int AES_BLOCK_SIZE = 16;
    public static final int DES_BLOCK_SIZE = 8;

    private CryptoConstants() {
    }

    public static Algorithm getAlgorithm(String xmlencConstant) {
        switch (xmlencConstant) {
            case "http://www.w3.org/2001/04/xmlenc#aes128-cbc": {
                return Algorithm.CBC_AES128;
            }
            case "http://www.w3.org/2001/04/xmlenc#aes192-cbc": {
                return Algorithm.CBC_AES192;
            }
            case "http://www.w3.org/2001/04/xmlenc#aes256-cbc": {
                return Algorithm.CBC_AES256;
            }
            case "http://www.w3.org/2001/04/xmlenc#tripledes-cbc": {
                return Algorithm.CBC_3DES;
            }
        }
        return null;
    }

    public static enum Algorithm {
        CBC_3DES(8, 24, "3DES/CBC/NoPadding", "3DES"),
        CBC_AES128(16, 16, "AES/CBC/NoPadding", "AES"),
        CBC_AES192(16, 24, "AES/CBC/NoPadding", "AES"),
        CBC_AES256(16, 32, "AES/CBC/NoPadding", "AES");

        public int BLOCK_SIZE;
        public int KEY_SIZE;
        public String JAVA_NAME;
        public String KEY_SPEC_NAME;

        private Algorithm(int blockSize, int keyLength, String javaName, String keySpecName) {
            this.BLOCK_SIZE = blockSize;
            this.KEY_SIZE = keyLength;
            this.JAVA_NAME = javaName;
            this.KEY_SPEC_NAME = keySpecName;
        }
    }
}

