/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.xpath.XPathExpressionException;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class TimestampFilter
extends AbstractDetectionFilter {
    public TimestampFilter(DetectFilterEnum filterType) {
        this.mFilterType = filterType;
        this.m_OutputFilter = new TimestampInfo(filterType);
    }

    @Override
    public AbstractDetectionInfo process() {
        try {
            this.detectTimestampElement();
        }
        catch (XPathExpressionException ex) {
            LOG.warn((Object)("Timestamp detection not executed : " + ex.getMessage()));
        }
        catch (ParseException ex) {
            LOG.error((Object)ex);
        }
        return (TimestampInfo)this.m_OutputFilter;
    }

    private void detectTimestampElement() throws XPathExpressionException, ParseException {
        List timestampList = DomUtilities.evaluateXPath((Document)this.m_InputFilter, (String)"//*[local-name()='Timestamp' and namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd']");
        if (1 == timestampList.size()) {
            TimestampElement timestamp = new TimestampElement((Element)timestampList.get(0));
            ((TimestampInfo)this.m_OutputFilter).setTimestamp(timestamp);
            this.detectTimeDifference();
        } else if (1 < timestampList.size()) {
            LOG.warn((Object)"multiple timestamps not supported yet");
        }
    }

    private void detectTimeDifference() throws ParseException {
        Object dateFormat;
        boolean inMilliseconds;
        TimestampElement timestamp = ((TimestampInfo)this.m_OutputFilter).getTimestamp();
        Element createdEl = timestamp.getCreatedElement();
        Element expiresEl = timestamp.getExpiresElement();
        boolean bl = inMilliseconds = createdEl.getTextContent().indexOf(46) > 0;
        if (inMilliseconds) {
            timestamp.setIsMillisecondTime(true);
            dateFormat = new XmlSchemaDateFormat();
        } else {
            timestamp.setIsMillisecondTime(false);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)dateFormat).setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Calendar created = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        created.setTime(((DateFormat)dateFormat).parse(createdEl.getTextContent()));
        expires.setTime(((DateFormat)dateFormat).parse(expiresEl.getTextContent()));
        int diff = (int)((expires.getTimeInMillis() - created.getTimeInMillis()) / 1000L);
        timestamp.setTimeDifference(diff);
    }
}

