/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager;

import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.AvoidedDocErrorFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.TimestampFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.XMLEncryptionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.XMLSignatureFilter;

public class FactoryFilter {
    private FactoryFilter() {
    }

    public static AbstractDetectionFilter createFilter(DetectFilterEnum filterType) {
        switch (filterType) {
            case SIGNATUREFILTER: {
                return new XMLSignatureFilter(filterType);
            }
            case ENCRYPTIONFILTER: {
                return new XMLEncryptionFilter(filterType);
            }
            case AVOIDDOCFILTER: {
                return new AvoidedDocErrorFilter(filterType);
            }
            case TIMESTAMPFILTER: {
                return new TimestampFilter(filterType);
            }
        }
        throw new IllegalArgumentException("No valid FilterType!");
    }
}

