/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.util.SimStringStrategyFactory;
import wsattacker.library.xmlutilities.dom.DomUtilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="OracleResponseCollector")
public class OracleResponseCollector {
    @XmlElement(name="OracleResponse", type=OracleResponse.class)
    private List<OracleResponse> m_OracleResponseMap = new ArrayList<OracleResponse>();
    private double m_CompareThreshold;
    private boolean m_IsIgnorePayloadResponse;

    public OracleResponseCollector(List<OracleResponse> respList) {
        this.m_OracleResponseMap = respList;
        this.m_CompareThreshold = 1.0;
        this.m_IsIgnorePayloadResponse = false;
    }

    public OracleResponseCollector() {
        this.m_CompareThreshold = 1.0;
        this.m_IsIgnorePayloadResponse = false;
    }

    public List<OracleResponse> getData() {
        return this.m_OracleResponseMap;
    }

    public OracleResponse getDataEntry(int i) {
        return this.m_OracleResponseMap.get(i);
    }

    public boolean add(OracleResponse data) {
        InterfaceStringMetric simStringStrategy = SimStringStrategyFactory.createSimStringStrategy(SimStringStrategyFactory.SimStringStrategy.DICE_COEFF);
        double tempScore = 0.0;
        for (int i = 0; this.m_OracleResponseMap.size() > i; ++i) {
            tempScore = simStringStrategy.getSimilarity(data.getResponse(), this.getDataEntry(i).getResponse());
            if (!(this.m_CompareThreshold <= tempScore)) continue;
            return false;
        }
        this.m_OracleResponseMap.add(data);
        return true;
    }

    public boolean checkIsRequestResponse(OracleResponse oresponse, AbstractEncryptionElement pay) throws SAXException, XPathExpressionException {
        Document responseDoc = DomUtilities.stringToDom((String)oresponse.getResponse());
        List encPayList = DomUtilities.evaluateXPath((Document)responseDoc, (String)"//*[local-name()='EncryptedData' and namespace-uri()='http://www.w3.org/2001/04/xmlenc#']");
        for (Element payEl : encPayList) {
            if (!pay.getEncryptedElement().isEqualNode(payEl)) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnorePayloadResponse() {
        return this.m_IsIgnorePayloadResponse;
    }

    public void setIsIgnorePayloadResponse(boolean isIgnorePayloadResponse) {
        this.m_IsIgnorePayloadResponse = isIgnorePayloadResponse;
    }

    public double getCompareThreshold() {
        return this.m_CompareThreshold;
    }

    public void setCompareThreshold(double compareThreshold) {
        this.m_CompareThreshold = compareThreshold;
    }

    public void setData(List<OracleResponse> respList) {
        this.m_OracleResponseMap = respList;
    }
}

