/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.pkcs1;

import java.math.BigInteger;
import java.util.List;

public final class AttackerUtility {
    private AttackerUtility() {
    }

    public static int findGCD(int a, int b) {
        if (b == 0) {
            return a;
        }
        return AttackerUtility.findGCD(b, a % b);
    }

    public static BigInteger findGCD(BigInteger a, BigInteger b) {
        if (b.compareTo(BigInteger.ZERO) == 0) {
            return a;
        }
        return AttackerUtility.findGCD(b, a.mod(b));
    }

    public static int findLCM(int a, int b) {
        int num2;
        int num1;
        int result = 0;
        if (a > b) {
            num1 = a;
            num2 = b;
        } else {
            num1 = b;
            num2 = a;
        }
        for (int i = 1; i <= num2; ++i) {
            if (num1 * i % num2 != 0) continue;
            result = i * num1;
        }
        return result;
    }

    public static BigInteger findLCM(BigInteger ba, BigInteger bb) {
        long num2;
        long num1;
        long b;
        BigInteger result = BigInteger.ZERO;
        long a = ba.longValue();
        if (a > (b = bb.longValue())) {
            num1 = a;
            num2 = b;
        } else {
            num1 = b;
            num2 = a;
        }
        int i = 1;
        while ((long)i <= num2) {
            if (num1 * (long)i % num2 == 0L) {
                result = BigInteger.valueOf((long)i * num1);
            }
            ++i;
        }
        return result;
    }

    public static BigInteger findLCM(List<BigInteger> numbers) {
        BigInteger result = numbers.get(0);
        for (int i = 1; i < numbers.size(); ++i) {
            result = AttackerUtility.findLCM(result, numbers.get(i));
        }
        return result;
    }

    public static byte[] correctSize(byte[] array, int blockSize, boolean removeSignByte) {
        byte[] tmp;
        int remainder = array.length % blockSize;
        byte[] result = array;
        if (removeSignByte && remainder > 0 && result[0] == 0) {
            tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
            remainder = tmp.length % blockSize;
        }
        if (remainder > 0) {
            tmp = new byte[result.length + blockSize - remainder];
            System.arraycopy(result, 0, tmp, blockSize - remainder, result.length);
            result = tmp;
        }
        return result;
    }
}

